/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ecs20140526.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class ResetDisksRequest
extends Request {
    @Query
    @NameInMap(value="Disk")
    @Validation(required=true)
    private List<Disk> disk;
    @Query
    @NameInMap(value="DryRun")
    private Boolean dryRun;
    @Query
    @NameInMap(value="OwnerAccount")
    private String ownerAccount;
    @Query
    @NameInMap(value="OwnerId")
    private Long ownerId;
    @Query
    @NameInMap(value="RegionId")
    @Validation(required=true)
    private String regionId;
    @Query
    @NameInMap(value="ResourceOwnerAccount")
    private String resourceOwnerAccount;
    @Query
    @NameInMap(value="ResourceOwnerId")
    private Long resourceOwnerId;

    private ResetDisksRequest(Builder builder) {
        super((Request.Builder)builder);
        this.disk = builder.disk;
        this.dryRun = builder.dryRun;
        this.ownerAccount = builder.ownerAccount;
        this.ownerId = builder.ownerId;
        this.regionId = builder.regionId;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceOwnerId = builder.resourceOwnerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ResetDisksRequest create() {
        return ResetDisksRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<Disk> getDisk() {
        return this.disk;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public Long getOwnerId() {
        return this.ownerId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getResourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public Long getResourceOwnerId() {
        return this.resourceOwnerId;
    }

    public static class Disk
    extends TeaModel {
        @NameInMap(value="DiskId")
        private String diskId;
        @NameInMap(value="SnapshotId")
        private String snapshotId;

        private Disk(Builder builder) {
            this.diskId = builder.diskId;
            this.snapshotId = builder.snapshotId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Disk create() {
            return Disk.builder().build();
        }

        public String getDiskId() {
            return this.diskId;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public static final class Builder {
            private String diskId;
            private String snapshotId;

            public Builder diskId(String diskId) {
                this.diskId = diskId;
                return this;
            }

            public Builder snapshotId(String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            public Disk build() {
                return new Disk(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<ResetDisksRequest, Builder> {
        private List<Disk> disk;
        private Boolean dryRun;
        private String ownerAccount;
        private Long ownerId;
        private String regionId;
        private String resourceOwnerAccount;
        private Long resourceOwnerId;

        private Builder() {
        }

        private Builder(ResetDisksRequest request) {
            super((Request)request);
            this.disk = request.disk;
            this.dryRun = request.dryRun;
            this.ownerAccount = request.ownerAccount;
            this.ownerId = request.ownerId;
            this.regionId = request.regionId;
            this.resourceOwnerAccount = request.resourceOwnerAccount;
            this.resourceOwnerId = request.resourceOwnerId;
        }

        public Builder disk(List<Disk> disk) {
            this.putQueryParameter("Disk", disk);
            this.disk = disk;
            return this;
        }

        public Builder dryRun(Boolean dryRun) {
            this.putQueryParameter("DryRun", dryRun);
            this.dryRun = dryRun;
            return this;
        }

        public Builder ownerAccount(String ownerAccount) {
            this.putQueryParameter("OwnerAccount", ownerAccount);
            this.ownerAccount = ownerAccount;
            return this;
        }

        public Builder ownerId(Long ownerId) {
            this.putQueryParameter("OwnerId", ownerId);
            this.ownerId = ownerId;
            return this;
        }

        public Builder regionId(String regionId) {
            this.putQueryParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.putQueryParameter("ResourceOwnerAccount", resourceOwnerAccount);
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public Builder resourceOwnerId(Long resourceOwnerId) {
            this.putQueryParameter("ResourceOwnerId", resourceOwnerId);
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public ResetDisksRequest build() {
            return new ResetDisksRequest(this);
        }
    }
}

