/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AddVodStorageForAppRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="StorageLocation")
    private String storageLocation;
    @Query
    @NameInMap(value="StorageType")
    private String storageType;

    private AddVodStorageForAppRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.storageLocation = builder.storageLocation;
        this.storageType = builder.storageType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AddVodStorageForAppRequest create() {
        return AddVodStorageForAppRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public static final class Builder
    extends Request.Builder<AddVodStorageForAppRequest, Builder> {
        private String appId;
        private String storageLocation;
        private String storageType;

        private Builder() {
        }

        private Builder(AddVodStorageForAppRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.storageLocation = request.storageLocation;
            this.storageType = request.storageType;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder storageLocation(String storageLocation) {
            this.putQueryParameter("StorageLocation", storageLocation);
            this.storageLocation = storageLocation;
            return this;
        }

        public Builder storageType(String storageType) {
            this.putQueryParameter("StorageType", storageType);
            this.storageType = storageType;
            return this;
        }

        public AddVodStorageForAppRequest build() {
            return new AddVodStorageForAppRequest(this);
        }
    }
}

