/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AttachAppPolicyToIdentityRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    private String appId;
    @Query
    @NameInMap(value="IdentityName")
    @Validation(required=true)
    private String identityName;
    @Query
    @NameInMap(value="IdentityType")
    @Validation(required=true)
    private String identityType;
    @Query
    @NameInMap(value="PolicyNames")
    @Validation(required=true)
    private String policyNames;

    private AttachAppPolicyToIdentityRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.identityName = builder.identityName;
        this.identityType = builder.identityType;
        this.policyNames = builder.policyNames;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AttachAppPolicyToIdentityRequest create() {
        return AttachAppPolicyToIdentityRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getIdentityName() {
        return this.identityName;
    }

    public String getIdentityType() {
        return this.identityType;
    }

    public String getPolicyNames() {
        return this.policyNames;
    }

    public static final class Builder
    extends Request.Builder<AttachAppPolicyToIdentityRequest, Builder> {
        private String appId;
        private String identityName;
        private String identityType;
        private String policyNames;

        private Builder() {
        }

        private Builder(AttachAppPolicyToIdentityRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.identityName = request.identityName;
            this.identityType = request.identityType;
            this.policyNames = request.policyNames;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder identityName(String identityName) {
            this.putQueryParameter("IdentityName", identityName);
            this.identityName = identityName;
            return this;
        }

        public Builder identityType(String identityType) {
            this.putQueryParameter("IdentityType", identityType);
            this.identityType = identityType;
            return this;
        }

        public Builder policyNames(String policyNames) {
            this.putQueryParameter("PolicyNames", policyNames);
            this.policyNames = policyNames;
            return this;
        }

        public AttachAppPolicyToIdentityRequest build() {
            return new AttachAppPolicyToIdentityRequest(this);
        }
    }
}

