/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class GetAuditHistoryRequest
extends Request {
    @Query
    @NameInMap(value="PageNo")
    private Long pageNo;
    @Query
    @NameInMap(value="PageSize")
    private Long pageSize;
    @Query
    @NameInMap(value="SortBy")
    private String sortBy;
    @Query
    @NameInMap(value="VideoId")
    @Validation(required=true)
    private String videoId;

    private GetAuditHistoryRequest(Builder builder) {
        super((Request.Builder)builder);
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.sortBy = builder.sortBy;
        this.videoId = builder.videoId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GetAuditHistoryRequest create() {
        return GetAuditHistoryRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Long getPageNo() {
        return this.pageNo;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getVideoId() {
        return this.videoId;
    }

    public static final class Builder
    extends Request.Builder<GetAuditHistoryRequest, Builder> {
        private Long pageNo;
        private Long pageSize;
        private String sortBy;
        private String videoId;

        private Builder() {
        }

        private Builder(GetAuditHistoryRequest request) {
            super((Request)request);
            this.pageNo = request.pageNo;
            this.pageSize = request.pageSize;
            this.sortBy = request.sortBy;
            this.videoId = request.videoId;
        }

        public Builder pageNo(Long pageNo) {
            this.putQueryParameter("PageNo", pageNo);
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Long pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortBy(String sortBy) {
            this.putQueryParameter("SortBy", sortBy);
            this.sortBy = sortBy;
            return this;
        }

        public Builder videoId(String videoId) {
            this.putQueryParameter("VideoId", videoId);
            this.videoId = videoId;
            return this;
        }

        public GetAuditHistoryRequest build() {
            return new GetAuditHistoryRequest(this);
        }
    }
}

