/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class GetVideoPlayAuthRequest
extends Request {
    @Query
    @NameInMap(value="ApiVersion")
    private String apiVersion;
    @Query
    @NameInMap(value="AuthInfoTimeout")
    private Long authInfoTimeout;
    @Query
    @NameInMap(value="VideoId")
    @Validation(required=true)
    private String videoId;

    private GetVideoPlayAuthRequest(Builder builder) {
        super((Request.Builder)builder);
        this.apiVersion = builder.apiVersion;
        this.authInfoTimeout = builder.authInfoTimeout;
        this.videoId = builder.videoId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GetVideoPlayAuthRequest create() {
        return GetVideoPlayAuthRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Long getAuthInfoTimeout() {
        return this.authInfoTimeout;
    }

    public String getVideoId() {
        return this.videoId;
    }

    public static final class Builder
    extends Request.Builder<GetVideoPlayAuthRequest, Builder> {
        private String apiVersion;
        private Long authInfoTimeout;
        private String videoId;

        private Builder() {
        }

        private Builder(GetVideoPlayAuthRequest request) {
            super((Request)request);
            this.apiVersion = request.apiVersion;
            this.authInfoTimeout = request.authInfoTimeout;
            this.videoId = request.videoId;
        }

        public Builder apiVersion(String apiVersion) {
            this.putQueryParameter("ApiVersion", apiVersion);
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder authInfoTimeout(Long authInfoTimeout) {
            this.putQueryParameter("AuthInfoTimeout", authInfoTimeout);
            this.authInfoTimeout = authInfoTimeout;
            return this;
        }

        public Builder videoId(String videoId) {
            this.putQueryParameter("VideoId", videoId);
            this.videoId = videoId;
            return this;
        }

        public GetVideoPlayAuthRequest build() {
            return new GetVideoPlayAuthRequest(this);
        }
    }
}

