/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class MoveAppResourceRequest
extends Request {
    @Query
    @NameInMap(value="ResourceIds")
    @Validation(required=true)
    private String resourceIds;
    @Query
    @NameInMap(value="ResourceType")
    @Validation(required=true)
    private String resourceType;
    @Query
    @NameInMap(value="TargetAppId")
    @Validation(required=true)
    private String targetAppId;

    private MoveAppResourceRequest(Builder builder) {
        super((Request.Builder)builder);
        this.resourceIds = builder.resourceIds;
        this.resourceType = builder.resourceType;
        this.targetAppId = builder.targetAppId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MoveAppResourceRequest create() {
        return MoveAppResourceRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getResourceIds() {
        return this.resourceIds;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getTargetAppId() {
        return this.targetAppId;
    }

    public static final class Builder
    extends Request.Builder<MoveAppResourceRequest, Builder> {
        private String resourceIds;
        private String resourceType;
        private String targetAppId;

        private Builder() {
        }

        private Builder(MoveAppResourceRequest request) {
            super((Request)request);
            this.resourceIds = request.resourceIds;
            this.resourceType = request.resourceType;
            this.targetAppId = request.targetAppId;
        }

        public Builder resourceIds(String resourceIds) {
            this.putQueryParameter("ResourceIds", resourceIds);
            this.resourceIds = resourceIds;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.putQueryParameter("ResourceType", resourceType);
            this.resourceType = resourceType;
            return this;
        }

        public Builder targetAppId(String targetAppId) {
            this.putQueryParameter("TargetAppId", targetAppId);
            this.targetAppId = targetAppId;
            return this;
        }

        public MoveAppResourceRequest build() {
            return new MoveAppResourceRequest(this);
        }
    }
}

