/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.vod20170321.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class RestoreMediaRequest
extends Request {
    @Query
    @NameInMap(value="MediaIds")
    @Validation(required=true)
    private String mediaIds;
    @Query
    @NameInMap(value="RestoreDays")
    private String restoreDays;
    @Query
    @NameInMap(value="RestoreTier")
    private String restoreTier;
    @Query
    @NameInMap(value="Scope")
    private String scope;

    private RestoreMediaRequest(Builder builder) {
        super((Request.Builder)builder);
        this.mediaIds = builder.mediaIds;
        this.restoreDays = builder.restoreDays;
        this.restoreTier = builder.restoreTier;
        this.scope = builder.scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RestoreMediaRequest create() {
        return RestoreMediaRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getMediaIds() {
        return this.mediaIds;
    }

    public String getRestoreDays() {
        return this.restoreDays;
    }

    public String getRestoreTier() {
        return this.restoreTier;
    }

    public String getScope() {
        return this.scope;
    }

    public static final class Builder
    extends Request.Builder<RestoreMediaRequest, Builder> {
        private String mediaIds;
        private String restoreDays;
        private String restoreTier;
        private String scope;

        private Builder() {
        }

        private Builder(RestoreMediaRequest request) {
            super((Request)request);
            this.mediaIds = request.mediaIds;
            this.restoreDays = request.restoreDays;
            this.restoreTier = request.restoreTier;
            this.scope = request.scope;
        }

        public Builder mediaIds(String mediaIds) {
            this.putQueryParameter("MediaIds", mediaIds);
            this.mediaIds = mediaIds;
            return this;
        }

        public Builder restoreDays(String restoreDays) {
            this.putQueryParameter("RestoreDays", restoreDays);
            this.restoreDays = restoreDays;
            return this;
        }

        public Builder restoreTier(String restoreTier) {
            this.putQueryParameter("RestoreTier", restoreTier);
            this.restoreTier = restoreTier;
            return this;
        }

        public Builder scope(String scope) {
            this.putQueryParameter("Scope", scope);
            this.scope = scope;
            return this;
        }

        public RestoreMediaRequest build() {
            return new RestoreMediaRequest(this);
        }
    }
}

