/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.endpoint;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.endpoint.EndpointClientConfiguration;
import com.baidubce.services.endpoint.model.CreateEndpointRequest;
import com.baidubce.services.endpoint.model.CreateEndpointResponse;
import com.baidubce.services.endpoint.model.Endpoint;
import com.baidubce.services.endpoint.model.GetEndpointRequest;
import com.baidubce.services.endpoint.model.ListEndpointRequest;
import com.baidubce.services.endpoint.model.ListEndpointResponse;
import com.baidubce.services.endpoint.model.ModifyEndpointRequest;
import com.baidubce.services.endpoint.model.ReleaseEndpointRequest;
import com.baidubce.services.endpoint.model.ServiceRequest;
import com.baidubce.services.endpoint.model.ServiceResponse;
import com.baidubce.services.endpoint.model.UpdateEnterpriseSecurityGroups;
import com.baidubce.services.endpoint.model.UpdateSecurityGroups;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointClient.class);
    private static final String VERSION = "v1";
    private static final String ENDPOINT_PREFIX = "endpoint";
    private static final HttpResponseHandler[] endpointHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public EndpointClient() {
        this(new EndpointClientConfiguration());
    }

    public EndpointClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, endpointHandlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public ServiceResponse listService() {
        InternalRequest internalRequest = this.createRequest(new ServiceRequest(), HttpMethodName.GET, ENDPOINT_PREFIX, "publicService");
        return this.invokeHttpClient(internalRequest, ServiceResponse.class);
    }

    public CreateEndpointResponse createEndpoint(CreateEndpointRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Preconditions.checkNotNull((Object)request.getBilling(), (Object)"billing should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, ENDPOINT_PREFIX);
        internalRequest.addParameter("clientToken", request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateEndpointResponse.class);
    }

    public ListEndpointResponse listEndpoint(ListEndpointRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getVpcId(), "vpcId should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ENDPOINT_PREFIX);
        if (StringUtils.isNotBlank((CharSequence)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        internalRequest.addParameter("vpcId", request.getVpcId());
        if (StringUtils.isNotBlank((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getIpAddress())) {
            internalRequest.addParameter("ipAddress", request.getIpAddress());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getStatus())) {
            internalRequest.addParameter("status", request.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getSubnetId())) {
            internalRequest.addParameter("subnetId", request.getSubnetId());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getService())) {
            internalRequest.addParameter("service", request.getService());
        }
        return this.invokeHttpClient(internalRequest, ListEndpointResponse.class);
    }

    public Endpoint getEndpoint(String endpointId) {
        Validate.checkStringNotEmpty(endpointId, "endpointId should not be empty.");
        GetEndpointRequest request = new GetEndpointRequest().withEndpointId(endpointId);
        return this.getEndpoint(request);
    }

    public Endpoint getEndpoint(GetEndpointRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEndpointId(), "endpointId should not be empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, ENDPOINT_PREFIX, request.getEndpointId());
        return this.invokeHttpClient(internalRequest, Endpoint.class);
    }

    public void modifyEndpoint(ModifyEndpointRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEndpointId(), "endpointId should not be null.");
        Validate.checkMultyParamsNotBothEmpty(Arrays.asList(request.getName(), request.getDescription()), "name and description should not be all null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, ENDPOINT_PREFIX, request.getEndpointId());
        this.fillPayload(internalRequest, request);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void releaseEndpoint(ReleaseEndpointRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(request.getEndpointId(), "endpointId should not be empty.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, ENDPOINT_PREFIX, request.getEndpointId());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateSecurityGroups(UpdateSecurityGroups updateSecurityGroups) {
        Preconditions.checkNotNull((Object)updateSecurityGroups, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(updateSecurityGroups.getEndpointId(), "endpointId should not be empty.");
        if (Strings.isNullOrEmpty((String)updateSecurityGroups.getClientToken())) {
            updateSecurityGroups.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(updateSecurityGroups, HttpMethodName.PUT, ENDPOINT_PREFIX, updateSecurityGroups.getEndpointId());
        internalRequest.addParameter("bindSg", null);
        this.fillPayload(internalRequest, updateSecurityGroups);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateEnterpriseSecurityGroups(UpdateEnterpriseSecurityGroups updateSecurityGroups) {
        Preconditions.checkNotNull((Object)updateSecurityGroups, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(updateSecurityGroups.getEndpointId(), "endpointId should not be empty.");
        if (Strings.isNullOrEmpty((String)updateSecurityGroups.getClientToken())) {
            updateSecurityGroups.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(updateSecurityGroups, HttpMethodName.PUT, ENDPOINT_PREFIX, updateSecurityGroups.getEndpointId());
        internalRequest.addParameter("bindEsg", null);
        this.fillPayload(internalRequest, updateSecurityGroups);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }
}

