/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.subnet;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.subnet.SubnetClientConfiguration;
import com.baidubce.services.subnet.model.CreateIpReservedReq;
import com.baidubce.services.subnet.model.CreateIpReservedResponse;
import com.baidubce.services.subnet.model.CreateSubnetRequest;
import com.baidubce.services.subnet.model.CreateSubnetResponse;
import com.baidubce.services.subnet.model.DeleteIpReserveRequest;
import com.baidubce.services.subnet.model.DeleteSubnetRequest;
import com.baidubce.services.subnet.model.GetSubnetDetailResponse;
import com.baidubce.services.subnet.model.GetSubnetRequest;
import com.baidubce.services.subnet.model.GetSubnetResponse;
import com.baidubce.services.subnet.model.ListIpReserveRequest;
import com.baidubce.services.subnet.model.ListIpReserveResponse;
import com.baidubce.services.subnet.model.ListSubnetsRequest;
import com.baidubce.services.subnet.model.ListSubnetsResponse;
import com.baidubce.services.subnet.model.ModifySubnetAttributesRequest;
import com.baidubce.services.subnet.model.NetworkAction;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubnetClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubnetClient.class);
    private static final String VERSION = "v1";
    private static final String SUBNET_PREFIX = "subnet";
    private static final String IPRESERVE_PREFIX = "subnet/ipreserve";
    private static final HttpResponseHandler[] VPC_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public SubnetClient() {
        this(new SubnetClientConfiguration());
    }

    public SubnetClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, VPC_HANDLERS);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateSubnetResponse createSubnet(String name, String vpcId, String cidr, String zoneName) {
        CreateSubnetRequest request = new CreateSubnetRequest();
        request.withName(name).withCidr(cidr).withZoneName(zoneName).withVpcId(vpcId);
        return this.createSubnet(request);
    }

    public CreateSubnetResponse createSubnet(CreateSubnetRequest request) throws BceClientException {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        Validate.checkStringNotEmpty(request.getName(), "name should not be empty");
        Validate.checkStringNotEmpty(request.getCidr(), "cidr should not be empty");
        Validate.checkStringNotEmpty(request.getZoneName(), "zone name should not be empty");
        Validate.checkStringNotEmpty(request.getVpcId(), "vpc id should not be empty");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, SUBNET_PREFIX);
        if (!Strings.isNullOrEmpty((String)request.getClientToken())) {
            internalRequest.addParameter("clientToken", request.getClientToken());
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateSubnetResponse.class);
    }

    public ListSubnetsResponse listSubnets() {
        return this.listSubnets(new ListSubnetsRequest());
    }

    public ListSubnetsResponse listSubnets(ListSubnetsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, SUBNET_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getVpcId())) {
            internalRequest.addParameter("vpcId", request.getVpcId());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getZoneName())) {
            internalRequest.addParameter("zoneName", request.getZoneName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getSubnetType())) {
            internalRequest.addParameter("subnetType", request.getSubnetType());
        }
        return this.invokeHttpClient(internalRequest, ListSubnetsResponse.class);
    }

    @Deprecated
    public GetSubnetResponse getSubnet(String subnetId) {
        return this.getSubnet(new GetSubnetRequest().withSubnetId(subnetId));
    }

    public GetSubnetResponse getSubnet(GetSubnetRequest getSubnetRequest) {
        Preconditions.checkNotNull((Object)getSubnetRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)getSubnetRequest.getSubnetId(), (Object)"request vpcId should not be null.");
        InternalRequest internalRequest = this.createRequest(getSubnetRequest, HttpMethodName.GET, SUBNET_PREFIX, getSubnetRequest.getSubnetId());
        return this.invokeHttpClient(internalRequest, GetSubnetResponse.class);
    }

    public GetSubnetDetailResponse getSubnetDetail(String subnetId) {
        Preconditions.checkNotNull((Object)subnetId, (Object)"request subnetId should not be null.");
        InternalRequest internalRequest = this.createRequest(new GetSubnetRequest(), HttpMethodName.GET, SUBNET_PREFIX, subnetId);
        return this.invokeHttpClient(internalRequest, GetSubnetDetailResponse.class);
    }

    public void deleteSubnet(String subnetId) {
        this.deleteSubnet(new DeleteSubnetRequest().withSubnetId(subnetId));
    }

    public void deleteSubnet(DeleteSubnetRequest deleteSubnetRequest) {
        Preconditions.checkNotNull((Object)deleteSubnetRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)deleteSubnetRequest.getSubnetId(), (Object)"request subnetId should not be null.");
        if (Strings.isNullOrEmpty((String)deleteSubnetRequest.getClientToken())) {
            deleteSubnetRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(deleteSubnetRequest, HttpMethodName.DELETE, SUBNET_PREFIX, deleteSubnetRequest.getSubnetId());
        internalRequest.addParameter("clientToken", deleteSubnetRequest.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void modifySubnetAttributes(String subnetId, String name) {
        ModifySubnetAttributesRequest request = new ModifySubnetAttributesRequest();
        this.modifySubnetAttributes(request.withName(name).withSubnetId(subnetId));
    }

    public void modifySubnetAttributes(ModifySubnetAttributesRequest modifySubnetAttributesRequest) {
        Preconditions.checkNotNull((Object)modifySubnetAttributesRequest, (Object)"request should not be null.");
        Validate.checkStringNotEmpty(modifySubnetAttributesRequest.getSubnetId(), "request subnetId should not be empty.");
        Validate.checkStringNotEmpty(modifySubnetAttributesRequest.getName(), "request name should not be empty.");
        if (Strings.isNullOrEmpty((String)modifySubnetAttributesRequest.getClientToken())) {
            modifySubnetAttributesRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(modifySubnetAttributesRequest, HttpMethodName.PUT, SUBNET_PREFIX, modifySubnetAttributesRequest.getSubnetId());
        this.fillPayload(internalRequest, modifySubnetAttributesRequest);
        internalRequest.addParameter(NetworkAction.modifyAttribute.name(), null);
        internalRequest.addParameter("clientToken", modifySubnetAttributesRequest.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public CreateIpReservedResponse createIpReserved(CreateIpReservedReq createIpReservedReq) {
        if (Strings.isNullOrEmpty((String)createIpReservedReq.getClientToken())) {
            createIpReservedReq.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(createIpReservedReq, HttpMethodName.POST, IPRESERVE_PREFIX);
        this.fillPayload(internalRequest, createIpReservedReq);
        internalRequest.addParameter("clientToken", createIpReservedReq.getClientToken());
        return this.invokeHttpClient(internalRequest, CreateIpReservedResponse.class);
    }

    public void deleteIpReserve(String ipReserveId) {
        this.deleteIpReserve(new DeleteIpReserveRequest().withIpReserveId(ipReserveId));
    }

    public void deleteIpReserve(DeleteIpReserveRequest deleteIpReserveRequest) {
        Preconditions.checkNotNull((Object)deleteIpReserveRequest, (Object)"request should not be null.");
        Preconditions.checkNotNull((Object)deleteIpReserveRequest.getIpReserveId(), (Object)"request ipReserve should not be null.");
        if (Strings.isNullOrEmpty((String)deleteIpReserveRequest.getClientToken())) {
            deleteIpReserveRequest.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(deleteIpReserveRequest, HttpMethodName.DELETE, IPRESERVE_PREFIX, deleteIpReserveRequest.getIpReserveId());
        internalRequest.addParameter("clientToken", deleteIpReserveRequest.getClientToken());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public ListIpReserveResponse listIpReserve() {
        return this.listIpReserve(new ListIpReserveRequest());
    }

    public ListIpReserveResponse listIpReserve(ListIpReserveRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, IPRESERVE_PREFIX);
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getSubnetId())) {
            internalRequest.addParameter("subnetId", request.getSubnetId());
        }
        return this.invokeHttpClient(internalRequest, ListIpReserveResponse.class);
    }
}

