/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestoragehbaseclient.hbase;

import com.baidubce.services.tablestorage.model.CompressType;
import com.baidubce.services.tablestoragehbaseclient.adaptor.TableStorageAdaptor;
import com.baidubce.services.tablestoragehbaseclient.adaptor.TablestorageConfiguration;
import com.baidubce.services.tablestoragehbaseclient.adaptor.TablestorageConvertor;
import com.baidubce.services.tablestoragehbaseclient.hbase.TablestorageConnection;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.util.Pair;

public class TablestorageAdmin
implements Admin {
    private TableStorageAdaptor adaptor;
    private TablestorageConnection connection;
    private boolean aborted;

    public TablestorageAdmin(TablestorageConnection connection) {
        TablestorageConfiguration conf = connection.getTablestorageConfiguration();
        this.adaptor = new TableStorageAdaptor(conf.getEndpoint(), conf.getInstanceName(), conf.getAccessKeyId(), conf.getSecretAccessKey());
        this.connection = connection;
        this.aborted = false;
    }

    public int getOperationTimeout() {
        throw new UnsupportedOperationException("getOperationTimeout()");
    }

    public void abort(String why, Throwable e) {
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean tableExists(TableName tableName) throws IOException {
        return this.adaptor.getTable(tableName.getNameAsString()) != null;
    }

    public HTableDescriptor[] listTables() throws IOException {
        List<String> names = this.adaptor.listTable();
        return this.getTableDescriptors(names);
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        List<String> names = this.adaptor.listTable();
        ArrayList<HTableDescriptor> tableDescriptors = new ArrayList<HTableDescriptor>();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            if (!pattern.matcher(name).matches()) continue;
            HTableDescriptor descriptor = this.getTableDescriptor(TableName.valueOf((String)name));
            tableDescriptors.add(descriptor);
        }
        HTableDescriptor[] tableDescriptorArray = new HTableDescriptor[tableDescriptors.size()];
        return tableDescriptors.toArray(tableDescriptorArray);
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTables(pattern);
    }

    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables(Pattern.compile(regex));
    }

    public TableName[] listTableNames() throws IOException {
        List<String> names = this.adaptor.listTable();
        TableName[] tableNameArray = new TableName[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            tableNameArray[i] = TableName.valueOf((String)name);
        }
        return tableNameArray;
    }

    public TableName[] listTableNames(Pattern pattern) throws IOException {
        List<String> names = this.adaptor.listTable();
        ArrayList<TableName> tableNameList = new ArrayList<TableName>();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            if (!pattern.matcher(name).matches()) continue;
            tableNameList.add(TableName.valueOf((String)name));
        }
        TableName[] tableNameArray = new TableName[tableNameList.size()];
        return tableNameList.toArray(tableNameArray);
    }

    public TableName[] listTableNames(String regex) throws IOException {
        return this.listTableNames(Pattern.compile(regex));
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableNames(pattern);
    }

    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames(Pattern.compile(regex));
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName should not be null");
        HTableDescriptor descriptor = this.adaptor.getTable(tableName.getNameAsString());
        if (descriptor == null) {
            throw new TableNotFoundException(tableName);
        }
        return descriptor;
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        Preconditions.checkNotNull((Object)desc, (Object)"desc should not be null");
        if (desc.getFamilies().size() > 1) {
            throw new UnsupportedOperationException("Table only support one Family named cf0");
        }
        CompressType type = CompressType.DEFAULT;
        int maxVersions = 0;
        int ttl = -1;
        for (HColumnDescriptor descriptor : desc.getFamilies()) {
            if (!descriptor.getNameAsString().equals("cf0")) {
                throw new UnsupportedOperationException("Table only support one Family named cf0");
            }
            type = TablestorageConvertor.toCompressionType(descriptor.getCompressionType());
            maxVersions = descriptor.getMaxVersions();
            String descriptorValue = descriptor.getValue("TTL");
            ttl = -1;
            if (descriptorValue != null) {
                ttl = Integer.parseInt(descriptorValue);
            }
            if (ttl != Integer.MAX_VALUE) continue;
            ttl = 0;
        }
        this.adaptor.createTable(desc.getNameAsString(), type, maxVersions, ttl);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        throw new UnsupportedOperationException("createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions)");
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        throw new UnsupportedOperationException("createTable(HTableDescriptor desc, byte[][] splitKeys)");
    }

    public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        throw new UnsupportedOperationException("createTableAsync(HTableDescriptor desc, byte[][] splitKeys)");
    }

    public void deleteTable(TableName tableName) throws IOException {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName should not be null");
        this.adaptor.dropTable(tableName.getNameAsString());
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.deleteTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        List<String> names = this.adaptor.listTable();
        ArrayList<HTableDescriptor> tableDescriptors = new ArrayList<HTableDescriptor>();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            if (!pattern.matcher(name).matches()) continue;
            TableName tableName = TableName.valueOf((String)name);
            tableDescriptors.add(this.getTableDescriptor(tableName));
            this.deleteTable(tableName);
        }
        HTableDescriptor[] tableDescriptorArray = new HTableDescriptor[tableDescriptors.size()];
        return tableDescriptors.toArray(tableDescriptorArray);
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        throw new UnsupportedOperationException("truncateTable(TableName tableName, boolean preserveSplits)");
    }

    public void enableTable(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("enableTable(TableName tableName)");
    }

    public void enableTableAsync(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("enableTable(TableName tableName)");
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        throw new UnsupportedOperationException("enableTable(String regex)");
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("enableTable(Pattern pattern)");
    }

    public void disableTableAsync(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("disableTable(TableName tableName)");
    }

    public void disableTable(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("disableTable(TableName tableName)");
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        throw new UnsupportedOperationException("disableTable(String regex)");
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("disableTable(Pattern pattern)");
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return false;
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return false;
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName should not be null");
        return this.adaptor.isTableAvailable(tableName.getNameAsString());
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName should not be null");
        return this.isTableAvailable(tableName);
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        return null;
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return null;
    }

    public void addColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        throw new UnsupportedOperationException("addColumn(TableName tableName, HColumnDescriptor column)");
    }

    public void deleteColumn(TableName tableName, byte[] columnName) throws IOException {
        throw new UnsupportedOperationException("deleteColumn(TableName tableName, byte[] columnName)");
    }

    public void modifyColumn(TableName tableName, HColumnDescriptor descriptor) throws IOException {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName should not be null");
        Preconditions.checkNotNull((Object)descriptor, (Object)"descriptor should not be null");
        if (!descriptor.getNameAsString().equals("cf0")) {
            throw new UnsupportedOperationException("Table only support one Family named cf0");
        }
        CompressType type = TablestorageConvertor.toCompressionType(descriptor.getCompressionType());
        int maxVersions = descriptor.getMaxVersions();
        String descriptorValue = descriptor.getValue("TTL");
        int ttl = -1;
        if (descriptorValue != null) {
            ttl = Integer.parseInt(descriptorValue);
        }
        if (ttl == Integer.MAX_VALUE) {
            ttl = 0;
        }
        this.adaptor.updateTable(tableName.getNameAsString(), type, maxVersions, ttl);
    }

    public Configuration getConfiguration() {
        return this.connection.getConfiguration();
    }

    public void close() throws IOException {
        this.adaptor.close();
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        if (tableNames == null) {
            return new HTableDescriptor[0];
        }
        HTableDescriptor[] tableDescriptors = new HTableDescriptor[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            TableName tableName = tableNames.get(i);
            tableDescriptors[i] = this.getTableDescriptor(tableName);
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        if (names == null) {
            return new HTableDescriptor[0];
        }
        HTableDescriptor[] tableDescriptors = new HTableDescriptor[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            TableName tableName = TableName.valueOf((String)names.get(i));
            tableDescriptors[i] = this.getTableDescriptor(tableName);
        }
        return tableDescriptors;
    }

    public void closeRegion(String regionname, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegion(String regionname, String serverName)");
    }

    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegion(byte[] regionname, String serverName)");
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        throw new UnsupportedOperationException("closeRegion(ServerName sn, HRegionInfo hri)");
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegionWithEncodedRegionName(String encodedRegionName, String serverName)");
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        throw new UnsupportedOperationException("getOnlineRegions(ServerName sn)");
    }

    public void flush(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("flush(TableName tableName)");
    }

    public void flushRegion(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("flushRegion(byte[] regionName)");
    }

    public void compact(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("compact(TableName tableName)");
    }

    public void compact(TableName tableName, byte[] columnFamily) throws IOException {
        throw new UnsupportedOperationException("compact(TableName tableName, byte[] columnFamily)");
    }

    public void compactRegion(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("compactRegion(byte[] regionName)");
    }

    public void compactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        throw new UnsupportedOperationException("compactRegion(byte[] regionName, byte[] columnFamily)");
    }

    public void majorCompact(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("majorCompact(TableName tableName)");
    }

    public void majorCompact(TableName tableName, byte[] columnFamily) throws IOException {
        throw new UnsupportedOperationException("majorCompact(TableName tableName, byte[] columnFamily)");
    }

    public void majorCompactRegion(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("majorCompactRegion(byte[] regionName)");
    }

    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        throw new UnsupportedOperationException("majorCompactRegion(byte[] regionName, byte[] columnFamily)");
    }

    public void compactRegionServer(ServerName sn, boolean major) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("compactRegionServer(ServerName sn, boolean major)");
    }

    public void move(byte[] encodedRegionName, byte[] destServerName) throws IOException {
        throw new UnsupportedOperationException("move(byte[] encodedRegionName, byte[] destServerName)");
    }

    public void assign(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("assign(byte[] regionName)");
    }

    public void unassign(byte[] regionName, boolean force) throws IOException {
        throw new UnsupportedOperationException("unassign(byte[] regionName, boolean force)");
    }

    public void offline(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("offline(byte[] regionName)");
    }

    public boolean setBalancerRunning(boolean on, boolean synchronous) throws IOException {
        throw new UnsupportedOperationException("setBalancerRunning(boolean on, boolean synchronous)");
    }

    public boolean balancer() throws IOException {
        throw new UnsupportedOperationException("balancer()");
    }

    public boolean isBalancerEnabled() throws IOException {
        return false;
    }

    public boolean normalize() throws IOException {
        throw new UnsupportedOperationException("normalize()");
    }

    public boolean isNormalizerEnabled() throws IOException {
        return false;
    }

    public boolean setNormalizerRunning(boolean on) throws IOException {
        throw new UnsupportedOperationException("setNormalizerRunning(boolean on)");
    }

    public boolean enableCatalogJanitor(boolean enable) throws IOException {
        throw new UnsupportedOperationException("enableCatalogJanitor(boolean enable)");
    }

    public int runCatalogScan() throws IOException {
        throw new UnsupportedOperationException("runCatalogScan()");
    }

    public boolean isCatalogJanitorEnabled() throws IOException {
        return false;
    }

    public void mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) throws IOException {
        throw new UnsupportedOperationException("mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible)");
    }

    public void split(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("split(TableName tableName)");
    }

    public void split(TableName tableName, byte[] splitPoint) throws IOException {
        throw new UnsupportedOperationException("split(TableName tableName, byte[] splitPoint)");
    }

    public void splitRegion(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("splitRegion(byte[] regionName)");
    }

    public void splitRegion(byte[] regionName, byte[] splitPoint) throws IOException {
        throw new UnsupportedOperationException("splitRegion(byte[] regionName, byte[] splitPoint)");
    }

    public void modifyTable(TableName tableName, HTableDescriptor htd) throws IOException {
        throw new UnsupportedOperationException("modifyTable(TableName tableName, HTableDescriptor htd)");
    }

    public void shutdown() throws IOException {
        throw new UnsupportedOperationException("shutdown()");
    }

    public void stopMaster() throws IOException {
        throw new UnsupportedOperationException("stopMaster()");
    }

    public void stopRegionServer(String hostnamePort) throws IOException {
        throw new UnsupportedOperationException("stopRegionServer(String hostnamePort)");
    }

    public ClusterStatus getClusterStatus() throws IOException {
        throw new UnsupportedOperationException("getClusterStatus()");
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        throw new UnsupportedOperationException("createNamespace(NamespaceDescriptor descriptor)");
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        throw new UnsupportedOperationException("modifyNamespace(NamespaceDescriptor descriptor)");
    }

    public void deleteNamespace(String name) throws IOException {
        throw new UnsupportedOperationException("deleteNamespace(String name)");
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws IOException {
        throw new UnsupportedOperationException("getNamespaceDescriptor(String name)");
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        throw new UnsupportedOperationException("listNamespaceDescriptors()");
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        throw new UnsupportedOperationException("listTableDescriptorsByNamespace(String name)");
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        throw new UnsupportedOperationException("listTableNamesByNamespace(String name)");
    }

    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("getTableRegions(TableName tableName)");
    }

    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
        throw new UnsupportedOperationException("abortProcedure(long procId, boolean mayInterruptIfRunning)");
    }

    public ProcedureInfo[] listProcedures() throws IOException {
        throw new UnsupportedOperationException("listProcedures()");
    }

    public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) throws IOException {
        throw new UnsupportedOperationException("abortProcedureAsync(long procId, boolean mayInterruptIfRunning)");
    }

    public void rollWALWriter(ServerName serverName) throws IOException {
        throw new UnsupportedOperationException("rollWALWriter(ServerName serverName)");
    }

    public String[] getMasterCoprocessors() throws IOException {
        throw new UnsupportedOperationException("getMasterCoprocessors()");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("getCompactionState(TableName tableName)");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("getCompactionStateForRegion(byte[] regionName)");
    }

    public long getLastMajorCompactionTimestamp(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("getLastMajorCompactionTimestamp(TableName tableName)");
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("getLastMajorCompactionTimestampForRegion(byte[] regionName)");
    }

    public void snapshot(String snapshotName, TableName tableName) throws IOException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot(String snapshotName, TableName tableName)");
    }

    public void snapshot(byte[] snapshotName, TableName tableName) throws IOException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot(byte[] snapshotName, TableName tableName)");
    }

    public void snapshot(String snapshotName, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot(String snapshotName, TableName tableName, HBaseProtos.SnapshotDescription.Type type)");
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot(HBaseProtos.SnapshotDescription snapshot)");
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        throw new UnsupportedOperationException("takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot)");
    }

    public boolean isSnapshotFinished(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        throw new UnsupportedOperationException("isSnapshotFinished(HBaseProtos.SnapshotDescription snapshot)");
    }

    public void restoreSnapshot(byte[] snapshotName) throws IOException {
        throw new UnsupportedOperationException("restoreSnapshot(byte[] snapshotName)");
    }

    public void restoreSnapshot(String snapshotName) throws IOException {
        throw new UnsupportedOperationException("restoreSnapshot(String snapshotName)");
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) throws IOException {
        throw new UnsupportedOperationException("restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot)");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException {
        throw new UnsupportedOperationException("restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot)");
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) throws IOException {
        throw new UnsupportedOperationException("cloneSnapshot(byte[] snapshotName, TableName tableName)");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) throws IOException {
        throw new UnsupportedOperationException("cloneSnapshot(String snapshotName, TableName tableName)");
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("execProcedure(String signature, String instance, Map<String, String> props)");
    }

    public byte[] execProcedureWithRet(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("execProcedureWithRet(String signature, String instance, Map<String, String> props)");
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("isProcedureFinished(String signature, String instance, Map<String, String> props)");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        throw new UnsupportedOperationException("listSnapshots()");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String regex) throws IOException {
        throw new UnsupportedOperationException("listSnapshots(String regex)");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("listSnapshots(Pattern pattern)");
    }

    public void deleteSnapshot(byte[] snapshotName) throws IOException {
        throw new UnsupportedOperationException("deleteSnapshot(byte[] snapshotName)");
    }

    public void deleteSnapshot(String snapshotName) throws IOException {
        throw new UnsupportedOperationException("deleteSnapshot(String snapshotName)");
    }

    public void deleteSnapshots(String regex) throws IOException {
        throw new UnsupportedOperationException("deleteSnapshots(String regex)");
    }

    public void deleteSnapshots(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("deleteSnapshot(Pattern pattern)");
    }

    public void setQuota(QuotaSettings quota) throws IOException {
        throw new UnsupportedOperationException("setQuota(QuotaSettings quota)");
    }

    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) throws IOException {
        throw new UnsupportedOperationException("getQuotaRetriever(QuotaFilter filter)");
    }

    public CoprocessorRpcChannel coprocessorService() {
        throw new UnsupportedOperationException("coprocessorService()");
    }

    public CoprocessorRpcChannel coprocessorService(ServerName sn) {
        throw new UnsupportedOperationException("coprocessorService(ServerName sn)");
    }

    public void updateConfiguration(ServerName server) throws IOException {
        throw new UnsupportedOperationException("updateConfiguration(ServerName server)");
    }

    public void updateConfiguration() throws IOException {
        throw new UnsupportedOperationException("updateConfiguration()");
    }

    public int getMasterInfoPort() throws IOException {
        throw new UnsupportedOperationException("getMasterInfoPort()");
    }

    public List<SecurityCapability> getSecurityCapabilities() throws IOException {
        throw new UnsupportedOperationException("getSecurityCapabilities()");
    }
}

