/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.alarm;

import java.util.List;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * batch request for alarm (shiled and rec)
 * Created by liuzhenxing01 on 2018/10/22.
 */
public class AlarmBatchRequest extends AbstractRequest {

    private List<String> alarmIds;

    public List<String> getAlarmIds() {
        return alarmIds;
    }

    public void setAlarmIds(List<String> alarmIds) {
        this.alarmIds = alarmIds;
    }

    @Override
    public Class responseType() {
        return AlarmBatchResponse.class;
    }

    /**
     * no content , http status code is : 200
     */
    public static class AlarmBatchResponse extends AbstractBceResponse {
    }
}