/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.batch;

import java.util.List;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * the bind request model
 * Created by liuzhenxing01 on 2018/10/23.
 */
public class BindRequest extends AbstractRequest {

    private String projectId;

    private List<String> vehicleIds;

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public List<String> getVehicleIds() {
        return vehicleIds;
    }

    public void setVehicleIds(List<String> vehicleIds) {
        this.vehicleIds = vehicleIds;
    }

    @Override
    public Class responseType() {
        return BindResponse.class;
    }

    public static class BindResponse extends AbstractBceResponse {
    }
}
