/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.batch;

import java.sql.Timestamp;
import java.util.List;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * Query Instances By Batch Request
 * Created by liuzhenxing01 on 2018/10/31.
 */
public class QueryInstancesByBatchRequest extends AbstractRequest {

    @Override
    public Class responseType() {
        return QueryInstancesByBatchResponse.class;
    }

    public static class QueryInstancesByBatchResponse extends AbstractBceResponse {
        private Meta meta;
        private List<InstanceInfo> instanceInfos;

        public Meta getMeta() {
            return meta;
        }

        public void setMeta(Meta meta) {
            this.meta = meta;
        }

        public List<InstanceInfo> getInstanceInfos() {
            return instanceInfos;
        }

        public void setInstanceInfos(
                List<InstanceInfo> instanceInfos) {
            this.instanceInfos = instanceInfos;
        }
    }

    public static class Meta {
        private long total;
        private int pageNum;
        private int pageSize;

        public long getTotal() {
            return total;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public int getPageNum() {
            return pageNum;
        }

        public void setPageNum(int pageNum) {
            this.pageNum = pageNum;
        }

        public int getPageSize() {
            return pageSize;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class InstanceInfo {
        private String userId;
        private String projectId;
        private String batchId;
        private String instanceId;
        private String vehicleId;
        private String status;
        private int serviceId;
        private String deviceName;
        private Timestamp bindTime;
        private Timestamp createTime;

        public String getUserId() {
            return userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getProjectId() {
            return projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getBatchId() {
            return batchId;
        }

        public void setBatchId(String batchId) {
            this.batchId = batchId;
        }

        public String getInstanceId() {
            return instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getVehicleId() {
            return vehicleId;
        }

        public void setVehicleId(String vehicleId) {
            this.vehicleId = vehicleId;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public int getServiceId() {
            return serviceId;
        }

        public void setServiceId(int serviceId) {
            this.serviceId = serviceId;
        }

        public String getDeviceName() {
            return deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public Timestamp getBindTime() {
            return bindTime;
        }

        public void setBindTime(Timestamp bindTime) {
            this.bindTime = bindTime;
        }

        public Timestamp getCreateTime() {
            return createTime;
        }

        public void setCreateTime(Timestamp createTime) {
            this.createTime = createTime;
        }
    }
}
