/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.dynamicdata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * Vehicle dynamic attribute upload request
 * Created by liuzhenxing01 on 2018/10/19.
 */
public class DynamicPropertyRequest extends AbstractRequest {

    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String SPEED = "speed";
    public static final String DIRECTION = "direction";
    public static final String HEIGHT = "height";
    public static final String RADIUS = "radius";
    public static final String COORD_TYPE_INPUT = "coordTypeInput";

    private List<PointData> points;

    public List<PointData> getPoints() {
        return points;
    }

    public void setPoints(List<PointData> points) {
        this.points = points;
    }

    @Override
    public Class responseType() {
        return DynamicPropertyResponse.class;
    }

    public static class PointData {

        private Long locTime;
        private String vehicleId;

        private Map<String, Object> data = new HashMap<String, Object>();

        public Long getLocTime() {
            return locTime;
        }

        public void setLocTime(Long locTime) {
            this.locTime = locTime;
        }

        public String getVehicleId() {
            return vehicleId;
        }

        public void setVehicleId(String vehicleId) {
            this.vehicleId = vehicleId;
        }

        public Map<String, Object> getData() {
            return data;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public void setLatitude(Double latitude) {
            data.put(LATITUDE, latitude);
        }

        public void setLongitude(Double longitude) {
            data.put(LONGITUDE, longitude);
        }

        public void setCoordTypeInput(String coordTypeInput) {
            data.put(COORD_TYPE_INPUT, coordTypeInput);
        }

        public void setSpeed(Double speed) {
            data.put(SPEED, speed);
        }

        public void setDirection(Integer direction) {
            data.put(DIRECTION, direction);
        }

        public void setHeight(Double height) {
            data.put(HEIGHT, height);
        }

        public void setRadius(Double radius) {
            data.put(RADIUS, radius);
        }
    }

    public static class DynamicPropertyResponse extends AbstractBceResponse {
    }
}
