/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.project;

import java.util.List;

import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;

/**
 * query project list
 * Created by liuzhenxing01 on 2018/10/24.
 */
public class GetProjectListRequest extends AbstractRequest {

    @Override
    public Class responseType() {
        return GetProjectListResponse.class;
    }

    public static class GetProjectListResponse extends AbstractBceResponse {
        private Meta meta;
        private List<ProjectInfoVo> data;

        public Meta getMeta() {
            return meta;
        }

        public void setMeta(Meta meta) {
            this.meta = meta;
        }

        public List<ProjectInfoVo> getData() {
            return data;
        }

        public void setData(List<ProjectInfoVo> data) {
            this.data = data;
        }
    }

    public static class Meta {
        private long total;
        private long totalQuota;
        private long usedQuota;

        public long getTotal() {
            return total;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public long getTotalQuota() {
            return totalQuota;
        }

        public void setTotalQuota(long totalQuota) {
            this.totalQuota = totalQuota;
        }

        public long getUsedQuota() {
            return usedQuota;
        }

        public void setUsedQuota(long usedQuota) {
            this.usedQuota = usedQuota;
        }
    }
}
