/*
 * Copyright 2018 Baidu, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.dugo.shadow;

import java.util.List;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.dugo.AbstractRequest;
import com.fasterxml.jackson.databind.JsonNode;

/**
 * single shadow request and response
 * Created by liuzhenxing01 on 2018/10/18.
 */
public class SingleShadowRequest extends AbstractRequest {

    private String vehicleId;
    private List<String> fields;
    private boolean needUpdateTime;

    public String getVehicleId() {
        return vehicleId;
    }

    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public List<String> getFields() {
        return fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public boolean isNeedUpdateTime() {
        return needUpdateTime;
    }

    public void setNeedUpdateTime(boolean needUpdateTime) {
        this.needUpdateTime = needUpdateTime;
    }

    @Override
    public Class responseType() {
        return SingleShadowResponse.class;
    }

    public static class SingleShadowResponse extends AbstractBceResponse {
        private String vehicleId;
        private JsonNode data;
        private JsonNode lastUpdatedTime;

        public String getVehicleId() {
            return vehicleId;
        }

        public void setVehicleId(String vehicleId) {
            this.vehicleId = vehicleId;
        }

        public JsonNode getData() {
            return data;
        }

        public void setData(JsonNode data) {
            this.data = data;
        }

        public JsonNode getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public void setLastUpdatedTime(JsonNode lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }
    }
}
