package com.baidubce.services.route.model;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;

/**
 * Created by zhangjing60 on 17/8/2.
 */


public class CreateRouteRequest extends AbstractBceRequest {

    /**
     * The API version number
     */
    private String version;
    /**
     * An ASCII string whose length is less than 64.
     *
     * The request will be idempotent if clientToken is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     *
     */
    private String clientToken;

    /**
     * The id of the route table
     */

    private String routeTableId;

    /**
     * The source address which can be 0.0.0.0/0, otherwise, the traffic source of the routing table must belong
     * to a subnet under the VPC. When the source address is user-defined, the customer segment needs to be within
     * the existing subnet segment
     */

    private String sourceAddress;

    /**
     * The destination address which can be 0.0.0.0/0, otherwise, the destination address cannot be overlapped with
     * this VPC's cidr (except for the destination segment or the VPC's CIDR is 0.0.0.0/0)
     */

    private String destinationAddress;

    /**
     * next hop id
     * when the nexthopType is "defaultGateway",this field can be empty
     */

    private String nexthopId;

    /**
     * route type
     * The Bcc type is "custom";
     * the VPN type is "VPN";
     * the NAT type is "NAT";
     * the local gateway type is "defaultGateway""
     */

    private String nexthopType;

    /**
     *  The option param to describe the route table
     */

    private String description;

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getSourceAddress() {
        return sourceAddress;
    }

    public void setSourceAddress(String sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public String getDestinationAddress() {
        return destinationAddress;
    }

    public void setDestinationAddress(String destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public String getNexthopId() {
        return nexthopId;
    }

    public void setNexthopId(String nexthopId) {
        this.nexthopId = nexthopId;
    }

    public String getNexthopType() {
        return nexthopType;
    }

    public void setNexthopType(String nexthopType) {
        this.nexthopType = nexthopType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }


    public String getRouteTableId() {
        return routeTableId;
    }

    public void setRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
    }

    public CreateRouteRequest withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Configure optional client token for the request. The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     *
     * @param clientToken An ASCII string whose length is less than 64.
     *                    See more detail at
     *
     * @return CreateSubnetRequest with specific clientToken
     */

    public CreateRouteRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }


    /**
     * configure route table id for the request
     * @param routeTableId   the id of the route table
     * @return  CreateRouteRequest with routeTableId
     */
    public CreateRouteRequest withRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
        return this;
    }

    /**
     * configure source address for the request
     * @param sourceAddress the source address
     * @return CreateRouteRequest with source address
     */
    public CreateRouteRequest withSourceAddress(String sourceAddress) {
        this.sourceAddress = sourceAddress;
        return this;
    }

    /**
     * configure destination address for the request
     * @param destinationAddress the destination address
     * @return  CreateRouteRequest with destination address
     */
    public CreateRouteRequest withDestinationAddress(String destinationAddress) {
        this.destinationAddress = destinationAddress;
        return this;
    }

    /**
     * configure next hop id for the request
     * @param nexthopId the next hop id
     * @return CreateRouteRequest with the nexthopId
     */
    public CreateRouteRequest withNextHopId(String nexthopId) {
        this.nexthopId = nexthopId;
        return this;
    }

    /**
     * configure next hop type for the request
     * @param nexthopType the route type: BCC-"custom", VPN-"vpn", NAT-"nat"
     * @return CreateRouteRequest with the nexthopType
     */
    public CreateRouteRequest withNextHopType(String nexthopType) {
        this.nexthopType = nexthopType;
        return this;
    }

    /**
     * configure description for the request
     * @param description the description for the route table
     * @return CreateRouteRequest with the description
     */
    public CreateRouteRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return CreateRouteRequest with credentials.
     */
    @Override
    public CreateRouteRequest withRequestCredentials(BceCredentials credentials) {
        return null;
    }
}
