/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.ds;

import com.baomidou.dynamic.datasource.ds.AbstractDataSource;
import com.baomidou.dynamic.datasource.toolkit.DsStrUtils;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.dynamic.datasource.tx.ConnectionFactory;
import com.baomidou.dynamic.datasource.tx.ConnectionProxy;
import com.baomidou.dynamic.datasource.tx.TransactionContext;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public abstract class AbstractRoutingDataSource
extends AbstractDataSource {
    protected abstract DataSource determineDataSource();

    protected abstract String getPrimary();

    @Override
    public Connection getConnection() throws SQLException {
        String xid = TransactionContext.getXID();
        if (DsStrUtils.isEmpty((String)xid)) {
            return this.determineDataSource().getConnection();
        }
        String ds = DynamicDataSourceContextHolder.peek();
        ds = DsStrUtils.isEmpty((String)ds) ? this.getPrimary() : ds;
        ConnectionProxy connection = ConnectionFactory.getConnection(xid, ds);
        return connection == null ? this.getConnectionProxy(xid, ds, this.determineDataSource().getConnection()) : connection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        String xid = TransactionContext.getXID();
        if (DsStrUtils.isEmpty((String)xid)) {
            return this.determineDataSource().getConnection(username, password);
        }
        String ds = DynamicDataSourceContextHolder.peek();
        ds = DsStrUtils.isEmpty((String)ds) ? this.getPrimary() : ds;
        ConnectionProxy connection = ConnectionFactory.getConnection(xid, ds);
        return connection == null ? this.getConnectionProxy(xid, ds, this.determineDataSource().getConnection(username, password)) : connection;
    }

    private Connection getConnectionProxy(String xid, String ds, Connection connection) {
        ConnectionProxy connectionProxy = new ConnectionProxy(connection, ds);
        ConnectionFactory.putConnection(xid, ds, connectionProxy);
        return connectionProxy;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return this.determineDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || this.determineDataSource().isWrapperFor(iface);
    }
}

