/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.ui.template;

import com.blade.exception.TemplateException;
import com.blade.kit.BladeKit;
import com.blade.kit.IOKit;
import com.blade.mvc.Const;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Session;
import com.blade.mvc.ui.ModelAndView;
import com.blade.mvc.ui.template.BladeTemplate;
import com.blade.mvc.ui.template.TemplateEngine;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEngine
implements TemplateEngine {
    private static final Logger log = LoggerFactory.getLogger(DefaultEngine.class);
    public static String TEMPLATE_PATH = "templates";

    @Override
    public void render(ModelAndView modelAndView, Writer writer) throws TemplateException {
        String view = modelAndView.getView();
        String viewPath = Const.CLASSPATH + File.separator + TEMPLATE_PATH + File.separator + view;
        viewPath = viewPath.replace("//", "/");
        try {
            String body;
            if (view.startsWith("jar:")) {
                String jarPath = view.substring(4);
                InputStream input = DefaultEngine.class.getResourceAsStream(jarPath);
                BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                body = IOKit.readToString(reader);
            } else if (BladeKit.isInJar()) {
                viewPath = File.separator + TEMPLATE_PATH + File.separator + view;
                viewPath = viewPath.replace("//", "/");
                InputStream in = this.getClass().getResourceAsStream(viewPath);
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                body = IOKit.readToString(reader);
            } else {
                body = IOKit.readToString(viewPath);
            }
            Request request = WebContext.request();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            Map<String, Object> reqAttrs = request.attributes();
            attributes.putAll(reqAttrs);
            attributes.putAll(modelAndView.getModel());
            Session session = request.session();
            if (null != session) {
                attributes.putAll(session.attributes());
            }
            String result = BladeTemplate.template(body, attributes).fmt();
            writer.write(result);
        }
        catch (Exception e) {
            log.warn("View path is: {}", (Object)viewPath);
            throw new TemplateException(e);
        }
        finally {
            IOKit.closeQuietly(writer);
        }
    }
}

