/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.reconnect;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbXAResource;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.reconnect.ReconnectController;
import dm.jdbc.filter.rw.RWFilter;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.plugin.fldr.FldrConfig;
import dm.jdbc.plugin.fldr.FldrStatement;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.RowIdLifetime;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ReconnectFilter
extends BaseFilter {
    private static ReconnectController controller;

    private ReconnectFilter() {
    }

    public static ReconnectFilter getInstance() {
        return new ReconnectFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnection(DmdbConnection ret) {
        if (ret.epGroup == null || (ret.epGroup.reconnect & 4) == 0 && (ret.epGroup.reconnect & 2) == 0) {
            return;
        }
        CacheQueue<DmdbConnection> cacheQueue = ReconnectController.connQueue;
        synchronized (cacheQueue) {
            if (controller == null) {
                controller = new ReconnectController();
                controller.start();
            }
            ReconnectController.connQueue.put(ret);
        }
    }

    private boolean whenError(DmdbConnection connection, SQLException e2) throws SQLException {
        if (e2 == null) {
            return false;
        }
        if (connection == null) {
            throw e2;
        }
        if (!this.whenErrorInner(connection, DBError.getRealErrCode(e2), e2.getMessage())) {
            throw e2;
        }
        return true;
    }

    private boolean whenError(DmdbConnection connection, XAException e2) throws XAException {
        if (e2 == null) {
            return false;
        }
        try {
            int errorCode = e2.errorCode;
            String message = e2.getMessage();
            if (e2.getCause() instanceof SQLException) {
                SQLException sqle = (SQLException)e2.getCause();
                errorCode = DBError.getRealErrCode(sqle);
                message = sqle.getMessage();
            }
            if (!this.whenErrorInner(connection, errorCode, message)) {
                throw e2;
            }
        }
        catch (Exception exception) {
            throw e2;
        }
        return true;
    }

    private boolean whenErrorInner(DmdbConnection connection, int errorCode, String errorMessage) throws SQLException {
        if (connection.epGroup == null || !connection.epGroup.isReconnectWhenError()) {
            return false;
        }
        if (errorCode == DBError.EC_SWITCH_TO_EP_SEQNO.errCode) {
            block11: {
                String errMsg = errorMessage;
                int idx = errMsg.lastIndexOf("_");
                String ep = StringUtil.trimToEmpty(errMsg.substring(idx + 1));
                try {
                    connection.switchToEpSeqno = Integer.parseInt(ep);
                }
                catch (Exception exception) {
                    int i2 = ep.lastIndexOf(":");
                    if (i2 == -1) break block11;
                    connection.switchToHost = StringUtil.trimToEmpty(ep.substring(0, i2));
                    connection.switchToPort = Integer.parseInt(StringUtil.trimToEmpty(ep.substring(i2 + 1, ep.length())));
                }
            }
            if (connection.getTransFinish()) {
                connection.do_reconnect();
                return true;
            }
            connection.do_reconnect();
            DBError.ECJDBC_CONNECTION_SWITCHED.throwz(errorMessage);
        }
        if (DBError.isReconnectErrorCode(errorCode, connection)) {
            try {
                if (connection.epGroup != null && connection.epGroup.isAfterEpSelectorModify(connection.connectTime)) {
                    connection.epGroup.resetEpSelectorStart(connection.props.getInt(Configuration.epSelector) - 1);
                }
                if (connection.rwSeparate > 0) {
                    RWFilter.getInstance((int)connection.rwSeparate).rwUtil.reconnect(connection);
                } else {
                    connection.do_reconnect();
                }
            }
            catch (Throwable throwable) {
                DBError.ECJDBC_CONNECTION_SWITCH_FAILED.throwz(errorMessage);
            }
            DBError.ECJDBC_CONNECTION_SWITCHED.throwz(errorMessage);
        }
        return false;
    }

    private void afterCommitRollback(DmdbConnection connection) throws SQLException {
        if (!connection.getTransFinish() || connection.switchToEpSeqno < 0 && StringUtil.isEmpty(connection.switchToHost)) {
            return;
        }
        connection.do_reconnect();
        if (connection.epGroup.cluster == 3) {
            DriverUtil.execute(connection, "/*DMJDBC*/ alter session set 'DSC_TABLESPACE_BALANCE'=0;");
        }
    }

    private void beforeExecute(DmdbConnection connection) throws SQLException {
        if (!connection.getTransFinish() || connection.switchToEpSeqno < 0 && StringUtil.isEmpty(connection.switchToHost)) {
            return;
        }
        connection.do_reconnect();
        if (connection.epGroup.cluster == 3) {
            DriverUtil.execute(connection, "/*DMJDBC*/ alter session set 'DSC_TABLESPACE_BALANCE'=0;");
        }
    }

    @Override
    public long Blob_length(DmdbBlob blob) throws SQLException {
        try {
            return super.Blob_length(blob);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return 0L;
        }
    }

    @Override
    public byte[] Blob_getBytes(DmdbBlob blob, long pos, int length) throws SQLException {
        try {
            return super.Blob_getBytes(blob, pos, length);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream Blob_getBinaryStream(DmdbBlob blob) throws SQLException {
        try {
            return super.Blob_getBinaryStream(blob);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return null;
        }
    }

    @Override
    public long Blob_position(DmdbBlob blob, byte[] pattern, long start) throws SQLException {
        try {
            return super.Blob_position(blob, pattern, start);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return 0L;
        }
    }

    @Override
    public long Blob_position(DmdbBlob blob, Blob pattern, long start) throws SQLException {
        try {
            return super.Blob_position(blob, pattern, start);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return 0L;
        }
    }

    @Override
    public int Blob_setBytes(DmdbBlob blob, long pos, byte[] bytes) throws SQLException {
        try {
            return super.Blob_setBytes(blob, pos, bytes);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return 0;
        }
    }

    @Override
    public int Blob_setBytes(DmdbBlob blob, long pos, byte[] bytes, int offset, int len) throws SQLException {
        try {
            return super.Blob_setBytes(blob, pos, bytes, offset, len);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return 0;
        }
    }

    @Override
    public OutputStream Blob_setBinaryStream(DmdbBlob blob, long pos) throws SQLException {
        try {
            return super.Blob_setBinaryStream(blob, pos);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return null;
        }
    }

    @Override
    public void Blob_truncate(DmdbBlob blob, long len) throws SQLException {
        try {
            super.Blob_truncate(blob, len);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
        }
    }

    @Override
    public void Blob_free(DmdbBlob blob) throws SQLException {
        try {
            super.Blob_free(blob);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
        }
    }

    @Override
    public InputStream Blob_getBinaryStream(DmdbBlob blob, long pos, long length) throws SQLException {
        try {
            return super.Blob_getBinaryStream(blob, pos, length);
        }
        catch (SQLException e2) {
            this.whenError(blob.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public boolean CallableStatement_wasNull(DmdbCallableStatement callableStatement) throws SQLException {
        try {
            return super.CallableStatement_wasNull(callableStatement);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return false;
        }
    }

    @Override
    public String CallableStatement_getString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getString(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getBoolean(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return false;
        }
    }

    @Override
    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getByte(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getShort(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getInt(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getLong(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0L;
        }
    }

    @Override
    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getFloat(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0.0f;
        }
    }

    @Override
    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getDouble(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0.0;
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        try {
            return super.CallableStatement_getBigDecimal(callableStatement, parameterIndex, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getBytes(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getDate(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getTime(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getTimestamp(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getObject(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getBigDecimal(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        try {
            return super.CallableStatement_getObject(callableStatement, parameterIndex, map);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getRef(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getBlob(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getClob(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getArray(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        try {
            return super.CallableStatement_getDate(callableStatement, parameterIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        try {
            return super.CallableStatement_getTime(callableStatement, parameterIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        try {
            return super.CallableStatement_getTimestamp(callableStatement, parameterIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getURL(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setURL(DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        try {
            super.CallableStatement_setURL(callableStatement, parameterName, val);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        try {
            super.CallableStatement_setNull(callableStatement, parameterName, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBoolean(DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        try {
            super.CallableStatement_setBoolean(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setByte(DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        try {
            super.CallableStatement_setByte(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setShort(DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        try {
            super.CallableStatement_setShort(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setInt(DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        try {
            super.CallableStatement_setInt(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setLong(DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        try {
            super.CallableStatement_setLong(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setFloat(DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        try {
            super.CallableStatement_setFloat(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setDouble(DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        try {
            super.CallableStatement_setDouble(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBigDecimal(DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        try {
            super.CallableStatement_setBigDecimal(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setString(DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        try {
            super.CallableStatement_setString(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBytes(DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        try {
            super.CallableStatement_setBytes(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x2) throws SQLException {
        try {
            super.CallableStatement_setDate(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        try {
            super.CallableStatement_setTime(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        try {
            super.CallableStatement_setTimestamp(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        try {
            super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        try {
            super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        try {
            super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        try {
            super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        try {
            super.CallableStatement_setObject(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        try {
            super.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x2, Calendar cal) throws SQLException {
        try {
            super.CallableStatement_setDate(callableStatement, parameterName, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        try {
            super.CallableStatement_setTime(callableStatement, parameterName, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        try {
            super.CallableStatement_setTimestamp(callableStatement, parameterName, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        try {
            super.CallableStatement_setNull(callableStatement, parameterName, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public String CallableStatement_getString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getString(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getBoolean(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return false;
        }
    }

    @Override
    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getByte(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getShort(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getInt(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0;
        }
    }

    @Override
    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getLong(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0L;
        }
    }

    @Override
    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getFloat(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0.0f;
        }
    }

    @Override
    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getDouble(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return 0.0;
        }
    }

    @Override
    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getBytes(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getDate(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getTime(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getTimestamp(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getObject(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getBigDecimal(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        try {
            return super.CallableStatement_getObject(callableStatement, parameterName, map);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getRef(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getBlob(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getClob(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getArray(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        try {
            return super.CallableStatement_getDate(callableStatement, parameterName, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        try {
            return super.CallableStatement_getTime(callableStatement, parameterName, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        try {
            return super.CallableStatement_getTimestamp(callableStatement, parameterName, cal);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getURL(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getRowId(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getRowId(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setRowId(DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        try {
            super.CallableStatement_setRowId(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNString(DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        try {
            super.CallableStatement_setNString(callableStatement, parameterName, value);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        try {
            super.CallableStatement_setNCharacterStream(callableStatement, parameterName, value, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        try {
            super.CallableStatement_setNClob(callableStatement, parameterName, value);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        try {
            super.CallableStatement_setClob(callableStatement, parameterName, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        try {
            super.CallableStatement_setBlob(callableStatement, parameterName, inputStream, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        try {
            super.CallableStatement_setNClob(callableStatement, parameterName, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getNClob(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getNClob(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setSQLXML(DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        try {
            super.CallableStatement_setSQLXML(callableStatement, parameterName, xmlObject);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getSQLXML(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getSQLXML(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getNString(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getNString(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getNCharacterStream(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getNCharacterStream(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getCharacterStream(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getCharacterStream(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        try {
            super.CallableStatement_setBlob(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        try {
            super.CallableStatement_setClob(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        try {
            super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        try {
            super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        try {
            super.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        try {
            super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        try {
            super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        try {
            super.CallableStatement_setCharacterStream(callableStatement, parameterName, reader);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        try {
            super.CallableStatement_setNCharacterStream(callableStatement, parameterName, value);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        try {
            super.CallableStatement_setClob(callableStatement, parameterName, reader);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        try {
            super.CallableStatement_setBlob(callableStatement, parameterName, inputStream);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        try {
            super.CallableStatement_setNClob(callableStatement, parameterName, reader);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        try {
            return super.CallableStatement_getObject(callableStatement, parameterIndex, type);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        try {
            return super.CallableStatement_getObject(callableStatement, parameterName, type);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, SQLType targetSqlType) throws SQLException {
        try {
            super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, int scale) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, SQLType sqlType, String typeName) throws SQLException {
        try {
            super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public long Clob_length(DmdbClob clob) throws SQLException {
        try {
            return super.Clob_length(clob);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return 0L;
        }
    }

    @Override
    public String Clob_getSubString(DmdbClob clob, long pos, int length) throws SQLException {
        try {
            return super.Clob_getSubString(clob, pos, length);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public Reader Clob_getCharacterStream(DmdbClob clob) throws SQLException {
        try {
            return super.Clob_getCharacterStream(clob);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream Clob_getAsciiStream(DmdbClob clob) throws SQLException {
        try {
            return super.Clob_getAsciiStream(clob);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public long Clob_position(DmdbClob clob, String searchstr, long start) throws SQLException {
        try {
            return super.Clob_position(clob, searchstr, start);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return 0L;
        }
    }

    @Override
    public long Clob_position(DmdbClob clob, Clob searchstr, long start) throws SQLException {
        try {
            return super.Clob_position(clob, searchstr, start);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return 0L;
        }
    }

    @Override
    public int Clob_setString(DmdbClob clob, long pos, String str) throws SQLException {
        try {
            return super.Clob_setString(clob, pos, str);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return 0;
        }
    }

    @Override
    public int Clob_setString(DmdbClob clob, long pos, String str, int offset, int len) throws SQLException {
        try {
            return super.Clob_setString(clob, pos, str, offset, len);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return 0;
        }
    }

    @Override
    public OutputStream Clob_setAsciiStream(DmdbClob clob, long pos) throws SQLException {
        try {
            return super.Clob_setAsciiStream(clob, pos);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public Writer Clob_setCharacterStream(DmdbClob clob, long pos) throws SQLException {
        try {
            return super.Clob_setCharacterStream(clob, pos);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public void Clob_truncate(DmdbClob clob, long len) throws SQLException {
        try {
            super.Clob_truncate(clob, len);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
        }
    }

    @Override
    public void Clob_free(DmdbClob clob) throws SQLException {
        try {
            super.Clob_free(clob);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
        }
    }

    @Override
    public Reader Clob_getCharacterStream(DmdbClob clob, long pos, long length) throws SQLException {
        try {
            return super.Clob_getCharacterStream(clob, pos, length);
        }
        catch (SQLException e2) {
            this.whenError(clob.connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_reconnect(DmdbConnection connection) throws SQLException {
        try {
            super.Connection_reconnect(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection) throws SQLException {
        try {
            if (this.next != null) {
                return this.next.Connection_createStatement(connection);
            }
            return connection.do_createStatement();
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_createStatement();
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql) throws SQLException {
        try {
            if (this.next != null) {
                return this.next.Connection_prepareStatement(connection, sql);
            }
            return connection.do_prepareStatement(sql);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql);
            }
            return null;
        }
    }

    @Override
    public FldrStatement Connection_fldrStatement(DmdbConnection connection, FldrConfig config) throws SQLException {
        try {
            return super.Connection_fldrStatement(connection, config);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_fldrStatement(config);
            }
            return null;
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql) throws SQLException {
        try {
            return super.Connection_prepareCall(connection, sql);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareCall(sql);
            }
            return null;
        }
    }

    @Override
    public String Connection_nativeSQL(DmdbConnection connection, String sql) throws SQLException {
        try {
            return super.Connection_nativeSQL(connection, sql);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_setAutoCommit(DmdbConnection connection, boolean autoCommit) throws SQLException {
        try {
            super.Connection_setAutoCommit(connection, autoCommit);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public boolean Connection_getAutoCommit(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_getAutoCommit(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return false;
        }
    }

    @Override
    public void Connection_commit(DmdbConnection connection) throws SQLException {
        block2: {
            try {
                super.Connection_commit(connection);
                this.afterCommitRollback(connection);
            }
            catch (SQLException e2) {
                if (!this.whenError(connection, e2)) break block2;
                connection.do_commit();
            }
        }
    }

    @Override
    public void Connection_rollback(DmdbConnection connection) throws SQLException {
        block2: {
            try {
                super.Connection_rollback(connection);
                this.afterCommitRollback(connection);
            }
            catch (SQLException e2) {
                if (!this.whenError(connection, e2)) break block2;
                connection.do_rollback();
            }
        }
    }

    @Override
    public void Connection_close(DmdbConnection connection) throws SQLException {
        try {
            super.Connection_close(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public boolean Connection_isClosed(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_isClosed(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return false;
        }
    }

    @Override
    public DatabaseMetaData Connection_getMetaData(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_getMetaData(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_setReadOnly(DmdbConnection connection, boolean readOnly) throws SQLException {
        try {
            super.Connection_setReadOnly(connection, readOnly);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public boolean Connection_isReadOnly(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_isReadOnly(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return false;
        }
    }

    @Override
    public void Connection_setCatalog(DmdbConnection connection, String catalog) throws SQLException {
        try {
            super.Connection_setCatalog(connection, catalog);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public String Connection_getCatalog(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_getCatalog(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_setTransactionIsolation(DmdbConnection connection, int level) throws SQLException {
        try {
            super.Connection_setTransactionIsolation(connection, level);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public int Connection_getTransactionIsolation(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_getTransactionIsolation(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return 0;
        }
    }

    @Override
    public SQLWarning Connection_getWarnings(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_getWarnings(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_clearWarnings(DmdbConnection connection) throws SQLException {
        try {
            super.Connection_clearWarnings(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (this.next != null) {
                return this.next.Connection_createStatement(connection, resultSetType, resultSetConcurrency);
            }
            return connection.do_createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_createStatement(resultSetType, resultSetConcurrency);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (this.next != null) {
                return this.next.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency);
            }
            return connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
            return null;
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return super.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareCall(sql, resultSetType, resultSetConcurrency);
            }
            return null;
        }
    }

    @Override
    public Map<String, Class<?>> Connection_getTypeMap(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_getTypeMap(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_setTypeMap(DmdbConnection connection, Map<String, Class<?>> map) throws SQLException {
        try {
            super.Connection_setTypeMap(connection, map);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public void Connection_setHoldability(DmdbConnection connection, int holdability) throws SQLException {
        try {
            super.Connection_setHoldability(connection, holdability);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public int Connection_getHoldability(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_getHoldability(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return 0;
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_setSavepoint(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection, String name) throws SQLException {
        try {
            return super.Connection_setSavepoint(connection, name);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_rollback(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        try {
            super.Connection_rollback(connection, savepoint);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public void Connection_releaseSavepoint(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        try {
            super.Connection_releaseSavepoint(connection, savepoint);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return super.Connection_createStatement(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return super.Connection_prepareStatement(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            return null;
        }
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return super.Connection_prepareCall(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.next != null) {
                return this.next.Connection_prepareStatement(connection, sql, autoGeneratedKeys);
            }
            return connection.do_prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql, autoGeneratedKeys);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.next != null) {
                return this.next.Connection_prepareStatement(connection, sql, columnIndexes);
            }
            return connection.do_prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql, columnIndexes);
            }
            return null;
        }
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection connection, String sql, String[] columnNames) throws SQLException {
        try {
            if (this.next != null) {
                return this.next.Connection_prepareStatement(connection, sql, columnNames);
            }
            return connection.do_prepareStatement(sql, columnNames);
        }
        catch (SQLException e2) {
            if (this.whenError(connection, e2)) {
                connection.do_prepareStatement(sql, columnNames);
            }
            return null;
        }
    }

    @Override
    public Clob Connection_createClob(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_createClob(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public Blob Connection_createBlob(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_createBlob(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public NClob Connection_createNClob(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_createNClob(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public SQLXML Connection_createSQLXML(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_createSQLXML(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public boolean Connection_isValid(DmdbConnection connection, int timeout) throws SQLException {
        try {
            return super.Connection_isValid(connection, timeout);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return false;
        }
    }

    @Override
    public void Connection_setClientInfo(DmdbConnection connection, String name, String value) throws SQLClientInfoException {
        super.Connection_setClientInfo(connection, name, value);
    }

    @Override
    public void Connection_setClientInfo(DmdbConnection connection, Properties properties) throws SQLClientInfoException {
        super.Connection_setClientInfo(connection, properties);
    }

    @Override
    public String Connection_getClientInfo(DmdbConnection connection, String name) throws SQLException {
        try {
            return super.Connection_getClientInfo(connection, name);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public Properties Connection_getClientInfo(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_getClientInfo(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public Array Connection_createArrayOf(DmdbConnection connection, String typeName, Object[] elements) throws SQLException {
        try {
            return super.Connection_createArrayOf(connection, typeName, elements);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public Struct Connection_createStruct(DmdbConnection connection, String typeName, Object[] attributes) throws SQLException {
        try {
            return super.Connection_createStruct(connection, typeName, attributes);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_setSchema(DmdbConnection connection, String schema) throws SQLException {
        try {
            super.Connection_setSchema(connection, schema);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public String Connection_getSchema(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_getSchema(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_abort(DmdbConnection connection, Executor executor) throws SQLException {
        try {
            super.Connection_abort(connection, executor);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public void Connection_setNetworkTimeout(DmdbConnection connection, Executor executor, int milliseconds) throws SQLException {
        try {
            super.Connection_setNetworkTimeout(connection, executor, milliseconds);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public int Connection_getNetworkTimeout(DmdbConnection connection) throws SQLException {
        try {
            return super.Connection_getNetworkTimeout(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_allProceduresAreCallable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_allProceduresAreCallable(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_allTablesAreSelectable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_allTablesAreSelectable(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getURL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getURL(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getUserName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getUserName(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_isReadOnly(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_isReadOnly(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedHigh(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_nullsAreSortedHigh(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedLow(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_nullsAreSortedLow(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtStart(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_nullsAreSortedAtStart(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtEnd(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_nullsAreSortedAtEnd(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getDatabaseProductName(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getDatabaseProductVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getDriverName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getDriverName(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getDriverVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getDriverVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public int DatabaseMetaData_getDriverMajorVersion(DmdbDatabaseMetaData databaseMetaData) {
        return super.DatabaseMetaData_getDriverMajorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDriverMinorVersion(DmdbDatabaseMetaData databaseMetaData) {
        return super.DatabaseMetaData_getDriverMinorVersion(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFiles(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_usesLocalFiles(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFilePerTable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_usesLocalFilePerTable(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsMixedCaseIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_storesUpperCaseIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_storesLowerCaseIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_storesMixedCaseIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_storesUpperCaseQuotedIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_storesLowerCaseQuotedIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_storesMixedCaseQuotedIdentifiers(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getIdentifierQuoteString(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getIdentifierQuoteString(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getSQLKeywords(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getSQLKeywords(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getNumericFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getNumericFunctions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getStringFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getStringFunctions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getSystemFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getSystemFunctions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getTimeDateFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getTimeDateFunctions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getSearchStringEscape(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getSearchStringEscape(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getExtraNameCharacters(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getExtraNameCharacters(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithAddColumn(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsAlterTableWithAddColumn(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithDropColumn(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsAlterTableWithDropColumn(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsColumnAliasing(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsColumnAliasing(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_nullPlusNonNullIsNull(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_nullPlusNonNullIsNull(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsConvert(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(DmdbDatabaseMetaData databaseMetaData, int fromType, int toType) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsConvert(databaseMetaData, fromType, toType);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTableCorrelationNames(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsTableCorrelationNames(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDifferentTableCorrelationNames(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsDifferentTableCorrelationNames(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsExpressionsInOrderBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsExpressionsInOrderBy(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOrderByUnrelated(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsOrderByUnrelated(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsGroupBy(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByUnrelated(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsGroupByUnrelated(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByBeyondSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsGroupByBeyondSelect(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsLikeEscapeClause(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsLikeEscapeClause(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleResultSets(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsMultipleResultSets(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsMultipleTransactions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsNonNullableColumns(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsNonNullableColumns(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMinimumSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsMinimumSQLGrammar(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCoreSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsCoreSQLGrammar(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsExtendedSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsExtendedSQLGrammar(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92EntryLevelSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsANSI92EntryLevelSQL(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92IntermediateSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsANSI92IntermediateSQL(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92FullSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsANSI92FullSQL(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsIntegrityEnhancementFacility(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsIntegrityEnhancementFacility(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsOuterJoins(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsFullOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsFullOuterJoins(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsLimitedOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsLimitedOuterJoins(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getSchemaTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getSchemaTerm(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getProcedureTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getProcedureTerm(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String DatabaseMetaData_getCatalogTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getCatalogTerm(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_isCatalogAtStart(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_isCatalogAtStart(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String DatabaseMetaData_getCatalogSeparator(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getCatalogSeparator(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInDataManipulation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsSchemasInDataManipulation(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInProcedureCalls(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsSchemasInProcedureCalls(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInTableDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsSchemasInTableDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInIndexDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsSchemasInIndexDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInDataManipulation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsCatalogsInDataManipulation(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInProcedureCalls(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsCatalogsInProcedureCalls(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInTableDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsCatalogsInTableDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInIndexDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsCatalogsInIndexDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedDelete(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsPositionedDelete(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedUpdate(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsPositionedUpdate(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSelectForUpdate(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsSelectForUpdate(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredProcedures(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsStoredProcedures(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInComparisons(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsSubqueriesInComparisons(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInExists(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsSubqueriesInExists(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInIns(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsSubqueriesInIns(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInQuantifieds(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsSubqueriesInQuantifieds(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsCorrelatedSubqueries(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsCorrelatedSubqueries(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsUnion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsUnion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsUnionAll(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsUnionAll(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsOpenCursorsAcrossCommit(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossRollback(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsOpenCursorsAcrossRollback(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsOpenStatementsAcrossCommit(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossRollback(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsOpenStatementsAcrossRollback(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxBinaryLiteralLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxBinaryLiteralLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCharLiteralLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxCharLiteralLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxColumnNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInGroupBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxColumnsInGroupBy(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInIndex(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxColumnsInIndex(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInOrderBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxColumnsInOrderBy(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxColumnsInSelect(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInTable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxColumnsInTable(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxConnections(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxConnections(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCursorNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxCursorNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxIndexLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxIndexLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxSchemaNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxSchemaNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxProcedureNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxProcedureNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxCatalogNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxCatalogNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxRowSize(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxRowSize(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_doesMaxRowSizeIncludeBlobs(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_doesMaxRowSizeIncludeBlobs(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxStatementLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxStatementLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxStatements(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxStatements(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxTableNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxTableNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxTablesInSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxTablesInSelect(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getMaxUserNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxUserNameLength(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getDefaultTransactionIsolation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getDefaultTransactionIsolation(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsTransactions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactionIsolationLevel(DmdbDatabaseMetaData databaseMetaData, int level) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsTransactionIsolationLevel(databaseMetaData, level);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsDataManipulationTransactionsOnly(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsDataManipulationTransactionsOnly(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionCausesTransactionCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_dataDefinitionCausesTransactionCommit(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionIgnoredInTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_dataDefinitionIgnoredInTransactions(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedures(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getProcedures(databaseMetaData, catalog, schemaPattern, procedureNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedureColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getProcedureColumns(databaseMetaData, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTables(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            return super.DatabaseMetaData_getTables(databaseMetaData, catalog, schemaPattern, tableNamePattern, types);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getSchemas(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getCatalogs(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getCatalogs(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTableTypes(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getTableTypes(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getColumnPrivileges(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getColumnPrivileges(databaseMetaData, catalog, schema, table, columnNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTablePrivileges(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getTablePrivileges(databaseMetaData, catalog, schemaPattern, tableNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getBestRowIdentifier(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            return super.DatabaseMetaData_getBestRowIdentifier(databaseMetaData, catalog, schema, table, scope, nullable);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getVersionColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        try {
            return super.DatabaseMetaData_getVersionColumns(databaseMetaData, catalog, schema, table);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getPrimaryKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        try {
            return super.DatabaseMetaData_getPrimaryKeys(databaseMetaData, catalog, schema, table);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getImportedKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        try {
            return super.DatabaseMetaData_getImportedKeys(databaseMetaData, catalog, schema, table);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getExportedKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        try {
            return super.DatabaseMetaData_getExportedKeys(databaseMetaData, catalog, schema, table);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getCrossReference(DmdbDatabaseMetaData databaseMetaData, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            return super.DatabaseMetaData_getCrossReference(databaseMetaData, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getTypeInfo(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getTypeInfo(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getIndexInfo(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            return super.DatabaseMetaData_getIndexInfo(databaseMetaData, catalog, schema, table, unique, approximate);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetType(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsResultSetType(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetConcurrency(DmdbDatabaseMetaData databaseMetaData, int type, int concurrency) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsResultSetConcurrency(databaseMetaData, type, concurrency);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_ownUpdatesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return super.DatabaseMetaData_ownUpdatesAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_ownDeletesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return super.DatabaseMetaData_ownDeletesAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_ownInsertsAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return super.DatabaseMetaData_ownInsertsAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_othersUpdatesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return super.DatabaseMetaData_othersUpdatesAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_othersDeletesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return super.DatabaseMetaData_othersDeletesAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_othersInsertsAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return super.DatabaseMetaData_othersInsertsAreVisible(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_updatesAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return super.DatabaseMetaData_updatesAreDetected(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_deletesAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return super.DatabaseMetaData_deletesAreDetected(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_insertsAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        try {
            return super.DatabaseMetaData_insertsAreDetected(databaseMetaData, type);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsBatchUpdates(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsBatchUpdates(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getUDTs(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            return super.DatabaseMetaData_getUDTs(databaseMetaData, catalog, schemaPattern, typeNamePattern, types);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public Connection DatabaseMetaData_getConnection(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getConnection(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsSavepoints(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsSavepoints(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsNamedParameters(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsNamedParameters(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleOpenResults(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsMultipleOpenResults(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsGetGeneratedKeys(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsGetGeneratedKeys(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTypes(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getSuperTypes(databaseMetaData, catalog, schemaPattern, typeNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTables(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getSuperTables(databaseMetaData, catalog, schemaPattern, tableNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getAttributes(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getAttributes(databaseMetaData, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetHoldability(DmdbDatabaseMetaData databaseMetaData, int holdability) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsResultSetHoldability(databaseMetaData, holdability);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int DatabaseMetaData_getResultSetHoldability(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getResultSetHoldability(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getDatabaseMajorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getDatabaseMajorVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getDatabaseMinorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getDatabaseMinorVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getJDBCMajorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getJDBCMajorVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getJDBCMinorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getJDBCMinorVersion(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int DatabaseMetaData_getSQLStateType(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getSQLStateType(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean DatabaseMetaData_locatorsUpdateCopy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_locatorsUpdateCopy(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStatementPooling(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsStatementPooling(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public RowIdLifetime DatabaseMetaData_getRowIdLifetime(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getRowIdLifetime(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getSchemas(databaseMetaData, catalog, schemaPattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean DatabaseMetaData_autoCommitFailureClosesAllResultSets(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_autoCommitFailureClosesAllResultSets(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getClientInfoProperties(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getClientInfoProperties(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctions(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getFunctions(databaseMetaData, catalog, schemaPattern, functionNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctionColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getFunctionColumns(databaseMetaData, catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet DatabaseMetaData_getPseudoColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            return super.DatabaseMetaData_getPseudoColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean DatabaseMetaData_generatedKeyAlwaysReturned(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_generatedKeyAlwaysReturned(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public long DatabaseMetaData_getMaxLogicalLobSize(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_getMaxLogicalLobSize(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return 0L;
        }
    }

    @Override
    public boolean DatabaseMetaData_supportsRefCursors(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return super.DatabaseMetaData_supportsRefCursors(databaseMetaData);
        }
        catch (SQLException e2) {
            this.whenError(databaseMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public Connection Driver_connect(DmDriver driver, DmProperties props) throws SQLException {
        Connection conn = super.Driver_connect(driver, props);
        this.addConnection((DmdbConnection)conn);
        return conn;
    }

    @Override
    public int ParameterMetaData_getParameterCount(DmdbParameterMetaData parameterMetaData) throws SQLException {
        try {
            return super.ParameterMetaData_getParameterCount(parameterMetaData);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int ParameterMetaData_isNullable(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return super.ParameterMetaData_isNullable(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ParameterMetaData_isSigned(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return super.ParameterMetaData_isSigned(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int ParameterMetaData_getPrecision(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return super.ParameterMetaData_getPrecision(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int ParameterMetaData_getScale(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return super.ParameterMetaData_getScale(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int ParameterMetaData_getParameterType(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return super.ParameterMetaData_getParameterType(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public String ParameterMetaData_getParameterTypeName(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return super.ParameterMetaData_getParameterTypeName(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String ParameterMetaData_getParameterClassName(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return super.ParameterMetaData_getParameterClassName(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public int ParameterMetaData_getParameterMode(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        try {
            return super.ParameterMetaData_getParameterMode(parameterMetaData, param);
        }
        catch (SQLException e2) {
            this.whenError(parameterMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            return super.PreparedStatement_executeQuery(preparedStatement);
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                return preparedStatement.do_executeQuery();
            }
            return null;
        }
    }

    @Override
    public int PreparedStatement_executeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            return super.PreparedStatement_executeUpdate(preparedStatement);
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                return preparedStatement.do_executeUpdate();
            }
            return 0;
        }
    }

    @Override
    public int[] PreparedStatement_executeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            preparedStatement.clearBatch = false;
            int[] nArray = super.PreparedStatement_executeBatch(preparedStatement);
            return nArray;
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                int[] nArray = preparedStatement.do_executeBatch();
                return nArray;
            }
            return null;
        }
        finally {
            preparedStatement.clearBatch = true;
            preparedStatement.do_clearBatch();
        }
    }

    @Override
    public long[] PreparedStatement_executeLargeBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            preparedStatement.clearBatch = false;
            long[] lArray = super.PreparedStatement_executeLargeBatch(preparedStatement);
            return lArray;
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                long[] lArray = preparedStatement.do_executeLargeBatch();
                return lArray;
            }
            return null;
        }
        finally {
            preparedStatement.clearBatch = true;
            preparedStatement.do_clearBatch();
        }
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        try {
            super.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBoolean(DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        try {
            super.PreparedStatement_setBoolean(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setByte(DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        try {
            super.PreparedStatement_setByte(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setShort(DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        try {
            super.PreparedStatement_setShort(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setInt(DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        try {
            super.PreparedStatement_setInt(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setLong(DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        try {
            super.PreparedStatement_setLong(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setFloat(DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        try {
            super.PreparedStatement_setFloat(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setDouble(DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        try {
            super.PreparedStatement_setDouble(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBigDecimal(DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        try {
            super.PreparedStatement_setBigDecimal(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setString(DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        try {
            super.PreparedStatement_setString(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBytes(DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        try {
            super.PreparedStatement_setBytes(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2) throws SQLException {
        try {
            super.PreparedStatement_setDate(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        try {
            super.PreparedStatement_setTime(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        try {
            super.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        try {
            super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setUnicodeStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        try {
            super.PreparedStatement_setUnicodeStream(preparedStatement, parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        try {
            super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_clearParameters(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            super.PreparedStatement_clearParameters(preparedStatement);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        try {
            super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        try {
            super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public boolean PreparedStatement_execute(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            return super.PreparedStatement_execute(preparedStatement);
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                return preparedStatement.do_execute();
            }
            return false;
        }
    }

    @Override
    public void PreparedStatement_addBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            super.PreparedStatement_addBatch(preparedStatement);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setRef(DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        try {
            super.PreparedStatement_setRef(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        try {
            super.PreparedStatement_setBlob(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        try {
            super.PreparedStatement_setClob(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setArray(DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        try {
            super.PreparedStatement_setArray(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            return super.PreparedStatement_getMetaData(preparedStatement);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2, Calendar cal) throws SQLException {
        try {
            super.PreparedStatement_setDate(preparedStatement, parameterIndex, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        try {
            super.PreparedStatement_setTime(preparedStatement, parameterIndex, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        try {
            super.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2, cal);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            super.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType, typeName);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setURL(DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        try {
            super.PreparedStatement_setURL(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            return super.PreparedStatement_getParameterMetaData(preparedStatement);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void PreparedStatement_setRowId(DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        try {
            super.PreparedStatement_setRowId(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNString(DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        try {
            super.PreparedStatement_setNString(preparedStatement, parameterIndex, value);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        try {
            super.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        try {
            super.PreparedStatement_setNClob(preparedStatement, parameterIndex, value);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            super.PreparedStatement_setClob(preparedStatement, parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        try {
            super.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            super.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setSQLXML(DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        try {
            super.PreparedStatement_setSQLXML(preparedStatement, parameterIndex, xmlObject);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        try {
            super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        try {
            super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        try {
            super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        try {
            super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        try {
            super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        try {
            super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        try {
            super.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        try {
            super.PreparedStatement_setClob(preparedStatement, parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        try {
            super.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        try {
            super.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, SQLType targetSqlType) throws SQLException {
        try {
            super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public long PreparedStatement_executeLargeUpdate(DmdbPreparedStatement preparedStatement) throws SQLException {
        try {
            this.beforeExecute(preparedStatement.connection);
            return super.PreparedStatement_executeLargeUpdate(preparedStatement);
        }
        catch (SQLException e2) {
            if (this.whenError(preparedStatement.connection, e2)) {
                return preparedStatement.do_executeLargeUpdate();
            }
            return 0L;
        }
    }

    @Override
    public void PreparedStatement_preCompile(DmdbPreparedStatement preparedStatement, String sql) throws SQLException {
        try {
            super.PreparedStatement_preCompile(preparedStatement, sql);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setTIMESTAMP(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbTimestamp x2) throws SQLException {
        try {
            super.PreparedStatement_setTIMESTAMP(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setINTERVALYM(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        try {
            super.PreparedStatement_setINTERVALYM(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public void PreparedStatement_setINTERVALDT(DmdbPreparedStatement preparedStatement, int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        try {
            super.PreparedStatement_setINTERVALDT(preparedStatement, parameterIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(preparedStatement.connection, e2);
        }
    }

    @Override
    public boolean ResultSet_next(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_next(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public void ResultSet_close(DmdbResultSet resultSet) throws SQLException {
        try {
            super.ResultSet_close(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public boolean ResultSet_wasNull(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_wasNull(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public String ResultSet_getString(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getString(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public boolean ResultSet_getBoolean(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getBoolean(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public byte ResultSet_getByte(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getByte(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public short ResultSet_getShort(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getShort(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public int ResultSet_getInt(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getInt(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public long ResultSet_getLong(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getLong(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0L;
        }
    }

    @Override
    public float ResultSet_getFloat(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getFloat(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0.0f;
        }
    }

    @Override
    public double ResultSet_getDouble(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getDouble(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0.0;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, int columnIndex, int scale) throws SQLException {
        try {
            return super.ResultSet_getBigDecimal(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public byte[] ResultSet_getBytes(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getBytes(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getDate(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getTime(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getTimestamp(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getAsciiStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getAsciiStream(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getUnicodeStream(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getBinaryStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getBinaryStream(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public String ResultSet_getString(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getString(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public boolean ResultSet_getBoolean(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getBoolean(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public byte ResultSet_getByte(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getByte(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public short ResultSet_getShort(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getShort(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public int ResultSet_getInt(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getInt(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public long ResultSet_getLong(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getLong(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0L;
        }
    }

    @Override
    public float ResultSet_getFloat(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getFloat(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0.0f;
        }
    }

    @Override
    public double ResultSet_getDouble(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getDouble(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0.0;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, String columnLabel, int scale) throws SQLException {
        try {
            return super.ResultSet_getBigDecimal(resultSet, columnLabel, scale);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public byte[] ResultSet_getBytes(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getBytes(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getDate(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getTime(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getTimestamp(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getAsciiStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getAsciiStream(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getUnicodeStream(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public InputStream ResultSet_getBinaryStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getBinaryStream(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public SQLWarning ResultSet_getWarnings(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_getWarnings(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_clearWarnings(DmdbResultSet resultSet) throws SQLException {
        try {
            super.ResultSet_clearWarnings(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public String ResultSet_getCursorName(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_getCursorName(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSetMetaData ResultSet_getMetaData(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_getMetaData(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getObject(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getObject(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public int ResultSet_findColumn(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_findColumn(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public Reader ResultSet_getCharacterStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getCharacterStream(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Reader ResultSet_getCharacterStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getCharacterStream(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getBigDecimal(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getBigDecimal(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public boolean ResultSet_isBeforeFirst(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_isBeforeFirst(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_isAfterLast(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_isAfterLast(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_isFirst(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_isFirst(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_isLast(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_isLast(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public void ResultSet_beforeFirst(DmdbResultSet resultSet) throws SQLException {
        try {
            super.ResultSet_beforeFirst(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_afterLast(DmdbResultSet resultSet) throws SQLException {
        try {
            super.ResultSet_afterLast(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public boolean ResultSet_first(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_first(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_last(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_last(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public int ResultSet_getRow(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_getRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ResultSet_absolute(DmdbResultSet resultSet, int row) throws SQLException {
        try {
            return super.ResultSet_absolute(resultSet, row);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_relative(DmdbResultSet resultSet, int rows) throws SQLException {
        try {
            return super.ResultSet_relative(resultSet, rows);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_previous(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_previous(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public void ResultSet_setFetchDirection(DmdbResultSet resultSet, int direction) throws SQLException {
        try {
            super.ResultSet_setFetchDirection(resultSet, direction);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public int ResultSet_getFetchDirection(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_getFetchDirection(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public void ResultSet_setFetchSize(DmdbResultSet resultSet, int rows) throws SQLException {
        try {
            super.ResultSet_setFetchSize(resultSet, rows);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public int ResultSet_getFetchSize(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_getFetchSize(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public int ResultSet_getType(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_getType(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public int ResultSet_getConcurrency(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_getConcurrency(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ResultSet_rowUpdated(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_rowUpdated(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_rowInserted(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_rowInserted(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSet_rowDeleted(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_rowDeleted(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public void ResultSet_updateNull(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            super.ResultSet_updateNull(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBoolean(DmdbResultSet resultSet, int columnIndex, boolean x2) throws SQLException {
        try {
            super.ResultSet_updateBoolean(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateByte(DmdbResultSet resultSet, int columnIndex, byte x2) throws SQLException {
        try {
            super.ResultSet_updateByte(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateShort(DmdbResultSet resultSet, int columnIndex, short x2) throws SQLException {
        try {
            super.ResultSet_updateShort(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateInt(DmdbResultSet resultSet, int columnIndex, int x2) throws SQLException {
        try {
            super.ResultSet_updateInt(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateLong(DmdbResultSet resultSet, int columnIndex, long x2) throws SQLException {
        try {
            super.ResultSet_updateLong(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateFloat(DmdbResultSet resultSet, int columnIndex, float x2) throws SQLException {
        try {
            super.ResultSet_updateFloat(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateDouble(DmdbResultSet resultSet, int columnIndex, double x2) throws SQLException {
        try {
            super.ResultSet_updateDouble(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBigDecimal(DmdbResultSet resultSet, int columnIndex, BigDecimal x2) throws SQLException {
        try {
            super.ResultSet_updateBigDecimal(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateString(DmdbResultSet resultSet, int columnIndex, String x2) throws SQLException {
        try {
            super.ResultSet_updateString(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBytes(DmdbResultSet resultSet, int columnIndex, byte[] x2) throws SQLException {
        try {
            super.ResultSet_updateBytes(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateDate(DmdbResultSet resultSet, int columnIndex, Date x2) throws SQLException {
        try {
            super.ResultSet_updateDate(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateTime(DmdbResultSet resultSet, int columnIndex, Time x2) throws SQLException {
        try {
            super.ResultSet_updateTime(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateTimestamp(DmdbResultSet resultSet, int columnIndex, Timestamp x2) throws SQLException {
        try {
            super.ResultSet_updateTimestamp(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        try {
            super.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        try {
            super.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, int length) throws SQLException {
        try {
            super.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2, int scaleOrLength) throws SQLException {
        try {
            super.ResultSet_updateObject(resultSet, columnIndex, x2, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2) throws SQLException {
        try {
            super.ResultSet_updateObject(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNull(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            super.ResultSet_updateNull(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBoolean(DmdbResultSet resultSet, String columnLabel, boolean x2) throws SQLException {
        try {
            super.ResultSet_updateBoolean(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateByte(DmdbResultSet resultSet, String columnLabel, byte x2) throws SQLException {
        try {
            super.ResultSet_updateByte(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateShort(DmdbResultSet resultSet, String columnLabel, short x2) throws SQLException {
        try {
            super.ResultSet_updateShort(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateInt(DmdbResultSet resultSet, String columnLabel, int x2) throws SQLException {
        try {
            super.ResultSet_updateInt(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateLong(DmdbResultSet resultSet, String columnLabel, long x2) throws SQLException {
        try {
            super.ResultSet_updateLong(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateFloat(DmdbResultSet resultSet, String columnLabel, float x2) throws SQLException {
        try {
            super.ResultSet_updateFloat(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateDouble(DmdbResultSet resultSet, String columnLabel, double x2) throws SQLException {
        try {
            super.ResultSet_updateDouble(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBigDecimal(DmdbResultSet resultSet, String columnLabel, BigDecimal x2) throws SQLException {
        try {
            super.ResultSet_updateBigDecimal(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateString(DmdbResultSet resultSet, String columnLabel, String x2) throws SQLException {
        try {
            super.ResultSet_updateString(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBytes(DmdbResultSet resultSet, String columnLabel, byte[] x2) throws SQLException {
        try {
            super.ResultSet_updateBytes(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateDate(DmdbResultSet resultSet, String columnLabel, Date x2) throws SQLException {
        try {
            super.ResultSet_updateDate(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateTime(DmdbResultSet resultSet, String columnLabel, Time x2) throws SQLException {
        try {
            super.ResultSet_updateTime(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateTimestamp(DmdbResultSet resultSet, String columnLabel, Timestamp x2) throws SQLException {
        try {
            super.ResultSet_updateTimestamp(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        try {
            super.ResultSet_updateAsciiStream(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        try {
            super.ResultSet_updateBinaryStream(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, int length) throws SQLException {
        try {
            super.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2, int scaleOrLength) throws SQLException {
        try {
            super.ResultSet_updateObject(resultSet, columnLabel, x2, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2) throws SQLException {
        try {
            super.ResultSet_updateObject(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_insertRow(DmdbResultSet resultSet) throws SQLException {
        try {
            super.ResultSet_insertRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateRow(DmdbResultSet resultSet) throws SQLException {
        try {
            super.ResultSet_updateRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_deleteRow(DmdbResultSet resultSet) throws SQLException {
        try {
            super.ResultSet_deleteRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_refreshRow(DmdbResultSet resultSet) throws SQLException {
        try {
            super.ResultSet_refreshRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_cancelRowUpdates(DmdbResultSet resultSet) throws SQLException {
        try {
            super.ResultSet_cancelRowUpdates(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_moveToInsertRow(DmdbResultSet resultSet) throws SQLException {
        try {
            super.ResultSet_moveToInsertRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_moveToCurrentRow(DmdbResultSet resultSet) throws SQLException {
        try {
            super.ResultSet_moveToCurrentRow(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public Statement ResultSet_getStatement(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_getStatement(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        try {
            return super.ResultSet_getObject(resultSet, columnIndex, map);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Ref ResultSet_getRef(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getRef(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Blob ResultSet_getBlob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getBlob(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Clob ResultSet_getClob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getClob(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Array ResultSet_getArray(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getArray(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, String columnLabel, Map<String, Class<?>> map) throws SQLException {
        try {
            return super.ResultSet_getObject(resultSet, columnLabel, map);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Ref ResultSet_getRef(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getRef(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Blob ResultSet_getBlob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getBlob(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Clob ResultSet_getClob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getClob(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Array ResultSet_getArray(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getArray(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        try {
            return super.ResultSet_getDate(resultSet, columnIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        try {
            return super.ResultSet_getDate(resultSet, columnLabel, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        try {
            return super.ResultSet_getTime(resultSet, columnIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        try {
            return super.ResultSet_getTime(resultSet, columnLabel, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        try {
            return super.ResultSet_getTimestamp(resultSet, columnIndex, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        try {
            return super.ResultSet_getTimestamp(resultSet, columnLabel, cal);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public URL ResultSet_getURL(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getURL(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public URL ResultSet_getURL(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getURL(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_updateRef(DmdbResultSet resultSet, int columnIndex, Ref x2) throws SQLException {
        try {
            super.ResultSet_updateRef(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateRef(DmdbResultSet resultSet, String columnLabel, Ref x2) throws SQLException {
        try {
            super.ResultSet_updateRef(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, Blob x2) throws SQLException {
        try {
            super.ResultSet_updateBlob(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, Blob x2) throws SQLException {
        try {
            super.ResultSet_updateBlob(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Clob x2) throws SQLException {
        try {
            super.ResultSet_updateClob(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Clob x2) throws SQLException {
        try {
            super.ResultSet_updateClob(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateArray(DmdbResultSet resultSet, int columnIndex, Array x2) throws SQLException {
        try {
            super.ResultSet_updateArray(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateArray(DmdbResultSet resultSet, String columnLabel, Array x2) throws SQLException {
        try {
            super.ResultSet_updateArray(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public RowId ResultSet_getRowId(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getRowId(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public RowId ResultSet_getRowId(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getRowId(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_updateRowId(DmdbResultSet resultSet, int columnIndex, RowId x2) throws SQLException {
        try {
            super.ResultSet_updateRowId(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateRowId(DmdbResultSet resultSet, String columnLabel, RowId x2) throws SQLException {
        try {
            super.ResultSet_updateRowId(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public int ResultSet_getHoldability(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_getHoldability(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ResultSet_isClosed(DmdbResultSet resultSet) throws SQLException {
        try {
            return super.ResultSet_isClosed(resultSet);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return false;
        }
    }

    @Override
    public void ResultSet_updateNString(DmdbResultSet resultSet, int columnIndex, String nString) throws SQLException {
        try {
            super.ResultSet_updateNString(resultSet, columnIndex, nString);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNString(DmdbResultSet resultSet, String columnLabel, String nString) throws SQLException {
        try {
            super.ResultSet_updateNString(resultSet, columnLabel, nString);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, NClob nClob) throws SQLException {
        try {
            super.ResultSet_updateNClob(resultSet, columnIndex, nClob);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, NClob nClob) throws SQLException {
        try {
            super.ResultSet_updateNClob(resultSet, columnLabel, nClob);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public NClob ResultSet_getNClob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getNClob(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public NClob ResultSet_getNClob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getNClob(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public SQLXML ResultSet_getSQLXML(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getSQLXML(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public SQLXML ResultSet_getSQLXML(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getSQLXML(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_updateSQLXML(DmdbResultSet resultSet, int columnIndex, SQLXML xmlObject) throws SQLException {
        try {
            super.ResultSet_updateSQLXML(resultSet, columnIndex, xmlObject);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateSQLXML(DmdbResultSet resultSet, String columnLabel, SQLXML xmlObject) throws SQLException {
        try {
            super.ResultSet_updateSQLXML(resultSet, columnLabel, xmlObject);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public String ResultSet_getNString(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getNString(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public String ResultSet_getNString(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getNString(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Reader ResultSet_getNCharacterStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        try {
            return super.ResultSet_getNCharacterStream(resultSet, columnIndex);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public Reader ResultSet_getNCharacterStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        try {
            return super.ResultSet_getNCharacterStream(resultSet, columnLabel);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        try {
            super.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        try {
            super.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        try {
            super.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        try {
            super.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        try {
            super.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        try {
            super.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        try {
            super.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        try {
            super.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, InputStream inputStream, long length) throws SQLException {
        try {
            super.ResultSet_updateBlob(resultSet, columnIndex, inputStream, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, InputStream inputStream, long length) throws SQLException {
        try {
            super.ResultSet_updateBlob(resultSet, columnLabel, inputStream, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        try {
            super.ResultSet_updateClob(resultSet, columnIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        try {
            super.ResultSet_updateClob(resultSet, columnLabel, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        try {
            super.ResultSet_updateNClob(resultSet, columnIndex, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        try {
            super.ResultSet_updateNClob(resultSet, columnLabel, reader, length);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        try {
            super.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        try {
            super.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        try {
            super.ResultSet_updateAsciiStream(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        try {
            super.ResultSet_updateBinaryStream(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        try {
            super.ResultSet_updateCharacterStream(resultSet, columnIndex, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        try {
            super.ResultSet_updateAsciiStream(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        try {
            super.ResultSet_updateBinaryStream(resultSet, columnLabel, x2);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        try {
            super.ResultSet_updateCharacterStream(resultSet, columnLabel, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, InputStream inputStream) throws SQLException {
        try {
            super.ResultSet_updateBlob(resultSet, columnIndex, inputStream);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, InputStream inputStream) throws SQLException {
        try {
            super.ResultSet_updateBlob(resultSet, columnLabel, inputStream);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        try {
            super.ResultSet_updateClob(resultSet, columnIndex, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        try {
            super.ResultSet_updateClob(resultSet, columnLabel, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        try {
            super.ResultSet_updateNClob(resultSet, columnIndex, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        try {
            super.ResultSet_updateNClob(resultSet, columnLabel, reader);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public <T> T ResultSet_getObject(DmdbResultSet resultSet, int columnIndex, Class<T> type) throws SQLException {
        try {
            return super.ResultSet_getObject(resultSet, columnIndex, type);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public <T> T ResultSet_getObject(DmdbResultSet resultSet, String columnLabel, Class<T> type) throws SQLException {
        try {
            return super.ResultSet_getObject(resultSet, columnLabel, type);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
            return null;
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            super.ResultSet_updateObject(resultSet, columnIndex, x2, targetSqlType, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            super.ResultSet_updateObject(resultSet, columnLabel, x2, targetSqlType, scaleOrLength);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2, SQLType targetSqlType) throws SQLException {
        try {
            super.ResultSet_updateObject(resultSet, columnIndex, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2, SQLType targetSqlType) throws SQLException {
        try {
            super.ResultSet_updateObject(resultSet, columnLabel, x2, targetSqlType);
        }
        catch (SQLException e2) {
            this.whenError(resultSet.connection, e2);
        }
    }

    @Override
    public int ResultSetMetaData_getColumnCount(DmdbResultSetMetaData resultSetMetaData) throws SQLException {
        try {
            return super.ResultSetMetaData_getColumnCount(resultSetMetaData);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ResultSetMetaData_isAutoIncrement(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_isAutoIncrement(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isCaseSensitive(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_isCaseSensitive(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isSearchable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_isSearchable(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isCurrency(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_isCurrency(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int ResultSetMetaData_isNullable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_isNullable(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean ResultSetMetaData_isSigned(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_isSigned(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public int ResultSetMetaData_getColumnDisplaySize(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_getColumnDisplaySize(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnLabel(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_getColumnLabel(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_getColumnName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String ResultSetMetaData_getSchemaName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_getSchemaName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public int ResultSetMetaData_getPrecision(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_getPrecision(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public int ResultSetMetaData_getScale(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_getScale(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public String ResultSetMetaData_getTableName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_getTableName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public String ResultSetMetaData_getCatalogName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_getCatalogName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public int ResultSetMetaData_getColumnType(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_getColumnType(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return 0;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnTypeName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_getColumnTypeName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public boolean ResultSetMetaData_isReadOnly(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_isReadOnly(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isWritable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_isWritable(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public boolean ResultSetMetaData_isDefinitelyWritable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_isDefinitelyWritable(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return false;
        }
    }

    @Override
    public String ResultSetMetaData_getColumnClassName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        try {
            return super.ResultSetMetaData_getColumnClassName(resultSetMetaData, column);
        }
        catch (SQLException e2) {
            this.whenError(resultSetMetaData.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet Statement_executeQuery(DmdbStatement statement, String sql) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_executeQuery(statement, sql);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeQuery(sql);
            }
            return null;
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_executeUpdate(statement, sql);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeUpdate(sql);
            }
            return 0;
        }
    }

    @Override
    public void Statement_close(DmdbStatement statement) throws SQLException {
        try {
            super.Statement_close(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int Statement_getMaxFieldSize(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getMaxFieldSize(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public void Statement_setMaxFieldSize(DmdbStatement statement, int max) throws SQLException {
        try {
            super.Statement_setMaxFieldSize(statement, max);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int Statement_getMaxRows(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getMaxRows(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public void Statement_setMaxRows(DmdbStatement statement, int max) throws SQLException {
        try {
            super.Statement_setMaxRows(statement, max);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public void Statement_setEscapeProcessing(DmdbStatement statement, boolean enable) throws SQLException {
        try {
            super.Statement_setEscapeProcessing(statement, enable);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int Statement_getQueryTimeout(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getQueryTimeout(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public void Statement_setQueryTimeout(DmdbStatement statement, int seconds) throws SQLException {
        try {
            super.Statement_setQueryTimeout(statement, seconds);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public void Statement_cancel(DmdbStatement statement) throws SQLException {
        try {
            super.Statement_cancel(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public SQLWarning Statement_getWarnings(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getWarnings(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public void Statement_clearWarnings(DmdbStatement statement) throws SQLException {
        try {
            super.Statement_clearWarnings(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public void Statement_setCursorName(DmdbStatement statement, String name) throws SQLException {
        try {
            super.Statement_setCursorName(statement, name);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_execute(statement, sql);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_execute(sql);
            }
            return false;
        }
    }

    @Override
    public ResultSet Statement_getResultSet(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getResultSet(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public int Statement_getUpdateCount(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getUpdateCount(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean Statement_getMoreResults(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getMoreResults(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return false;
        }
    }

    @Override
    public void Statement_setFetchDirection(DmdbStatement statement, int direction) throws SQLException {
        try {
            super.Statement_setFetchDirection(statement, direction);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int Statement_getFetchDirection(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getFetchDirection(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public void Statement_setFetchSize(DmdbStatement statement, int rows) throws SQLException {
        try {
            super.Statement_setFetchSize(statement, rows);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int Statement_getFetchSize(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getFetchSize(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public int Statement_getResultSetConcurrency(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getResultSetConcurrency(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public int Statement_getResultSetType(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getResultSetType(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public void Statement_addBatch(DmdbStatement statement, String sql) throws SQLException {
        try {
            super.Statement_addBatch(statement, sql);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public void Statement_clearBatch(DmdbStatement statement) throws SQLException {
        try {
            super.Statement_clearBatch(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public int[] Statement_executeBatch(DmdbStatement statement) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            statement.clearBatch = false;
            int[] nArray = super.Statement_executeBatch(statement);
            return nArray;
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                int[] nArray = statement.do_executeBatch();
                return nArray;
            }
            return null;
        }
        finally {
            statement.clearBatch = true;
            statement.do_clearBatch();
        }
    }

    @Override
    public Connection Statement_getConnection(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getConnection(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public boolean Statement_getMoreResults(DmdbStatement statement, int current) throws SQLException {
        try {
            return super.Statement_getMoreResults(statement, current);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return false;
        }
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getGeneratedKeys(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_executeUpdate(statement, sql, autoGeneratedKeys);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeUpdate(sql, autoGeneratedKeys);
            }
            return 0;
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_executeUpdate(statement, sql, columnIndexes);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeUpdate(sql, columnIndexes);
            }
            return 0;
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_executeUpdate(statement, sql, columnNames);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeUpdate(sql, columnNames);
            }
            return 0;
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_execute(statement, sql, autoGeneratedKeys);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_execute(sql, autoGeneratedKeys);
            }
            return false;
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_execute(statement, sql, columnIndexes);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_execute(sql, columnIndexes);
            }
            return false;
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_execute(statement, sql, columnNames);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_execute(sql, columnNames);
            }
            return false;
        }
    }

    @Override
    public int Statement_getResultSetHoldability(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getResultSetHoldability(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public boolean Statement_isClosed(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_isClosed(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return false;
        }
    }

    @Override
    public void Statement_setPoolable(DmdbStatement statement, boolean poolable) throws SQLException {
        try {
            super.Statement_setPoolable(statement, poolable);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public boolean Statement_isPoolable(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_isPoolable(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return false;
        }
    }

    @Override
    public void Statement_closeOnCompletion(DmdbStatement statement) throws SQLException {
        try {
            super.Statement_closeOnCompletion(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public boolean Statement_isCloseOnCompletion(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_isCloseOnCompletion(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return false;
        }
    }

    @Override
    public long Statement_getLargeUpdateCount(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getLargeUpdateCount(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0L;
        }
    }

    @Override
    public void Statement_setLargeMaxRows(DmdbStatement statement, long max) throws SQLException {
        try {
            super.Statement_setLargeMaxRows(statement, max);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
        }
    }

    @Override
    public long Statement_getLargeMaxRows(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getLargeMaxRows(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0L;
        }
    }

    @Override
    public long[] Statement_executeLargeBatch(DmdbStatement statement) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            statement.clearBatch = false;
            long[] lArray = super.Statement_executeLargeBatch(statement);
            return lArray;
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                long[] lArray = statement.do_executeLargeBatch();
                return lArray;
            }
            return null;
        }
        finally {
            statement.clearBatch = true;
            statement.do_clearBatch();
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_executeLargeUpdate(statement, sql);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeLargeUpdate(sql);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_executeLargeUpdate(statement, sql, autoGeneratedKeys);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeLargeUpdate(sql, autoGeneratedKeys);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, int[] columnIndexes) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_executeLargeUpdate(statement, sql, columnIndexes);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeLargeUpdate(sql, columnIndexes);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_executeLargeUpdate(DmdbStatement statement, String sql, String[] columnNames) throws SQLException {
        try {
            this.beforeExecute(statement.connection);
            return super.Statement_executeLargeUpdate(statement, sql, columnNames);
        }
        catch (SQLException e2) {
            if (this.whenError(statement.connection, e2)) {
                return statement.do_executeLargeUpdate(sql, columnNames);
            }
            return 0L;
        }
    }

    @Override
    public long Statement_getExecuteId(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getExecuteId(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0L;
        }
    }

    @Override
    public String Statement_getPrintMsg(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getPrintMsg(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public int Statement_getSqlType(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getSqlType(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return 0;
        }
    }

    @Override
    public RowId Statement_getRowId(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getRowId(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet[] Statement_getResultSets(DmdbStatement statement) throws SQLException {
        try {
            return super.Statement_getResultSets(statement);
        }
        catch (SQLException e2) {
            this.whenError(statement.connection, e2);
            return null;
        }
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getINTERVALYM(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getINTERVALDT(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getTIMESTAMP(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public ResultSet CallableStatement_getCursor(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        try {
            return super.CallableStatement_getCursor(callableStatement, parameterIndex);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void Connection_reset(DmdbConnection connection) throws SQLException {
        try {
            super.Connection_reset(connection);
        }
        catch (SQLException e2) {
            this.whenError(connection, e2);
        }
    }

    @Override
    public String Statement_getExplain(DmdbStatement dmdbStatement) {
        return super.Statement_getExplain(dmdbStatement);
    }

    @Override
    public ResultSet CallableStatement_getCursor(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        try {
            return super.CallableStatement_getCursor(callableStatement, parameterName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void CallableStatement_setINTERVALDT(DmdbCallableStatement callableStatement, String paramName, DmdbIntervalDT x2) throws SQLException {
        try {
            super.CallableStatement_setINTERVALDT(callableStatement, paramName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setINTERVALYM(DmdbCallableStatement callableStatement, String paramName, DmdbIntervalYM x2) throws SQLException {
        try {
            super.CallableStatement_setINTERVALYM(callableStatement, paramName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public void CallableStatement_setTIMESTAMP(DmdbCallableStatement callableStatement, String paramName, DmdbTimestamp x2) throws SQLException {
        try {
            super.CallableStatement_setTIMESTAMP(callableStatement, paramName, x2);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
        }
    }

    @Override
    public DmdbTimestamp CallableStatement_getTIMESTAMP(DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        try {
            return super.CallableStatement_getTIMESTAMP(callableStatement, paramName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public DmdbIntervalDT CallableStatement_getINTERVALDT(DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        try {
            return super.CallableStatement_getINTERVALDT(callableStatement, paramName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public DmdbIntervalYM CallableStatement_getINTERVALYM(DmdbCallableStatement callableStatement, String paramName) throws SQLException {
        try {
            return super.CallableStatement_getINTERVALYM(callableStatement, paramName);
        }
        catch (SQLException e2) {
            this.whenError(callableStatement.connection, e2);
            return null;
        }
    }

    @Override
    public void XAResource_start(DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        try {
            super.XAResource_start(xaResource, xid, flags);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
        }
    }

    @Override
    public void XAResource_end(DmdbXAResource xaResource, Xid xid, int flags) throws XAException {
        try {
            super.XAResource_end(xaResource, xid, flags);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
        }
    }

    @Override
    public boolean XAResource_setTransactionTimeout(DmdbXAResource xaResource, int seconds) throws XAException {
        try {
            return super.XAResource_setTransactionTimeout(xaResource, seconds);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
            return false;
        }
    }

    @Override
    public int XAResource_getTransactionTimeout(DmdbXAResource xaResource) throws XAException {
        try {
            return super.XAResource_getTransactionTimeout(xaResource);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
            return 0;
        }
    }

    @Override
    public void XAResource_rollback(DmdbXAResource xaResource, Xid xid) throws XAException {
        try {
            super.XAResource_rollback(xaResource, xid);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
        }
    }

    @Override
    public void XAResource_commit(DmdbXAResource xaResource, Xid xid, boolean onePhase) throws XAException {
        try {
            super.XAResource_commit(xaResource, xid, onePhase);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
        }
    }

    @Override
    public Xid[] XAResource_recover(DmdbXAResource xaResource, int flag) throws XAException {
        try {
            return super.XAResource_recover(xaResource, flag);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
            return null;
        }
    }

    @Override
    public int XAResource_prepare(DmdbXAResource xaResource, Xid xid) throws XAException {
        try {
            return super.XAResource_prepare(xaResource, xid);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
            return 0;
        }
    }

    @Override
    public boolean XAResource_isSameRM(DmdbXAResource xaResource, XAResource xaRes) throws XAException {
        try {
            return super.XAResource_isSameRM(xaResource, xaRes);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
            return false;
        }
    }

    @Override
    public void XAResource_forget(DmdbXAResource xaResource, Xid xid) throws XAException {
        try {
            super.XAResource_forget(xaResource, xid);
        }
        catch (XAException e2) {
            this.whenError(xaResource.conn, e2);
        }
    }
}

