/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.BaseFilter;
import dm.jdbc.filter.stat.JdbcStat;
import dm.jdbc.filter.stat.StatFlusher;
import dm.jdbc.filter.stat.StatUtil;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.conf.DmSvcConf;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.RowIdLifetime;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class StatFilter
extends BaseFilter {
    private static int maxConnSize = 1000;
    public static JdbcStat jdbcStat = new JdbcStat(maxConnSize);

    static {
        if (StringUtil.isNotEmpty(DmSvcConf.GLOBAL.statDir)) {
            StatFlusher.getInstance().start();
        }
    }

    private StatFilter() {
    }

    public static StatFilter getInstance() {
        return new StatFilter();
    }

    @Override
    public Connection Driver_connect(DmDriver driver, DmProperties props) throws SQLException {
        DmdbConnection conn = (DmdbConnection)super.Driver_connect(driver, props);
        conn.statInfo.init(conn);
        conn.statInfo.setConstructNano();
        conn.statInfo.getConnStat().incrementConn();
        return conn;
    }

    @Override
    public void Connection_reconnect(DmdbConnection connection) throws SQLException {
        connection.statInfo.init(connection);
        connection.statInfo.setConstructNano();
        connection.statInfo.getConnStat().incrementConn();
        if (this.next != null) {
            this.next.Connection_reconnect(connection);
        } else {
            connection.do_reconnect();
        }
    }

    @Override
    public void Connection_close(DmdbConnection dmdbConnection) throws SQLException {
        boolean isClosed = dmdbConnection.do_isClosed();
        if (!isClosed) {
            dmdbConnection.statInfo.getConnStat().decrementStmt(StatUtil.getActiveStmtCount(dmdbConnection));
            dmdbConnection.statInfo.getConnStat().decrementConn();
        }
        super.Connection_close(dmdbConnection);
    }

    @Override
    public void Connection_commit(DmdbConnection dmdbConnection) throws SQLException {
        super.Connection_commit(dmdbConnection);
        dmdbConnection.statInfo.getConnStat().incrementCommitCount();
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection conn) throws SQLException {
        DmdbStatement stmt = this.next != null ? (DmdbStatement)this.next.Connection_createStatement(conn) : conn.do_createStatement();
        StatUtil.statementCreateAfter(conn, stmt);
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection dmdbConnection, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbStatement stmt = this.next != null ? (DmdbStatement)this.next.Connection_createStatement(dmdbConnection, resultSetType, resultSetConcurrency) : dmdbConnection.do_createStatement(resultSetType, resultSetConcurrency);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public Statement Connection_createStatement(DmdbConnection dmdbConnection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbStatement stmt = (DmdbStatement)super.Connection_createStatement(dmdbConnection, resultSetType, resultSetConcurrency, resultSetHoldability);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection dmdbConnection, String sql) throws SQLException {
        DmdbPreparedStatement stmt = this.next != null ? (DmdbPreparedStatement)this.next.Connection_prepareStatement(dmdbConnection, sql) : dmdbConnection.do_prepareStatement(sql);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection dmdbConnection, String sql, int autoGeneratedKeys) throws SQLException {
        DmdbPreparedStatement stmt = this.next != null ? (DmdbPreparedStatement)this.next.Connection_prepareStatement(dmdbConnection, sql, autoGeneratedKeys) : dmdbConnection.do_prepareStatement(sql, autoGeneratedKeys);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection dmdbConnection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbPreparedStatement stmt = this.next != null ? (DmdbPreparedStatement)this.next.Connection_prepareStatement(dmdbConnection, sql, resultSetType, resultSetConcurrency) : dmdbConnection.do_prepareStatement(sql, resultSetType, resultSetConcurrency);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection dmdbConnection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbPreparedStatement stmt = (DmdbPreparedStatement)super.Connection_prepareStatement(dmdbConnection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection dmdbConnection, String sql, int[] columnIndexes) throws SQLException {
        DmdbPreparedStatement stmt = this.next != null ? (DmdbPreparedStatement)this.next.Connection_prepareStatement(dmdbConnection, sql, columnIndexes) : dmdbConnection.do_prepareStatement(sql, columnIndexes);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public PreparedStatement Connection_prepareStatement(DmdbConnection dmdbConnection, String sql, String[] columnNames) throws SQLException {
        DmdbPreparedStatement stmt = this.next != null ? (DmdbPreparedStatement)this.next.Connection_prepareStatement(dmdbConnection, sql, columnNames) : dmdbConnection.do_prepareStatement(sql, columnNames);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection dmdbConnection, String sql) throws SQLException {
        DmdbCallableStatement stmt = (DmdbCallableStatement)super.Connection_prepareCall(dmdbConnection, sql);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection dmdbConnection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        DmdbCallableStatement stmt = (DmdbCallableStatement)super.Connection_prepareCall(dmdbConnection, sql, resultSetType, resultSetConcurrency);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public CallableStatement Connection_prepareCall(DmdbConnection dmdbConnection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DmdbCallableStatement stmt = (DmdbCallableStatement)super.Connection_prepareCall(dmdbConnection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        StatUtil.statementCreateAfter(dmdbConnection, stmt);
        return stmt;
    }

    @Override
    public void Connection_rollback(DmdbConnection dmdbConnection) throws SQLException {
        super.Connection_rollback(dmdbConnection);
        dmdbConnection.statInfo.getConnStat().incrementRollbackCount();
    }

    @Override
    public void Connection_rollback(DmdbConnection dmdbConnection, Savepoint savepoint) throws SQLException {
        super.Connection_rollback(dmdbConnection, savepoint);
        dmdbConnection.statInfo.getConnStat().incrementRollbackCount();
    }

    @Override
    public void Statement_close(DmdbStatement dmdbStatement) throws SQLException {
        if (!dmdbStatement.do_isClosed()) {
            StatUtil.statementCloseBefore(dmdbStatement);
        }
        super.Statement_close(dmdbStatement);
    }

    @Override
    public boolean Statement_execute(DmdbStatement dmdbStatement, String sql) throws SQLException {
        StatUtil.statementExecuteBefore(dmdbStatement, sql);
        try {
            boolean firstResult = super.Statement_execute(dmdbStatement, sql);
            StatUtil.statementExecuteAfter(dmdbStatement, sql, firstResult);
            return firstResult;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement dmdbStatement, String sql, int autoGeneratedKeys) throws SQLException {
        StatUtil.statementExecuteBefore(dmdbStatement, sql);
        try {
            boolean firstResult = super.Statement_execute(dmdbStatement, sql, autoGeneratedKeys);
            StatUtil.statementExecuteAfter(dmdbStatement, sql, firstResult);
            return firstResult;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement dmdbStatement, String sql, int[] columnIndexes) throws SQLException {
        StatUtil.statementExecuteBefore(dmdbStatement, sql);
        try {
            boolean firstResult = super.Statement_execute(dmdbStatement, sql, columnIndexes);
            StatUtil.statementExecuteAfter(dmdbStatement, sql, firstResult);
            return firstResult;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public boolean Statement_execute(DmdbStatement dmdbStatement, String sql, String[] columnNames) throws SQLException {
        StatUtil.statementExecuteBefore(dmdbStatement, sql);
        try {
            boolean firstResult = super.Statement_execute(dmdbStatement, sql, columnNames);
            StatUtil.statementExecuteAfter(dmdbStatement, sql, firstResult);
            return firstResult;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public int[] Statement_executeBatch(DmdbStatement dmdbStatement) throws SQLException {
        StatUtil.statementExecuteBatchBefore(dmdbStatement);
        try {
            int[] updateCount = super.Statement_executeBatch(dmdbStatement);
            StatUtil.statementExecuteBatchAfter(dmdbStatement, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public ResultSet Statement_executeQuery(DmdbStatement dmdbStatement, String sql) throws SQLException {
        StatUtil.statementExecuteQueryBefore(dmdbStatement, sql);
        try {
            DmdbResultSet rs = (DmdbResultSet)super.Statement_executeQuery(dmdbStatement, sql);
            StatUtil.statementExecuteQueryAfter(dmdbStatement, sql, rs);
            return rs;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement dmdbStatement, String sql) throws SQLException {
        StatUtil.statementExecuteUpdateBefore(dmdbStatement, sql);
        try {
            int updateCount = super.Statement_executeUpdate(dmdbStatement, sql);
            StatUtil.statementExecuteUpdateAfter(dmdbStatement, sql, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement dmdbStatement, String sql, int autoGeneratedKeys) throws SQLException {
        StatUtil.statementExecuteUpdateBefore(dmdbStatement, sql);
        try {
            int updateCount = super.Statement_executeUpdate(dmdbStatement, sql, autoGeneratedKeys);
            StatUtil.statementExecuteUpdateAfter(dmdbStatement, sql, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement dmdbStatement, String sql, int[] columnIndexes) throws SQLException {
        StatUtil.statementExecuteUpdateBefore(dmdbStatement, sql);
        try {
            int updateCount = super.Statement_executeUpdate(dmdbStatement, sql, columnIndexes);
            StatUtil.statementExecuteUpdateAfter(dmdbStatement, sql, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public int Statement_executeUpdate(DmdbStatement dmdbStatement, String sql, String[] columnNames) throws SQLException {
        StatUtil.statementExecuteUpdateBefore(dmdbStatement, sql);
        try {
            int updateCount = super.Statement_executeUpdate(dmdbStatement, sql, columnNames);
            StatUtil.statementExecuteUpdateAfter(dmdbStatement, sql, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(dmdbStatement, e2);
            throw e2;
        }
    }

    @Override
    public void ResultSet_close(DmdbResultSet dmdbResultSet) throws SQLException {
        if (!dmdbResultSet.do_isClosed()) {
            StatUtil.resultSetCloseBefore(dmdbResultSet);
        }
        super.ResultSet_close(dmdbResultSet);
    }

    @Override
    public boolean PreparedStatement_execute(DmdbPreparedStatement rpstmt) throws SQLException {
        StatUtil.preparedStatementExecuteBefore(rpstmt);
        try {
            boolean firstResult = super.PreparedStatement_execute(rpstmt);
            StatUtil.preparedStatementExecuteAfter(rpstmt, firstResult);
            return firstResult;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(rpstmt, e2);
            throw e2;
        }
    }

    @Override
    public int[] PreparedStatement_executeBatch(DmdbPreparedStatement rpstmt) throws SQLException {
        StatUtil.preparedStatementExecuteBatchBefore(rpstmt);
        try {
            int[] updateCounts = super.PreparedStatement_executeBatch(rpstmt);
            StatUtil.preparedStatementExecuteBatchAfter(rpstmt, updateCounts);
            return updateCounts;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(rpstmt, e2);
            throw e2;
        }
    }

    @Override
    public ResultSet PreparedStatement_executeQuery(DmdbPreparedStatement rpstmt) throws SQLException {
        StatUtil.preparedStatementExecuteQueryBefore(rpstmt);
        try {
            DmdbResultSet rs = (DmdbResultSet)super.PreparedStatement_executeQuery(rpstmt);
            StatUtil.preparedStatementExecuteQueryAfter(rpstmt, rs);
            return rs;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(rpstmt, e2);
            throw e2;
        }
    }

    @Override
    public int PreparedStatement_executeUpdate(DmdbPreparedStatement rpstmt) throws SQLException {
        StatUtil.preparedStatementExecuteUpdateBefore(rpstmt);
        try {
            int updateCount = super.PreparedStatement_executeUpdate(rpstmt);
            StatUtil.preparedStatementExecuteUpdateAfter(rpstmt, updateCount);
            return updateCount;
        }
        catch (SQLException e2) {
            StatUtil.statementExecuteErrorAfter(rpstmt, e2);
            throw e2;
        }
    }

    @Override
    public void Connection_abort(DmdbConnection connection, Executor executor) throws SQLException {
        super.Connection_abort(connection, executor);
    }

    @Override
    public void Connection_clearWarnings(DmdbConnection connection) throws SQLException {
        super.Connection_clearWarnings(connection);
    }

    @Override
    public Array Connection_createArrayOf(DmdbConnection connection, String typeName, Object[] elements) throws SQLException {
        return super.Connection_createArrayOf(connection, typeName, elements);
    }

    @Override
    public Blob Connection_createBlob(DmdbConnection connection) throws SQLException {
        return super.Connection_createBlob(connection);
    }

    @Override
    public Clob Connection_createClob(DmdbConnection connection) throws SQLException {
        return super.Connection_createClob(connection);
    }

    @Override
    public NClob Connection_createNClob(DmdbConnection connection) throws SQLException {
        return super.Connection_createNClob(connection);
    }

    @Override
    public SQLXML Connection_createSQLXML(DmdbConnection connection) throws SQLException {
        return super.Connection_createSQLXML(connection);
    }

    @Override
    public Struct Connection_createStruct(DmdbConnection connection, String typeName, Object[] attributes) throws SQLException {
        return super.Connection_createStruct(connection, typeName, attributes);
    }

    @Override
    public boolean Connection_getAutoCommit(DmdbConnection connection) throws SQLException {
        return super.Connection_getAutoCommit(connection);
    }

    @Override
    public String Connection_getCatalog(DmdbConnection connection) throws SQLException {
        return super.Connection_getCatalog(connection);
    }

    @Override
    public Properties Connection_getClientInfo(DmdbConnection connection) throws SQLException {
        return super.Connection_getClientInfo(connection);
    }

    @Override
    public String Connection_getClientInfo(DmdbConnection connection, String name) throws SQLException {
        return super.Connection_getClientInfo(connection, name);
    }

    @Override
    public int Connection_getHoldability(DmdbConnection connection) throws SQLException {
        return super.Connection_getHoldability(connection);
    }

    @Override
    public DatabaseMetaData Connection_getMetaData(DmdbConnection connection) throws SQLException {
        return super.Connection_getMetaData(connection);
    }

    @Override
    public int Connection_getNetworkTimeout(DmdbConnection connection) throws SQLException {
        return super.Connection_getNetworkTimeout(connection);
    }

    @Override
    public String Connection_getSchema(DmdbConnection connection) throws SQLException {
        return super.Connection_getSchema(connection);
    }

    @Override
    public int Connection_getTransactionIsolation(DmdbConnection connection) throws SQLException {
        return super.Connection_getTransactionIsolation(connection);
    }

    @Override
    public Map<String, Class<?>> Connection_getTypeMap(DmdbConnection connection) throws SQLException {
        return super.Connection_getTypeMap(connection);
    }

    @Override
    public SQLWarning Connection_getWarnings(DmdbConnection connection) throws SQLException {
        return super.Connection_getWarnings(connection);
    }

    @Override
    public boolean Connection_isClosed(DmdbConnection connection) throws SQLException {
        return super.Connection_isClosed(connection);
    }

    @Override
    public boolean Connection_isReadOnly(DmdbConnection connection) throws SQLException {
        return super.Connection_isReadOnly(connection);
    }

    @Override
    public boolean Connection_isValid(DmdbConnection connection, int timeout) throws SQLException {
        return super.Connection_isValid(connection, timeout);
    }

    @Override
    public String Connection_nativeSQL(DmdbConnection connection, String sql) throws SQLException {
        return super.Connection_nativeSQL(connection, sql);
    }

    @Override
    public void Connection_releaseSavepoint(DmdbConnection connection, Savepoint savepoint) throws SQLException {
        super.Connection_releaseSavepoint(connection, savepoint);
    }

    @Override
    public void Connection_setAutoCommit(DmdbConnection connection, boolean autoCommit) throws SQLException {
        super.Connection_setAutoCommit(connection, autoCommit);
    }

    @Override
    public void Connection_setCatalog(DmdbConnection connection, String catalog) throws SQLException {
        super.Connection_setCatalog(connection, catalog);
    }

    @Override
    public void Connection_setClientInfo(DmdbConnection connection, Properties properties) throws SQLClientInfoException {
        super.Connection_setClientInfo(connection, properties);
    }

    @Override
    public void Connection_setClientInfo(DmdbConnection connection, String name, String value) throws SQLClientInfoException {
        super.Connection_setClientInfo(connection, name, value);
    }

    @Override
    public void Connection_setHoldability(DmdbConnection connection, int holdability) throws SQLException {
        super.Connection_setHoldability(connection, holdability);
    }

    @Override
    public void Connection_setNetworkTimeout(DmdbConnection connection, Executor executor, int milliseconds) throws SQLException {
        super.Connection_setNetworkTimeout(connection, executor, milliseconds);
    }

    @Override
    public void Connection_setReadOnly(DmdbConnection connection, boolean readOnly) throws SQLException {
        super.Connection_setReadOnly(connection, readOnly);
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection) throws SQLException {
        return super.Connection_setSavepoint(connection);
    }

    @Override
    public Savepoint Connection_setSavepoint(DmdbConnection connection, String name) throws SQLException {
        return super.Connection_setSavepoint(connection, name);
    }

    @Override
    public void Connection_setSchema(DmdbConnection connection, String schema) throws SQLException {
        super.Connection_setSchema(connection, schema);
    }

    @Override
    public void Connection_setTransactionIsolation(DmdbConnection connection, int level) throws SQLException {
        super.Connection_setTransactionIsolation(connection, level);
    }

    @Override
    public void Connection_setTypeMap(DmdbConnection connection, Map<String, Class<?>> map) throws SQLException {
        super.Connection_setTypeMap(connection, map);
    }

    @Override
    public void Statement_addBatch(DmdbStatement statement, String sql) throws SQLException {
        super.Statement_addBatch(statement, sql);
    }

    @Override
    public void Statement_cancel(DmdbStatement statement) throws SQLException {
        super.Statement_cancel(statement);
    }

    @Override
    public void Statement_clearBatch(DmdbStatement statement) throws SQLException {
        super.Statement_clearBatch(statement);
    }

    @Override
    public void Statement_clearWarnings(DmdbStatement statement) throws SQLException {
        super.Statement_clearWarnings(statement);
    }

    @Override
    public void Statement_closeOnCompletion(DmdbStatement statement) throws SQLException {
        super.Statement_closeOnCompletion(statement);
    }

    @Override
    public Connection Statement_getConnection(DmdbStatement statement) throws SQLException {
        return super.Statement_getConnection(statement);
    }

    @Override
    public int Statement_getFetchDirection(DmdbStatement statement) throws SQLException {
        return super.Statement_getFetchDirection(statement);
    }

    @Override
    public int Statement_getFetchSize(DmdbStatement statement) throws SQLException {
        return super.Statement_getFetchSize(statement);
    }

    @Override
    public ResultSet Statement_getGeneratedKeys(DmdbStatement statement) throws SQLException {
        return super.Statement_getGeneratedKeys(statement);
    }

    @Override
    public int Statement_getMaxFieldSize(DmdbStatement statement) throws SQLException {
        return super.Statement_getMaxFieldSize(statement);
    }

    @Override
    public int Statement_getMaxRows(DmdbStatement statement) throws SQLException {
        return super.Statement_getMaxRows(statement);
    }

    @Override
    public boolean Statement_getMoreResults(DmdbStatement statement) throws SQLException {
        return super.Statement_getMoreResults(statement);
    }

    @Override
    public boolean Statement_getMoreResults(DmdbStatement statement, int current) throws SQLException {
        return super.Statement_getMoreResults(statement, current);
    }

    @Override
    public int Statement_getQueryTimeout(DmdbStatement statement) throws SQLException {
        return super.Statement_getQueryTimeout(statement);
    }

    @Override
    public ResultSet Statement_getResultSet(DmdbStatement statement) throws SQLException {
        return super.Statement_getResultSet(statement);
    }

    @Override
    public int Statement_getResultSetConcurrency(DmdbStatement statement) throws SQLException {
        return super.Statement_getResultSetConcurrency(statement);
    }

    @Override
    public int Statement_getResultSetHoldability(DmdbStatement statement) throws SQLException {
        return super.Statement_getResultSetHoldability(statement);
    }

    @Override
    public int Statement_getResultSetType(DmdbStatement statement) throws SQLException {
        return super.Statement_getResultSetType(statement);
    }

    @Override
    public int Statement_getUpdateCount(DmdbStatement statement) throws SQLException {
        return super.Statement_getUpdateCount(statement);
    }

    @Override
    public SQLWarning Statement_getWarnings(DmdbStatement statement) throws SQLException {
        return super.Statement_getWarnings(statement);
    }

    @Override
    public boolean Statement_isCloseOnCompletion(DmdbStatement statement) throws SQLException {
        return super.Statement_isCloseOnCompletion(statement);
    }

    @Override
    public boolean Statement_isClosed(DmdbStatement statement) throws SQLException {
        return super.Statement_isClosed(statement);
    }

    @Override
    public boolean Statement_isPoolable(DmdbStatement statement) throws SQLException {
        return super.Statement_isPoolable(statement);
    }

    @Override
    public void Statement_setCursorName(DmdbStatement statement, String name) throws SQLException {
        super.Statement_setCursorName(statement, name);
    }

    @Override
    public void Statement_setEscapeProcessing(DmdbStatement statement, boolean enable) throws SQLException {
        super.Statement_setEscapeProcessing(statement, enable);
    }

    @Override
    public void Statement_setFetchDirection(DmdbStatement statement, int direction) throws SQLException {
        super.Statement_setFetchDirection(statement, direction);
    }

    @Override
    public void Statement_setFetchSize(DmdbStatement statement, int rows) throws SQLException {
        super.Statement_setFetchSize(statement, rows);
    }

    @Override
    public void Statement_setMaxFieldSize(DmdbStatement statement, int max) throws SQLException {
        super.Statement_setMaxFieldSize(statement, max);
    }

    @Override
    public void Statement_setMaxRows(DmdbStatement statement, int max) throws SQLException {
        super.Statement_setMaxRows(statement, max);
    }

    @Override
    public void Statement_setPoolable(DmdbStatement statement, boolean poolable) throws SQLException {
        super.Statement_setPoolable(statement, poolable);
    }

    @Override
    public void Statement_setQueryTimeout(DmdbStatement statement, int seconds) throws SQLException {
        super.Statement_setQueryTimeout(statement, seconds);
    }

    @Override
    public void PreparedStatement_addBatch(DmdbPreparedStatement preparedStatement) throws SQLException {
        super.PreparedStatement_addBatch(preparedStatement);
    }

    @Override
    public void PreparedStatement_clearParameters(DmdbPreparedStatement preparedStatement) throws SQLException {
        super.PreparedStatement_clearParameters(preparedStatement);
    }

    @Override
    public ResultSetMetaData PreparedStatement_getMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        return super.PreparedStatement_getMetaData(preparedStatement);
    }

    @Override
    public ParameterMetaData PreparedStatement_getParameterMetaData(DmdbPreparedStatement preparedStatement) throws SQLException {
        return super.PreparedStatement_getParameterMetaData(preparedStatement);
    }

    @Override
    public void PreparedStatement_setArray(DmdbPreparedStatement preparedStatement, int parameterIndex, Array x2) throws SQLException {
        super.PreparedStatement_setArray(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setAsciiStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        super.PreparedStatement_setAsciiStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBigDecimal(DmdbPreparedStatement preparedStatement, int parameterIndex, BigDecimal x2) throws SQLException {
        super.PreparedStatement_setBigDecimal(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2) throws SQLException {
        super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBinaryStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, long length) throws SQLException {
        super.PreparedStatement_setBinaryStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, Blob x2) throws SQLException {
        super.PreparedStatement_setBlob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream) throws SQLException {
        super.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream);
    }

    @Override
    public void PreparedStatement_setBlob(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream inputStream, long length) throws SQLException {
        super.PreparedStatement_setBlob(preparedStatement, parameterIndex, inputStream, length);
    }

    @Override
    public void PreparedStatement_setBoolean(DmdbPreparedStatement preparedStatement, int parameterIndex, boolean x2) throws SQLException {
        super.PreparedStatement_setBoolean(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setByte(DmdbPreparedStatement preparedStatement, int parameterIndex, byte x2) throws SQLException {
        super.PreparedStatement_setByte(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setBytes(DmdbPreparedStatement preparedStatement, int parameterIndex, byte[] x2) throws SQLException {
        super.PreparedStatement_setBytes(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, int length) throws SQLException {
        super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        super.PreparedStatement_setCharacterStream(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Clob x2) throws SQLException {
        super.PreparedStatement_setClob(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        super.PreparedStatement_setClob(preparedStatement, parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        super.PreparedStatement_setClob(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2) throws SQLException {
        super.PreparedStatement_setDate(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setDate(DmdbPreparedStatement preparedStatement, int parameterIndex, Date x2, Calendar cal) throws SQLException {
        super.PreparedStatement_setDate(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setDouble(DmdbPreparedStatement preparedStatement, int parameterIndex, double x2) throws SQLException {
        super.PreparedStatement_setDouble(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setFloat(DmdbPreparedStatement preparedStatement, int parameterIndex, float x2) throws SQLException {
        super.PreparedStatement_setFloat(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setInt(DmdbPreparedStatement preparedStatement, int parameterIndex, int x2) throws SQLException {
        super.PreparedStatement_setInt(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setLong(DmdbPreparedStatement preparedStatement, int parameterIndex, long x2) throws SQLException {
        super.PreparedStatement_setLong(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value) throws SQLException {
        super.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setNCharacterStream(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader value, long length) throws SQLException {
        super.PreparedStatement_setNCharacterStream(preparedStatement, parameterIndex, value, length);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, NClob value) throws SQLException {
        super.PreparedStatement_setNClob(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader) throws SQLException {
        super.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader);
    }

    @Override
    public void PreparedStatement_setNClob(DmdbPreparedStatement preparedStatement, int parameterIndex, Reader reader, long length) throws SQLException {
        super.PreparedStatement_setNClob(preparedStatement, parameterIndex, reader, length);
    }

    @Override
    public void PreparedStatement_setNString(DmdbPreparedStatement preparedStatement, int parameterIndex, String value) throws SQLException {
        super.PreparedStatement_setNString(preparedStatement, parameterIndex, value);
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType) throws SQLException {
        super.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType);
    }

    @Override
    public void PreparedStatement_setNull(DmdbPreparedStatement preparedStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        super.PreparedStatement_setNull(preparedStatement, parameterIndex, sqlType, typeName);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2) throws SQLException {
        super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType);
    }

    @Override
    public void PreparedStatement_setObject(DmdbPreparedStatement preparedStatement, int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        super.PreparedStatement_setObject(preparedStatement, parameterIndex, x2, targetSqlType, scaleOrLength);
    }

    @Override
    public void PreparedStatement_setRef(DmdbPreparedStatement preparedStatement, int parameterIndex, Ref x2) throws SQLException {
        super.PreparedStatement_setRef(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setRowId(DmdbPreparedStatement preparedStatement, int parameterIndex, RowId x2) throws SQLException {
        super.PreparedStatement_setRowId(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setSQLXML(DmdbPreparedStatement preparedStatement, int parameterIndex, SQLXML xmlObject) throws SQLException {
        super.PreparedStatement_setSQLXML(preparedStatement, parameterIndex, xmlObject);
    }

    @Override
    public void PreparedStatement_setShort(DmdbPreparedStatement preparedStatement, int parameterIndex, short x2) throws SQLException {
        super.PreparedStatement_setShort(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setString(DmdbPreparedStatement preparedStatement, int parameterIndex, String x2) throws SQLException {
        super.PreparedStatement_setString(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2) throws SQLException {
        super.PreparedStatement_setTime(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTime(DmdbPreparedStatement preparedStatement, int parameterIndex, Time x2, Calendar cal) throws SQLException {
        super.PreparedStatement_setTime(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2) throws SQLException {
        super.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setTimestamp(DmdbPreparedStatement preparedStatement, int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        super.PreparedStatement_setTimestamp(preparedStatement, parameterIndex, x2, cal);
    }

    @Override
    public void PreparedStatement_setURL(DmdbPreparedStatement preparedStatement, int parameterIndex, URL x2) throws SQLException {
        super.PreparedStatement_setURL(preparedStatement, parameterIndex, x2);
    }

    @Override
    public void PreparedStatement_setUnicodeStream(DmdbPreparedStatement preparedStatement, int parameterIndex, InputStream x2, int length) throws SQLException {
        super.PreparedStatement_setUnicodeStream(preparedStatement, parameterIndex, x2, length);
    }

    @Override
    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getArray(callableStatement, parameterName);
    }

    @Override
    public Array CallableStatement_getArray(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getArray(callableStatement, parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getBigDecimal(callableStatement, parameterName);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getBigDecimal(callableStatement, parameterIndex);
    }

    @Override
    public BigDecimal CallableStatement_getBigDecimal(DmdbCallableStatement callableStatement, int parameterIndex, int scale) throws SQLException {
        return super.CallableStatement_getBigDecimal(callableStatement, parameterIndex, scale);
    }

    @Override
    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getBlob(callableStatement, parameterName);
    }

    @Override
    public Blob CallableStatement_getBlob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getBlob(callableStatement, parameterIndex);
    }

    @Override
    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getBoolean(callableStatement, parameterName);
    }

    @Override
    public boolean CallableStatement_getBoolean(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getBoolean(callableStatement, parameterIndex);
    }

    @Override
    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getByte(callableStatement, parameterName);
    }

    @Override
    public byte CallableStatement_getByte(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getByte(callableStatement, parameterIndex);
    }

    @Override
    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getBytes(callableStatement, parameterName);
    }

    @Override
    public byte[] CallableStatement_getBytes(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getBytes(callableStatement, parameterIndex);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getCharacterStream(callableStatement, parameterName);
    }

    @Override
    public Reader CallableStatement_getCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getCharacterStream(callableStatement, parameterIndex);
    }

    @Override
    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getClob(callableStatement, parameterName);
    }

    @Override
    public Clob CallableStatement_getClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getClob(callableStatement, parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getDate(callableStatement, parameterName);
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return super.CallableStatement_getDate(callableStatement, parameterName, cal);
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getDate(callableStatement, parameterIndex);
    }

    @Override
    public Date CallableStatement_getDate(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return super.CallableStatement_getDate(callableStatement, parameterIndex, cal);
    }

    @Override
    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getDouble(callableStatement, parameterName);
    }

    @Override
    public double CallableStatement_getDouble(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getDouble(callableStatement, parameterIndex);
    }

    @Override
    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getFloat(callableStatement, parameterName);
    }

    @Override
    public float CallableStatement_getFloat(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getFloat(callableStatement, parameterIndex);
    }

    @Override
    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getInt(callableStatement, parameterName);
    }

    @Override
    public int CallableStatement_getInt(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getInt(callableStatement, parameterIndex);
    }

    @Override
    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getLong(callableStatement, parameterName);
    }

    @Override
    public long CallableStatement_getLong(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getLong(callableStatement, parameterIndex);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getNCharacterStream(callableStatement, parameterName);
    }

    @Override
    public Reader CallableStatement_getNCharacterStream(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getNCharacterStream(callableStatement, parameterIndex);
    }

    @Override
    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getNClob(callableStatement, parameterName);
    }

    @Override
    public NClob CallableStatement_getNClob(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getNClob(callableStatement, parameterIndex);
    }

    @Override
    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getNString(callableStatement, parameterName);
    }

    @Override
    public String CallableStatement_getNString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getNString(callableStatement, parameterIndex);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getObject(callableStatement, parameterName);
    }

    @Override
    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        return super.CallableStatement_getObject(callableStatement, parameterName, type);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, String parameterName, Map<String, Class<?>> map) throws SQLException {
        return super.CallableStatement_getObject(callableStatement, parameterName, map);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getObject(callableStatement, parameterIndex);
    }

    @Override
    public <T> T CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        return super.CallableStatement_getObject(callableStatement, parameterIndex, type);
    }

    @Override
    public Object CallableStatement_getObject(DmdbCallableStatement callableStatement, int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        return super.CallableStatement_getObject(callableStatement, parameterIndex, map);
    }

    @Override
    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getRef(callableStatement, parameterName);
    }

    @Override
    public Ref CallableStatement_getRef(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getRef(callableStatement, parameterIndex);
    }

    @Override
    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getRowId(callableStatement, parameterName);
    }

    @Override
    public RowId CallableStatement_getRowId(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getRowId(callableStatement, parameterIndex);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getSQLXML(callableStatement, parameterName);
    }

    @Override
    public SQLXML CallableStatement_getSQLXML(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getSQLXML(callableStatement, parameterIndex);
    }

    @Override
    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getShort(callableStatement, parameterName);
    }

    @Override
    public short CallableStatement_getShort(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getShort(callableStatement, parameterIndex);
    }

    @Override
    public String CallableStatement_getString(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getString(callableStatement, parameterName);
    }

    @Override
    public String CallableStatement_getString(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getString(callableStatement, parameterIndex);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getTime(callableStatement, parameterName);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return super.CallableStatement_getTime(callableStatement, parameterName, cal);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getTime(callableStatement, parameterIndex);
    }

    @Override
    public Time CallableStatement_getTime(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return super.CallableStatement_getTime(callableStatement, parameterIndex, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getTimestamp(callableStatement, parameterName);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, String parameterName, Calendar cal) throws SQLException {
        return super.CallableStatement_getTimestamp(callableStatement, parameterName, cal);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getTimestamp(callableStatement, parameterIndex);
    }

    @Override
    public Timestamp CallableStatement_getTimestamp(DmdbCallableStatement callableStatement, int parameterIndex, Calendar cal) throws SQLException {
        return super.CallableStatement_getTimestamp(callableStatement, parameterIndex, cal);
    }

    @Override
    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, String parameterName) throws SQLException {
        return super.CallableStatement_getURL(callableStatement, parameterName);
    }

    @Override
    public URL CallableStatement_getURL(DmdbCallableStatement callableStatement, int parameterIndex) throws SQLException {
        return super.CallableStatement_getURL(callableStatement, parameterIndex);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, String parameterName, int sqlType, int scale) throws SQLException {
        super.CallableStatement_registerOutParameter(callableStatement, parameterName, sqlType, scale);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType) throws SQLException {
        super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, String typeName) throws SQLException {
        super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, typeName);
    }

    @Override
    public void CallableStatement_registerOutParameter(DmdbCallableStatement callableStatement, int parameterIndex, int sqlType, int scale) throws SQLException {
        super.CallableStatement_registerOutParameter(callableStatement, parameterIndex, sqlType, scale);
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setAsciiStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        super.CallableStatement_setAsciiStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBigDecimal(DmdbCallableStatement callableStatement, String parameterName, BigDecimal x2) throws SQLException {
        super.CallableStatement_setBigDecimal(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2) throws SQLException {
        super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, int length) throws SQLException {
        super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBinaryStream(DmdbCallableStatement callableStatement, String parameterName, InputStream x2, long length) throws SQLException {
        super.CallableStatement_setBinaryStream(callableStatement, parameterName, x2, length);
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, Blob x2) throws SQLException {
        super.CallableStatement_setBlob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream) throws SQLException {
        super.CallableStatement_setBlob(callableStatement, parameterName, inputStream);
    }

    @Override
    public void CallableStatement_setBlob(DmdbCallableStatement callableStatement, String parameterName, InputStream inputStream, long length) throws SQLException {
        super.CallableStatement_setBlob(callableStatement, parameterName, inputStream, length);
    }

    @Override
    public void CallableStatement_setBoolean(DmdbCallableStatement callableStatement, String parameterName, boolean x2) throws SQLException {
        super.CallableStatement_setBoolean(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setByte(DmdbCallableStatement callableStatement, String parameterName, byte x2) throws SQLException {
        super.CallableStatement_setByte(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setBytes(DmdbCallableStatement callableStatement, String parameterName, byte[] x2) throws SQLException {
        super.CallableStatement_setBytes(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        super.CallableStatement_setCharacterStream(callableStatement, parameterName, reader);
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, int length) throws SQLException {
        super.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        super.CallableStatement_setCharacterStream(callableStatement, parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Clob x2) throws SQLException {
        super.CallableStatement_setClob(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        super.CallableStatement_setClob(callableStatement, parameterName, reader);
    }

    @Override
    public void CallableStatement_setClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        super.CallableStatement_setClob(callableStatement, parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x2) throws SQLException {
        super.CallableStatement_setDate(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setDate(DmdbCallableStatement callableStatement, String parameterName, Date x2, Calendar cal) throws SQLException {
        super.CallableStatement_setDate(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setDouble(DmdbCallableStatement callableStatement, String parameterName, double x2) throws SQLException {
        super.CallableStatement_setDouble(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setFloat(DmdbCallableStatement callableStatement, String parameterName, float x2) throws SQLException {
        super.CallableStatement_setFloat(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setInt(DmdbCallableStatement callableStatement, String parameterName, int x2) throws SQLException {
        super.CallableStatement_setInt(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setLong(DmdbCallableStatement callableStatement, String parameterName, long x2) throws SQLException {
        super.CallableStatement_setLong(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value) throws SQLException {
        super.CallableStatement_setNCharacterStream(callableStatement, parameterName, value);
    }

    @Override
    public void CallableStatement_setNCharacterStream(DmdbCallableStatement callableStatement, String parameterName, Reader value, long length) throws SQLException {
        super.CallableStatement_setNCharacterStream(callableStatement, parameterName, value, length);
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, NClob value) throws SQLException {
        super.CallableStatement_setNClob(callableStatement, parameterName, value);
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader) throws SQLException {
        super.CallableStatement_setNClob(callableStatement, parameterName, reader);
    }

    @Override
    public void CallableStatement_setNClob(DmdbCallableStatement callableStatement, String parameterName, Reader reader, long length) throws SQLException {
        super.CallableStatement_setNClob(callableStatement, parameterName, reader, length);
    }

    @Override
    public void CallableStatement_setNString(DmdbCallableStatement callableStatement, String parameterName, String value) throws SQLException {
        super.CallableStatement_setNString(callableStatement, parameterName, value);
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType) throws SQLException {
        super.CallableStatement_setNull(callableStatement, parameterName, sqlType);
    }

    @Override
    public void CallableStatement_setNull(DmdbCallableStatement callableStatement, String parameterName, int sqlType, String typeName) throws SQLException {
        super.CallableStatement_setNull(callableStatement, parameterName, sqlType, typeName);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2) throws SQLException {
        super.CallableStatement_setObject(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType) throws SQLException {
        super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType);
    }

    @Override
    public void CallableStatement_setObject(DmdbCallableStatement callableStatement, String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        super.CallableStatement_setObject(callableStatement, parameterName, x2, targetSqlType, scale);
    }

    @Override
    public void CallableStatement_setRowId(DmdbCallableStatement callableStatement, String parameterName, RowId x2) throws SQLException {
        super.CallableStatement_setRowId(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setSQLXML(DmdbCallableStatement callableStatement, String parameterName, SQLXML xmlObject) throws SQLException {
        super.CallableStatement_setSQLXML(callableStatement, parameterName, xmlObject);
    }

    @Override
    public void CallableStatement_setShort(DmdbCallableStatement callableStatement, String parameterName, short x2) throws SQLException {
        super.CallableStatement_setShort(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setString(DmdbCallableStatement callableStatement, String parameterName, String x2) throws SQLException {
        super.CallableStatement_setString(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2) throws SQLException {
        super.CallableStatement_setTime(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setTime(DmdbCallableStatement callableStatement, String parameterName, Time x2, Calendar cal) throws SQLException {
        super.CallableStatement_setTime(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2) throws SQLException {
        super.CallableStatement_setTimestamp(callableStatement, parameterName, x2);
    }

    @Override
    public void CallableStatement_setTimestamp(DmdbCallableStatement callableStatement, String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        super.CallableStatement_setTimestamp(callableStatement, parameterName, x2, cal);
    }

    @Override
    public void CallableStatement_setURL(DmdbCallableStatement callableStatement, String parameterName, URL val) throws SQLException {
        super.CallableStatement_setURL(callableStatement, parameterName, val);
    }

    @Override
    public boolean CallableStatement_wasNull(DmdbCallableStatement callableStatement) throws SQLException {
        return super.CallableStatement_wasNull(callableStatement);
    }

    @Override
    public boolean ResultSet_absolute(DmdbResultSet resultSet, int row) throws SQLException {
        return super.ResultSet_absolute(resultSet, row);
    }

    @Override
    public void ResultSet_afterLast(DmdbResultSet resultSet) throws SQLException {
        super.ResultSet_afterLast(resultSet);
    }

    @Override
    public void ResultSet_beforeFirst(DmdbResultSet resultSet) throws SQLException {
        super.ResultSet_beforeFirst(resultSet);
    }

    @Override
    public void ResultSet_cancelRowUpdates(DmdbResultSet resultSet) throws SQLException {
        super.ResultSet_cancelRowUpdates(resultSet);
    }

    @Override
    public void ResultSet_clearWarnings(DmdbResultSet resultSet) throws SQLException {
        super.ResultSet_clearWarnings(resultSet);
    }

    @Override
    public void ResultSet_deleteRow(DmdbResultSet resultSet) throws SQLException {
        super.ResultSet_deleteRow(resultSet);
    }

    @Override
    public int ResultSet_findColumn(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_findColumn(resultSet, columnLabel);
    }

    @Override
    public boolean ResultSet_first(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_first(resultSet);
    }

    @Override
    public Array ResultSet_getArray(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getArray(resultSet, columnLabel);
    }

    @Override
    public Array ResultSet_getArray(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getArray(resultSet, columnIndex);
    }

    @Override
    public InputStream ResultSet_getAsciiStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getAsciiStream(resultSet, columnLabel);
    }

    @Override
    public InputStream ResultSet_getAsciiStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getAsciiStream(resultSet, columnIndex);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getBigDecimal(resultSet, columnLabel);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, String columnLabel, int scale) throws SQLException {
        return super.ResultSet_getBigDecimal(resultSet, columnLabel, scale);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getBigDecimal(resultSet, columnIndex);
    }

    @Override
    public BigDecimal ResultSet_getBigDecimal(DmdbResultSet resultSet, int columnIndex, int scale) throws SQLException {
        return super.ResultSet_getBigDecimal(resultSet, columnIndex, scale);
    }

    @Override
    public InputStream ResultSet_getBinaryStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getBinaryStream(resultSet, columnLabel);
    }

    @Override
    public InputStream ResultSet_getBinaryStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getBinaryStream(resultSet, columnIndex);
    }

    @Override
    public Blob ResultSet_getBlob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getBlob(resultSet, columnLabel);
    }

    @Override
    public Blob ResultSet_getBlob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getBlob(resultSet, columnIndex);
    }

    @Override
    public boolean ResultSet_getBoolean(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getBoolean(resultSet, columnLabel);
    }

    @Override
    public boolean ResultSet_getBoolean(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getBoolean(resultSet, columnIndex);
    }

    @Override
    public byte ResultSet_getByte(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getByte(resultSet, columnLabel);
    }

    @Override
    public byte ResultSet_getByte(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getByte(resultSet, columnIndex);
    }

    @Override
    public byte[] ResultSet_getBytes(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getBytes(resultSet, columnLabel);
    }

    @Override
    public byte[] ResultSet_getBytes(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getBytes(resultSet, columnIndex);
    }

    @Override
    public Reader ResultSet_getCharacterStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getCharacterStream(resultSet, columnLabel);
    }

    @Override
    public Reader ResultSet_getCharacterStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getCharacterStream(resultSet, columnIndex);
    }

    @Override
    public Clob ResultSet_getClob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getClob(resultSet, columnLabel);
    }

    @Override
    public Clob ResultSet_getClob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getClob(resultSet, columnIndex);
    }

    @Override
    public int ResultSet_getConcurrency(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_getConcurrency(resultSet);
    }

    @Override
    public String ResultSet_getCursorName(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_getCursorName(resultSet);
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getDate(resultSet, columnLabel);
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return super.ResultSet_getDate(resultSet, columnLabel, cal);
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getDate(resultSet, columnIndex);
    }

    @Override
    public Date ResultSet_getDate(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return super.ResultSet_getDate(resultSet, columnIndex, cal);
    }

    @Override
    public double ResultSet_getDouble(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getDouble(resultSet, columnLabel);
    }

    @Override
    public double ResultSet_getDouble(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getDouble(resultSet, columnIndex);
    }

    @Override
    public int ResultSet_getFetchDirection(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_getFetchDirection(resultSet);
    }

    @Override
    public int ResultSet_getFetchSize(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_getFetchSize(resultSet);
    }

    @Override
    public float ResultSet_getFloat(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getFloat(resultSet, columnLabel);
    }

    @Override
    public float ResultSet_getFloat(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getFloat(resultSet, columnIndex);
    }

    @Override
    public int ResultSet_getHoldability(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_getHoldability(resultSet);
    }

    @Override
    public int ResultSet_getInt(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getInt(resultSet, columnLabel);
    }

    @Override
    public int ResultSet_getInt(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getInt(resultSet, columnIndex);
    }

    @Override
    public long ResultSet_getLong(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getLong(resultSet, columnLabel);
    }

    @Override
    public long ResultSet_getLong(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getLong(resultSet, columnIndex);
    }

    @Override
    public ResultSetMetaData ResultSet_getMetaData(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_getMetaData(resultSet);
    }

    @Override
    public Reader ResultSet_getNCharacterStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getNCharacterStream(resultSet, columnLabel);
    }

    @Override
    public Reader ResultSet_getNCharacterStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getNCharacterStream(resultSet, columnIndex);
    }

    @Override
    public NClob ResultSet_getNClob(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getNClob(resultSet, columnLabel);
    }

    @Override
    public NClob ResultSet_getNClob(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getNClob(resultSet, columnIndex);
    }

    @Override
    public String ResultSet_getNString(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getNString(resultSet, columnLabel);
    }

    @Override
    public String ResultSet_getNString(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getNString(resultSet, columnIndex);
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getObject(resultSet, columnLabel);
    }

    @Override
    public <T> T ResultSet_getObject(DmdbResultSet resultSet, String columnLabel, Class<T> type) throws SQLException {
        return super.ResultSet_getObject(resultSet, columnLabel, type);
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return super.ResultSet_getObject(resultSet, columnLabel, map);
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getObject(resultSet, columnIndex);
    }

    @Override
    public <T> T ResultSet_getObject(DmdbResultSet resultSet, int columnIndex, Class<T> type) throws SQLException {
        return super.ResultSet_getObject(resultSet, columnIndex, type);
    }

    @Override
    public Object ResultSet_getObject(DmdbResultSet resultSet, int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return super.ResultSet_getObject(resultSet, columnIndex, map);
    }

    @Override
    public Ref ResultSet_getRef(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getRef(resultSet, columnLabel);
    }

    @Override
    public Ref ResultSet_getRef(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getRef(resultSet, columnIndex);
    }

    @Override
    public int ResultSet_getRow(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_getRow(resultSet);
    }

    @Override
    public RowId ResultSet_getRowId(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getRowId(resultSet, columnLabel);
    }

    @Override
    public RowId ResultSet_getRowId(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getRowId(resultSet, columnIndex);
    }

    @Override
    public SQLXML ResultSet_getSQLXML(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getSQLXML(resultSet, columnLabel);
    }

    @Override
    public SQLXML ResultSet_getSQLXML(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getSQLXML(resultSet, columnIndex);
    }

    @Override
    public short ResultSet_getShort(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getShort(resultSet, columnLabel);
    }

    @Override
    public short ResultSet_getShort(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getShort(resultSet, columnIndex);
    }

    @Override
    public Statement ResultSet_getStatement(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_getStatement(resultSet);
    }

    @Override
    public String ResultSet_getString(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getString(resultSet, columnLabel);
    }

    @Override
    public String ResultSet_getString(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getString(resultSet, columnIndex);
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getTime(resultSet, columnLabel);
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return super.ResultSet_getTime(resultSet, columnLabel, cal);
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getTime(resultSet, columnIndex);
    }

    @Override
    public Time ResultSet_getTime(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return super.ResultSet_getTime(resultSet, columnIndex, cal);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getTimestamp(resultSet, columnLabel);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, String columnLabel, Calendar cal) throws SQLException {
        return super.ResultSet_getTimestamp(resultSet, columnLabel, cal);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getTimestamp(resultSet, columnIndex);
    }

    @Override
    public Timestamp ResultSet_getTimestamp(DmdbResultSet resultSet, int columnIndex, Calendar cal) throws SQLException {
        return super.ResultSet_getTimestamp(resultSet, columnIndex, cal);
    }

    @Override
    public int ResultSet_getType(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_getType(resultSet);
    }

    @Override
    public URL ResultSet_getURL(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getURL(resultSet, columnLabel);
    }

    @Override
    public URL ResultSet_getURL(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getURL(resultSet, columnIndex);
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        return super.ResultSet_getUnicodeStream(resultSet, columnLabel);
    }

    @Override
    public InputStream ResultSet_getUnicodeStream(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        return super.ResultSet_getUnicodeStream(resultSet, columnIndex);
    }

    @Override
    public SQLWarning ResultSet_getWarnings(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_getWarnings(resultSet);
    }

    @Override
    public void ResultSet_insertRow(DmdbResultSet resultSet) throws SQLException {
        super.ResultSet_insertRow(resultSet);
    }

    @Override
    public boolean ResultSet_isAfterLast(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_isAfterLast(resultSet);
    }

    @Override
    public boolean ResultSet_isBeforeFirst(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_isBeforeFirst(resultSet);
    }

    @Override
    public boolean ResultSet_isClosed(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_isClosed(resultSet);
    }

    @Override
    public boolean ResultSet_isFirst(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_isFirst(resultSet);
    }

    @Override
    public boolean ResultSet_isLast(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_isLast(resultSet);
    }

    @Override
    public boolean ResultSet_last(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_last(resultSet);
    }

    @Override
    public void ResultSet_moveToCurrentRow(DmdbResultSet resultSet) throws SQLException {
        super.ResultSet_moveToCurrentRow(resultSet);
    }

    @Override
    public void ResultSet_moveToInsertRow(DmdbResultSet resultSet) throws SQLException {
        super.ResultSet_moveToInsertRow(resultSet);
    }

    @Override
    public boolean ResultSet_next(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_next(resultSet);
    }

    @Override
    public boolean ResultSet_previous(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_previous(resultSet);
    }

    @Override
    public void ResultSet_refreshRow(DmdbResultSet resultSet) throws SQLException {
        super.ResultSet_refreshRow(resultSet);
    }

    @Override
    public boolean ResultSet_relative(DmdbResultSet resultSet, int rows) throws SQLException {
        return super.ResultSet_relative(resultSet, rows);
    }

    @Override
    public boolean ResultSet_rowDeleted(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_rowDeleted(resultSet);
    }

    @Override
    public boolean ResultSet_rowInserted(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_rowInserted(resultSet);
    }

    @Override
    public boolean ResultSet_rowUpdated(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_rowUpdated(resultSet);
    }

    @Override
    public void ResultSet_setFetchDirection(DmdbResultSet resultSet, int direction) throws SQLException {
        super.ResultSet_setFetchDirection(resultSet, direction);
    }

    @Override
    public void ResultSet_setFetchSize(DmdbResultSet resultSet, int rows) throws SQLException {
        super.ResultSet_setFetchSize(resultSet, rows);
    }

    @Override
    public void ResultSet_updateArray(DmdbResultSet resultSet, String columnLabel, Array x2) throws SQLException {
        super.ResultSet_updateArray(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateArray(DmdbResultSet resultSet, int columnIndex, Array x2) throws SQLException {
        super.ResultSet_updateArray(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        super.ResultSet_updateAsciiStream(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        super.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        super.ResultSet_updateAsciiStream(resultSet, columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        super.ResultSet_updateAsciiStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        super.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateAsciiStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        super.ResultSet_updateAsciiStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateBigDecimal(DmdbResultSet resultSet, String columnLabel, BigDecimal x2) throws SQLException {
        super.ResultSet_updateBigDecimal(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBigDecimal(DmdbResultSet resultSet, int columnIndex, BigDecimal x2) throws SQLException {
        super.ResultSet_updateBigDecimal(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2) throws SQLException {
        super.ResultSet_updateBinaryStream(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, int length) throws SQLException {
        super.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, String columnLabel, InputStream x2, long length) throws SQLException {
        super.ResultSet_updateBinaryStream(resultSet, columnLabel, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2) throws SQLException {
        super.ResultSet_updateBinaryStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, int length) throws SQLException {
        super.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateBinaryStream(DmdbResultSet resultSet, int columnIndex, InputStream x2, long length) throws SQLException {
        super.ResultSet_updateBinaryStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, InputStream inputStream) throws SQLException {
        super.ResultSet_updateBlob(resultSet, columnLabel, inputStream);
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, InputStream inputStream, long length) throws SQLException {
        super.ResultSet_updateBlob(resultSet, columnLabel, inputStream, length);
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, String columnLabel, Blob x2) throws SQLException {
        super.ResultSet_updateBlob(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, InputStream inputStream) throws SQLException {
        super.ResultSet_updateBlob(resultSet, columnIndex, inputStream);
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, InputStream inputStream, long length) throws SQLException {
        super.ResultSet_updateBlob(resultSet, columnIndex, inputStream, length);
    }

    @Override
    public void ResultSet_updateBlob(DmdbResultSet resultSet, int columnIndex, Blob x2) throws SQLException {
        super.ResultSet_updateBlob(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBoolean(DmdbResultSet resultSet, String columnLabel, boolean x2) throws SQLException {
        super.ResultSet_updateBoolean(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBoolean(DmdbResultSet resultSet, int columnIndex, boolean x2) throws SQLException {
        super.ResultSet_updateBoolean(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateByte(DmdbResultSet resultSet, String columnLabel, byte x2) throws SQLException {
        super.ResultSet_updateByte(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateByte(DmdbResultSet resultSet, int columnIndex, byte x2) throws SQLException {
        super.ResultSet_updateByte(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateBytes(DmdbResultSet resultSet, String columnLabel, byte[] x2) throws SQLException {
        super.ResultSet_updateBytes(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateBytes(DmdbResultSet resultSet, int columnIndex, byte[] x2) throws SQLException {
        super.ResultSet_updateBytes(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        super.ResultSet_updateCharacterStream(resultSet, columnLabel, reader);
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, int length) throws SQLException {
        super.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        super.ResultSet_updateCharacterStream(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        super.ResultSet_updateCharacterStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, int length) throws SQLException {
        super.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        super.ResultSet_updateCharacterStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        super.ResultSet_updateClob(resultSet, columnLabel, reader);
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        super.ResultSet_updateClob(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, String columnLabel, Clob x2) throws SQLException {
        super.ResultSet_updateClob(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        super.ResultSet_updateClob(resultSet, columnIndex, reader);
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        super.ResultSet_updateClob(resultSet, columnIndex, reader, length);
    }

    @Override
    public void ResultSet_updateClob(DmdbResultSet resultSet, int columnIndex, Clob x2) throws SQLException {
        super.ResultSet_updateClob(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateDate(DmdbResultSet resultSet, String columnLabel, Date x2) throws SQLException {
        super.ResultSet_updateDate(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateDate(DmdbResultSet resultSet, int columnIndex, Date x2) throws SQLException {
        super.ResultSet_updateDate(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateDouble(DmdbResultSet resultSet, String columnLabel, double x2) throws SQLException {
        super.ResultSet_updateDouble(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateDouble(DmdbResultSet resultSet, int columnIndex, double x2) throws SQLException {
        super.ResultSet_updateDouble(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateFloat(DmdbResultSet resultSet, String columnLabel, float x2) throws SQLException {
        super.ResultSet_updateFloat(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateFloat(DmdbResultSet resultSet, int columnIndex, float x2) throws SQLException {
        super.ResultSet_updateFloat(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateInt(DmdbResultSet resultSet, String columnLabel, int x2) throws SQLException {
        super.ResultSet_updateInt(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateInt(DmdbResultSet resultSet, int columnIndex, int x2) throws SQLException {
        super.ResultSet_updateInt(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateLong(DmdbResultSet resultSet, String columnLabel, long x2) throws SQLException {
        super.ResultSet_updateLong(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateLong(DmdbResultSet resultSet, int columnIndex, long x2) throws SQLException {
        super.ResultSet_updateLong(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        super.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader);
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        super.ResultSet_updateNCharacterStream(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2) throws SQLException {
        super.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateNCharacterStream(DmdbResultSet resultSet, int columnIndex, Reader x2, long length) throws SQLException {
        super.ResultSet_updateNCharacterStream(resultSet, columnIndex, x2, length);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, NClob nClob) throws SQLException {
        super.ResultSet_updateNClob(resultSet, columnLabel, nClob);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, Reader reader) throws SQLException {
        super.ResultSet_updateNClob(resultSet, columnLabel, reader);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, String columnLabel, Reader reader, long length) throws SQLException {
        super.ResultSet_updateNClob(resultSet, columnLabel, reader, length);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, NClob nClob) throws SQLException {
        super.ResultSet_updateNClob(resultSet, columnIndex, nClob);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, Reader reader) throws SQLException {
        super.ResultSet_updateNClob(resultSet, columnIndex, reader);
    }

    @Override
    public void ResultSet_updateNClob(DmdbResultSet resultSet, int columnIndex, Reader reader, long length) throws SQLException {
        super.ResultSet_updateNClob(resultSet, columnIndex, reader, length);
    }

    @Override
    public void ResultSet_updateNString(DmdbResultSet resultSet, String columnLabel, String nString) throws SQLException {
        super.ResultSet_updateNString(resultSet, columnLabel, nString);
    }

    @Override
    public void ResultSet_updateNString(DmdbResultSet resultSet, int columnIndex, String nString) throws SQLException {
        super.ResultSet_updateNString(resultSet, columnIndex, nString);
    }

    @Override
    public void ResultSet_updateNull(DmdbResultSet resultSet, String columnLabel) throws SQLException {
        super.ResultSet_updateNull(resultSet, columnLabel);
    }

    @Override
    public void ResultSet_updateNull(DmdbResultSet resultSet, int columnIndex) throws SQLException {
        super.ResultSet_updateNull(resultSet, columnIndex);
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2) throws SQLException {
        super.ResultSet_updateObject(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, String columnLabel, Object x2, int scaleOrLength) throws SQLException {
        super.ResultSet_updateObject(resultSet, columnLabel, x2, scaleOrLength);
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2) throws SQLException {
        super.ResultSet_updateObject(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateObject(DmdbResultSet resultSet, int columnIndex, Object x2, int scaleOrLength) throws SQLException {
        super.ResultSet_updateObject(resultSet, columnIndex, x2, scaleOrLength);
    }

    @Override
    public void ResultSet_updateRef(DmdbResultSet resultSet, String columnLabel, Ref x2) throws SQLException {
        super.ResultSet_updateRef(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateRef(DmdbResultSet resultSet, int columnIndex, Ref x2) throws SQLException {
        super.ResultSet_updateRef(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateRow(DmdbResultSet resultSet) throws SQLException {
        super.ResultSet_updateRow(resultSet);
    }

    @Override
    public void ResultSet_updateRowId(DmdbResultSet resultSet, String columnLabel, RowId x2) throws SQLException {
        super.ResultSet_updateRowId(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateRowId(DmdbResultSet resultSet, int columnIndex, RowId x2) throws SQLException {
        super.ResultSet_updateRowId(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateSQLXML(DmdbResultSet resultSet, String columnLabel, SQLXML xmlObject) throws SQLException {
        super.ResultSet_updateSQLXML(resultSet, columnLabel, xmlObject);
    }

    @Override
    public void ResultSet_updateSQLXML(DmdbResultSet resultSet, int columnIndex, SQLXML xmlObject) throws SQLException {
        super.ResultSet_updateSQLXML(resultSet, columnIndex, xmlObject);
    }

    @Override
    public void ResultSet_updateShort(DmdbResultSet resultSet, String columnLabel, short x2) throws SQLException {
        super.ResultSet_updateShort(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateShort(DmdbResultSet resultSet, int columnIndex, short x2) throws SQLException {
        super.ResultSet_updateShort(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateString(DmdbResultSet resultSet, String columnLabel, String x2) throws SQLException {
        super.ResultSet_updateString(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateString(DmdbResultSet resultSet, int columnIndex, String x2) throws SQLException {
        super.ResultSet_updateString(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateTime(DmdbResultSet resultSet, String columnLabel, Time x2) throws SQLException {
        super.ResultSet_updateTime(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateTime(DmdbResultSet resultSet, int columnIndex, Time x2) throws SQLException {
        super.ResultSet_updateTime(resultSet, columnIndex, x2);
    }

    @Override
    public void ResultSet_updateTimestamp(DmdbResultSet resultSet, String columnLabel, Timestamp x2) throws SQLException {
        super.ResultSet_updateTimestamp(resultSet, columnLabel, x2);
    }

    @Override
    public void ResultSet_updateTimestamp(DmdbResultSet resultSet, int columnIndex, Timestamp x2) throws SQLException {
        super.ResultSet_updateTimestamp(resultSet, columnIndex, x2);
    }

    @Override
    public boolean ResultSet_wasNull(DmdbResultSet resultSet) throws SQLException {
        return super.ResultSet_wasNull(resultSet);
    }

    @Override
    public boolean DatabaseMetaData_allProceduresAreCallable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_allProceduresAreCallable(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_allTablesAreSelectable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_allTablesAreSelectable(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_autoCommitFailureClosesAllResultSets(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_autoCommitFailureClosesAllResultSets(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionCausesTransactionCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_dataDefinitionCausesTransactionCommit(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_dataDefinitionIgnoredInTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_dataDefinitionIgnoredInTransactions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_deletesAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return super.DatabaseMetaData_deletesAreDetected(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_doesMaxRowSizeIncludeBlobs(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_doesMaxRowSizeIncludeBlobs(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_generatedKeyAlwaysReturned(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_generatedKeyAlwaysReturned(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getAttributes(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return super.DatabaseMetaData_getAttributes(databaseMetaData, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getBestRowIdentifier(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return super.DatabaseMetaData_getBestRowIdentifier(databaseMetaData, catalog, schema, table, scope, nullable);
    }

    @Override
    public String DatabaseMetaData_getCatalogSeparator(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getCatalogSeparator(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getCatalogTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getCatalogTerm(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getCatalogs(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getCatalogs(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getClientInfoProperties(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getClientInfoProperties(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getColumnPrivileges(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return super.DatabaseMetaData_getColumnPrivileges(databaseMetaData, catalog, schema, table, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return super.DatabaseMetaData_getColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public Connection DatabaseMetaData_getConnection(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getConnection(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getCrossReference(DmdbDatabaseMetaData databaseMetaData, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return super.DatabaseMetaData_getCrossReference(databaseMetaData, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public int DatabaseMetaData_getDatabaseMajorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getDatabaseMajorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDatabaseMinorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getDatabaseMinorVersion(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getDatabaseProductName(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDatabaseProductVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getDatabaseProductVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDefaultTransactionIsolation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getDefaultTransactionIsolation(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDriverMajorVersion(DmdbDatabaseMetaData databaseMetaData) {
        return super.DatabaseMetaData_getDriverMajorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getDriverMinorVersion(DmdbDatabaseMetaData databaseMetaData) {
        return super.DatabaseMetaData_getDriverMinorVersion(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDriverName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getDriverName(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getDriverVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getDriverVersion(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getExportedKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return super.DatabaseMetaData_getExportedKeys(databaseMetaData, catalog, schema, table);
    }

    @Override
    public String DatabaseMetaData_getExtraNameCharacters(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getExtraNameCharacters(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctionColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return super.DatabaseMetaData_getFunctionColumns(databaseMetaData, catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getFunctions(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return super.DatabaseMetaData_getFunctions(databaseMetaData, catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public String DatabaseMetaData_getIdentifierQuoteString(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getIdentifierQuoteString(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getImportedKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return super.DatabaseMetaData_getImportedKeys(databaseMetaData, catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getIndexInfo(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return super.DatabaseMetaData_getIndexInfo(databaseMetaData, catalog, schema, table, unique, approximate);
    }

    @Override
    public int DatabaseMetaData_getJDBCMajorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getJDBCMajorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getJDBCMinorVersion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getJDBCMinorVersion(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxBinaryLiteralLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxBinaryLiteralLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxCatalogNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxCatalogNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxCharLiteralLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxCharLiteralLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxColumnNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInGroupBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxColumnsInGroupBy(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInIndex(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxColumnsInIndex(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInOrderBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxColumnsInOrderBy(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxColumnsInSelect(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxColumnsInTable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxColumnsInTable(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxConnections(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxConnections(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxCursorNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxCursorNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxIndexLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxIndexLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxProcedureNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxProcedureNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxRowSize(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxRowSize(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxSchemaNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxSchemaNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxStatementLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxStatementLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxStatements(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxStatements(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxTableNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxTableNameLength(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxTablesInSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxTablesInSelect(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getMaxUserNameLength(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getMaxUserNameLength(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getNumericFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getNumericFunctions(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getPrimaryKeys(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return super.DatabaseMetaData_getPrimaryKeys(databaseMetaData, catalog, schema, table);
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedureColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return super.DatabaseMetaData_getProcedureColumns(databaseMetaData, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    @Override
    public String DatabaseMetaData_getProcedureTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getProcedureTerm(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getProcedures(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return super.DatabaseMetaData_getProcedures(databaseMetaData, catalog, schemaPattern, procedureNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getPseudoColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return super.DatabaseMetaData_getPseudoColumns(databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public int DatabaseMetaData_getResultSetHoldability(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getResultSetHoldability(databaseMetaData);
    }

    @Override
    public RowIdLifetime DatabaseMetaData_getRowIdLifetime(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getRowIdLifetime(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getSQLKeywords(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getSQLKeywords(databaseMetaData);
    }

    @Override
    public int DatabaseMetaData_getSQLStateType(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getSQLStateType(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getSchemaTerm(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getSchemaTerm(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getSchemas(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getSchemas(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern) throws SQLException {
        return super.DatabaseMetaData_getSchemas(databaseMetaData, catalog, schemaPattern);
    }

    @Override
    public String DatabaseMetaData_getSearchStringEscape(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getSearchStringEscape(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getStringFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getStringFunctions(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTables(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return super.DatabaseMetaData_getSuperTables(databaseMetaData, catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getSuperTypes(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return super.DatabaseMetaData_getSuperTypes(databaseMetaData, catalog, schemaPattern, typeNamePattern);
    }

    @Override
    public String DatabaseMetaData_getSystemFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getSystemFunctions(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getTablePrivileges(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return super.DatabaseMetaData_getTablePrivileges(databaseMetaData, catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public ResultSet DatabaseMetaData_getTableTypes(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getTableTypes(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getTables(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return super.DatabaseMetaData_getTables(databaseMetaData, catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public String DatabaseMetaData_getTimeDateFunctions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getTimeDateFunctions(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getTypeInfo(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getTypeInfo(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getUDTs(DmdbDatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return super.DatabaseMetaData_getUDTs(databaseMetaData, catalog, schemaPattern, typeNamePattern, types);
    }

    @Override
    public String DatabaseMetaData_getURL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getURL(databaseMetaData);
    }

    @Override
    public String DatabaseMetaData_getUserName(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_getUserName(databaseMetaData);
    }

    @Override
    public ResultSet DatabaseMetaData_getVersionColumns(DmdbDatabaseMetaData databaseMetaData, String catalog, String schema, String table) throws SQLException {
        return super.DatabaseMetaData_getVersionColumns(databaseMetaData, catalog, schema, table);
    }

    @Override
    public boolean DatabaseMetaData_insertsAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return super.DatabaseMetaData_insertsAreDetected(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_isCatalogAtStart(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_isCatalogAtStart(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_isReadOnly(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_isReadOnly(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_locatorsUpdateCopy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_locatorsUpdateCopy(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullPlusNonNullIsNull(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_nullPlusNonNullIsNull(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtEnd(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_nullsAreSortedAtEnd(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedAtStart(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_nullsAreSortedAtStart(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedHigh(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_nullsAreSortedHigh(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_nullsAreSortedLow(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_nullsAreSortedLow(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_othersDeletesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return super.DatabaseMetaData_othersDeletesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_othersInsertsAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return super.DatabaseMetaData_othersInsertsAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_othersUpdatesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return super.DatabaseMetaData_othersUpdatesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_ownDeletesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return super.DatabaseMetaData_ownDeletesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_ownInsertsAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return super.DatabaseMetaData_ownInsertsAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_ownUpdatesAreVisible(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return super.DatabaseMetaData_ownUpdatesAreVisible(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_storesLowerCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesLowerCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_storesLowerCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_storesMixedCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesMixedCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_storesMixedCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_storesUpperCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_storesUpperCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_storesUpperCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92EntryLevelSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsANSI92EntryLevelSQL(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92FullSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsANSI92FullSQL(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsANSI92IntermediateSQL(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsANSI92IntermediateSQL(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithAddColumn(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsAlterTableWithAddColumn(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsAlterTableWithDropColumn(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsAlterTableWithDropColumn(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsBatchUpdates(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsBatchUpdates(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInDataManipulation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsCatalogsInDataManipulation(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInIndexDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsCatalogsInIndexDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInProcedureCalls(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsCatalogsInProcedureCalls(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCatalogsInTableDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsCatalogsInTableDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsColumnAliasing(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsColumnAliasing(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsConvert(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsConvert(DmdbDatabaseMetaData databaseMetaData, int fromType, int toType) throws SQLException {
        return super.DatabaseMetaData_supportsConvert(databaseMetaData, fromType, toType);
    }

    @Override
    public boolean DatabaseMetaData_supportsCoreSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsCoreSQLGrammar(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsCorrelatedSubqueries(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsCorrelatedSubqueries(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsDataManipulationTransactionsOnly(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsDataManipulationTransactionsOnly(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsDifferentTableCorrelationNames(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsDifferentTableCorrelationNames(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsExpressionsInOrderBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsExpressionsInOrderBy(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsExtendedSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsExtendedSQLGrammar(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsFullOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsFullOuterJoins(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGetGeneratedKeys(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsGetGeneratedKeys(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupBy(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsGroupBy(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByBeyondSelect(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsGroupByBeyondSelect(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsGroupByUnrelated(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsGroupByUnrelated(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsIntegrityEnhancementFacility(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsIntegrityEnhancementFacility(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsLikeEscapeClause(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsLikeEscapeClause(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsLimitedOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsLimitedOuterJoins(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMinimumSQLGrammar(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsMinimumSQLGrammar(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsMixedCaseIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleOpenResults(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsMultipleOpenResults(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleResultSets(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsMultipleResultSets(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsMultipleTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsMultipleTransactions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsNamedParameters(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsNamedParameters(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsNonNullableColumns(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsNonNullableColumns(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsOpenCursorsAcrossCommit(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenCursorsAcrossRollback(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsOpenCursorsAcrossRollback(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossCommit(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsOpenStatementsAcrossCommit(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOpenStatementsAcrossRollback(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsOpenStatementsAcrossRollback(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOrderByUnrelated(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsOrderByUnrelated(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsOuterJoins(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsOuterJoins(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedDelete(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsPositionedDelete(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsPositionedUpdate(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsPositionedUpdate(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetConcurrency(DmdbDatabaseMetaData databaseMetaData, int type, int concurrency) throws SQLException {
        return super.DatabaseMetaData_supportsResultSetConcurrency(databaseMetaData, type, concurrency);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetHoldability(DmdbDatabaseMetaData databaseMetaData, int holdability) throws SQLException {
        return super.DatabaseMetaData_supportsResultSetHoldability(databaseMetaData, holdability);
    }

    @Override
    public boolean DatabaseMetaData_supportsResultSetType(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return super.DatabaseMetaData_supportsResultSetType(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_supportsSavepoints(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsSavepoints(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInDataManipulation(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsSchemasInDataManipulation(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInIndexDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsSchemasInIndexDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInProcedureCalls(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsSchemasInProcedureCalls(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSchemasInTableDefinitions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsSchemasInTableDefinitions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSelectForUpdate(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsSelectForUpdate(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsStatementPooling(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsStatementPooling(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsStoredProcedures(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsStoredProcedures(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInComparisons(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsSubqueriesInComparisons(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInExists(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsSubqueriesInExists(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInIns(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsSubqueriesInIns(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsSubqueriesInQuantifieds(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsSubqueriesInQuantifieds(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsTableCorrelationNames(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsTableCorrelationNames(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactionIsolationLevel(DmdbDatabaseMetaData databaseMetaData, int level) throws SQLException {
        return super.DatabaseMetaData_supportsTransactionIsolationLevel(databaseMetaData, level);
    }

    @Override
    public boolean DatabaseMetaData_supportsTransactions(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsTransactions(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsUnion(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsUnion(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_supportsUnionAll(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_supportsUnionAll(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_updatesAreDetected(DmdbDatabaseMetaData databaseMetaData, int type) throws SQLException {
        return super.DatabaseMetaData_updatesAreDetected(databaseMetaData, type);
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFilePerTable(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_usesLocalFilePerTable(databaseMetaData);
    }

    @Override
    public boolean DatabaseMetaData_usesLocalFiles(DmdbDatabaseMetaData databaseMetaData) throws SQLException {
        return super.DatabaseMetaData_usesLocalFiles(databaseMetaData);
    }

    @Override
    public String ParameterMetaData_getParameterClassName(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return super.ParameterMetaData_getParameterClassName(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getParameterCount(DmdbParameterMetaData parameterMetaData) throws SQLException {
        return super.ParameterMetaData_getParameterCount(parameterMetaData);
    }

    @Override
    public int ParameterMetaData_getParameterMode(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return super.ParameterMetaData_getParameterMode(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getParameterType(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return super.ParameterMetaData_getParameterType(parameterMetaData, param);
    }

    @Override
    public String ParameterMetaData_getParameterTypeName(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return super.ParameterMetaData_getParameterTypeName(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getPrecision(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return super.ParameterMetaData_getPrecision(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_getScale(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return super.ParameterMetaData_getScale(parameterMetaData, param);
    }

    @Override
    public int ParameterMetaData_isNullable(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return super.ParameterMetaData_isNullable(parameterMetaData, param);
    }

    @Override
    public boolean ParameterMetaData_isSigned(DmdbParameterMetaData parameterMetaData, int param) throws SQLException {
        return super.ParameterMetaData_isSigned(parameterMetaData, param);
    }

    @Override
    public String ResultSetMetaData_getCatalogName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_getCatalogName(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnClassName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_getColumnClassName(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getColumnCount(DmdbResultSetMetaData resultSetMetaData) throws SQLException {
        return super.ResultSetMetaData_getColumnCount(resultSetMetaData);
    }

    @Override
    public int ResultSetMetaData_getColumnDisplaySize(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_getColumnDisplaySize(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnLabel(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_getColumnLabel(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_getColumnName(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getColumnType(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_getColumnType(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getColumnTypeName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_getColumnTypeName(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getPrecision(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_getPrecision(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_getScale(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_getScale(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getSchemaName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_getSchemaName(resultSetMetaData, column);
    }

    @Override
    public String ResultSetMetaData_getTableName(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_getTableName(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isAutoIncrement(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_isAutoIncrement(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isCaseSensitive(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_isCaseSensitive(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isCurrency(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_isCurrency(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isDefinitelyWritable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_isDefinitelyWritable(resultSetMetaData, column);
    }

    @Override
    public int ResultSetMetaData_isNullable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_isNullable(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isReadOnly(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_isReadOnly(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isSearchable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_isSearchable(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isSigned(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_isSigned(resultSetMetaData, column);
    }

    @Override
    public boolean ResultSetMetaData_isWritable(DmdbResultSetMetaData resultSetMetaData, int column) throws SQLException {
        return super.ResultSetMetaData_isWritable(resultSetMetaData, column);
    }
}

