/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin;

import dm.jdbc.a.b;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.jni.MarkDll;
import dm.jdbc.plugin.model.SubscribeLog;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class DMSession {
    private DmdbConnection connection;

    protected DMSession(DmdbConnection connection) {
        this.connection = connection;
    }

    public static DMSession getInstance(Connection connection) throws SQLException {
        if (!(connection instanceof DmdbConnection)) {
            DBError.ECJDBC_UNSUPPORTED_PARAM.throwz(new Object[0]);
        }
        return new DMSession((DmdbConnection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExplain(String sql) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            this.connection.checkClosed();
            if (StringUtil.isEmpty(sql)) {
                DBError.ECJDBC_SQL_IS_EMPTY.throwz(new Object[0]);
            }
            if (!sql.equalsIgnoreCase("show_pln_stat")) {
                sql = "EXPLAIN " + sql;
            }
            return DriverUtil.executeAndGetExplain(this.connection, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrace(String sql) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            this.connection.checkClosed();
            return DriverUtil.executeAndGetExplain(this.connection, sql);
        }
    }

    public void setMark(String socketMark) throws SQLException {
        if (StringUtil.isEmpty(socketMark)) {
            this.connection.socketMark = null;
            return;
        }
        byte[] socketMarkBytes = socketMark.getBytes();
        if (this.connection.dbAccess instanceof b && MarkDll.checkMark(((b)this.connection.dbAccess).p, socketMarkBytes, socketMarkBytes.length) < 0) {
            DBError.ECJDBC_INVALID_SOCKET_MARK.throwz(socketMark);
        }
        this.connection.socketMark = socketMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscribeLog(Statement statement, long dbMagic, int epSeqno, long beginSeqno, long beginLsn, long endSeqno, long endLsn, long sendDelay) throws SQLException {
        DmdbConnection conn;
        if (!(statement instanceof DmdbStatement)) {
            DBError.ECJDBC_UNSUPPORTED_PARAM.throwz(new Object[0]);
        }
        DmdbStatement stmt = (DmdbStatement)statement;
        stmt.checkClosed();
        DmdbConnection dmdbConnection = conn = stmt.connection;
        synchronized (dmdbConnection) {
            SubscribeLog logInfo = new SubscribeLog();
            logInfo.dbMagic = dbMagic;
            logInfo.epSeqno = epSeqno;
            logInfo.beginSeqno = beginSeqno;
            logInfo.beginLsn = beginLsn;
            logInfo.endSeqno = endSeqno;
            logInfo.endLsn = endLsn;
            logInfo.sendDelay = sendDelay;
            conn.dbAccess.a(stmt, logInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSubscribeLog(Statement statement) throws SQLException {
        DmdbConnection conn;
        if (!(statement instanceof DmdbStatement)) {
            DBError.ECJDBC_UNSUPPORTED_PARAM.throwz(new Object[0]);
        }
        DmdbStatement stmt = (DmdbStatement)statement;
        stmt.checkClosed();
        DmdbConnection dmdbConnection = conn = stmt.connection;
        synchronized (dmdbConnection) {
            conn.dbAccess.b(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscribeLog getSubscribeLogOrderly(Statement statement, long len) throws SQLException {
        DmdbConnection conn;
        if (!(statement instanceof DmdbStatement)) {
            DBError.ECJDBC_UNSUPPORTED_PARAM.throwz(new Object[0]);
        }
        DmdbStatement stmt = (DmdbStatement)statement;
        stmt.checkClosed();
        DmdbConnection dmdbConnection = conn = stmt.connection;
        synchronized (dmdbConnection) {
            return conn.dbAccess.a(stmt, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscribeLog getSubscribeLogSinglely(Statement statement, int epSeqno, long len) throws SQLException {
        DmdbConnection conn;
        if (!(statement instanceof DmdbStatement)) {
            DBError.ECJDBC_UNSUPPORTED_PARAM.throwz(new Object[0]);
        }
        DmdbStatement stmt = (DmdbStatement)statement;
        stmt.checkClosed();
        DmdbConnection dmdbConnection = conn = stmt.connection;
        synchronized (dmdbConnection) {
            return conn.dbAccess.a(stmt, epSeqno, len);
        }
    }

    public static void main(String[] args) throws Exception {
        int[] eps;
        Connection conn = DmDriver.driver.connect("jdbc:dm://192.168.100.176:7602?USER=SYSDBA&PASSWORD=SYSDBA", null);
        DMSession dmsession = DMSession.getInstance(conn);
        DmdbStatement stmt = (DmdbStatement)conn.createStatement();
        long dbMagic = 495589324L;
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] nArray2 = eps = nArray;
        int n2 = eps.length;
        int n3 = 0;
        while (n3 < n2) {
            int epSeqno = nArray2[n3];
            dmsession.setSubscribeLog(stmt, dbMagic, epSeqno, 7L, 40355L, -1L, -1L, 0L);
            ++n3;
        }
        boolean over = false;
        while (!over) {
            SubscribeLog log = dmsession.getSubscribeLogOrderly(stmt, 0x400000L);
            System.out.println(log.data);
            over = log.over;
        }
        dmsession.clearSubscribeLog(stmt);
    }
}

