/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.plugin.fldr;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbSQLXML;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.filter.fldr.FldrTask;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.desc.Parameter;
import dm.jdbc.plugin.fldr.ColumnData;
import dm.jdbc.plugin.fldr.ColumnInfo;
import dm.jdbc.plugin.fldr.Fldr;
import dm.jdbc.plugin.fldr.FldrClusterInfo;
import dm.jdbc.plugin.fldr.FldrConfig;
import dm.jdbc.plugin.fldr.FldrUtil;
import dm.jdbc.plugin.fldr.SetEnvInfo;
import dm.jdbc.plugin.fldr.TableInfo;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MiscUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FldrPreparedStatement
extends DmdbPreparedStatement {
    private String schemaName;
    private String tableName;
    private boolean firstFlag = true;
    private byte lockFlag = 0;
    private static final String SQL_SAMPLE = "SELECT 1 FROM DUAL";
    private TableInfo tableInfo;
    private Fldr primaryFldr;
    private boolean clusterFlag = false;
    private SetEnvInfo setEnvInfo;
    private int rows;
    private Map<Short, String> setIdMap = new HashMap<Short, String>();
    private FldrClusterInfo clusterInfo;
    private ExecutorService clusterExecutor;
    private ConcurrentHashMap<Integer, Fldr> fldrsMap;
    private List<DmdbConnection> connections;
    private HashSet<Fldr> usedFldr = new HashSet();
    private ConcurrentHashMap<Integer, Map<Short, String>> lastBpIdTabName = new ConcurrentHashMap();
    private Map<Integer, int[]> columnIdScale = new HashMap<Integer, int[]>();
    private List<ColumnData> columnDataMeta;
    private static final String DECIMAL_PRECISION_SCALE_SQL = "SELECT * FROM %s.%s LIMIT 1";
    private static final String INVALID_PARAM_FORMAT = "the %s column %s row data cannot match to Type {%s}";
    private static final String CAST_ERROR_FORMAT = "could not cast to target type, targetSqlType: %s, serverSqlType: %s";
    private static final String EXCEED_MAX_ROWS_FORMAT = "Binding parameter exceeds maxRows: {maxRows: %s, currentRow: %s, data: %s}";
    private final String TIMESTAMP_FORMAT = "%s-%s-%s %s:%s:%s.%s";

    protected FldrPreparedStatement(DmdbConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean fromPool) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency, resultSetHoldability, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    protected FldrPreparedStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, boolean fromPool) throws SQLException {
        super(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrPreparedStatement(DmdbConnection connection, String sql, int autoGeneratedKeys, boolean fromPool) throws SQLException {
        super(connection, sql, autoGeneratedKeys, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrPreparedStatement(DmdbConnection connection, FldrConfig config) throws SQLException {
        super(connection, SQL_SAMPLE, 0, false);
        this.setFldrTableInfo(config.schemaName, config.tableName);
        this.setFldrProperties(config);
    }

    public FldrPreparedStatement(DmdbConnection connection, String sql, int[] columnIndexes, boolean fromPool) throws SQLException {
        super(connection, sql, columnIndexes, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrPreparedStatement(DmdbConnection connection, String sql, String[] columnNames, boolean fromPool) throws SQLException {
        super(connection, sql, columnNames, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    public FldrPreparedStatement(DmdbConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean fromPool) throws SQLException {
        super(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, fromPool);
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public DmdbResultSet do_executeQuery() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public int do_executeUpdate() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return -1;
    }

    @Override
    public void do_setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this.do_setObject(parameterIndex, null);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    private void shutdownExecutor() {
        if (this.clusterFlag && !this.clusterExecutor.isShutdown()) {
            this.clusterExecutor.shutdownNow();
        }
    }

    @Override
    public void do_setBoolean(int parameterIndex, boolean x2) throws SQLException {
        try {
            int result = x2 ? 1 : 0;
            this.do_setObject(parameterIndex, result);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setByte(int parameterIndex, byte x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 5) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setShort(int parameterIndex, short x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 6) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setInt(int parameterIndex, int x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 7) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setINTERVALDT(int parameterIndex, DmdbIntervalDT x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 21) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setINTERVALYM(int parameterIndex, DmdbIntervalYM x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 20) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setLong(int parameterIndex, long x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 8) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setFloat(int parameterIndex, float x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 10) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = Float.valueOf(x2);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setDouble(int parameterIndex, double x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 11) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        try {
            int[] ints;
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 9) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            if ((ints = this.columnIdScale.get(parameterIndex - 1)) == null) {
                DBError.ECJDBC_INVALID_SCALE.throwz("Server could not provide valid precision and scale");
            }
            this.curRowDatas[parameterIndex - 1] = this.roundHalfUp(x2, ints[0], ints[1]);
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    private BigDecimal roundHalfUp(BigDecimal dec, int prec, int scale) {
        if (dec == null) {
            return null;
        }
        if (scale == 0 && prec == 0 && (dec.precision() == 0 || dec.scale() != 0)) {
            if (dec.precision() + dec.scale() < 38) {
                return dec;
            }
            int precision = dec.precision() - dec.scale();
            precision = precision % 2 == 0 ? precision : precision + 1;
            scale = 38 - precision > 0 ? 38 - precision : scale;
            dec = dec.setScale(scale, 4);
        }
        if (scale > 0 && dec.scale() > scale) {
            dec = dec.setScale(scale, 4);
        }
        return dec;
    }

    @Override
    public void do_setString(int parameterIndex, String x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() == 2 || columnInfo.getColumnType() == 1 || columnInfo.getColumnType() == 0) {
                this.curRowDatas[parameterIndex - 1] = x2;
            } else if (columnInfo.getColumnType() == 19) {
                this.curRowDatas[parameterIndex - 1] = DmdbClob.newInstance(x2, this.connection);
            } else if (columnInfo.getColumnType() == 12) {
                this.curRowDatas[parameterIndex - 1] = DmdbBlob.newInstanceOfLocal(x2.getBytes(), this.connection);
            } else {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setBytes(int parameterIndex, byte[] x2) throws SQLException {
        try {
            ColumnInfo columnInfo;
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != 18 && columnInfo.getColumnType() != 17) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format(INVALID_PARAM_FORMAT, parameterIndex, this.irow, columnInfo.getColumnType()));
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    private <T extends java.util.Date> void setFldrDate(int parameterIndex, T x2) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setDate(int parameterIndex, Date x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setTime(int parameterIndex, Time x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setTIMESTAMP(int parameterIndex, DmdbTimestamp x2) throws SQLException {
        this.setFldrDate(parameterIndex, x2);
    }

    @Override
    public void do_setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.do_setAsciiStream(parameterIndex, x2, (long)length);
    }

    @Override
    public void do_setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        try {
            ColumnInfo columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1);
            boolean notNull = this.beforeStreamProcess(parameterIndex, x2, length < 0, columnInfo.getColumnType());
            if (notNull) {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromUnicodeStream(x2, parameter, this.connection, length, parameterIndex - 1);
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.do_setBinaryStream(parameterIndex, x2, (long)length);
    }

    @Override
    public void do_setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        ColumnInfo columnInfo;
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        if ((columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType() != targetSqlType) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(CAST_ERROR_FORMAT, targetSqlType, columnInfo.getColumnType());
        }
        this.do_setObject(parameterIndex, x2);
    }

    @Override
    public void do_setObject(int parameterIndex, Object x2) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.paramCount) {
            DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
        }
        if (x2 instanceof InputStream) {
            this.do_setBinaryStream(parameterIndex, (InputStream)x2);
        } else if (x2 instanceof Reader) {
            this.do_setCharacterStream(parameterIndex, (Reader)x2);
        } else {
            if (9 == this.tableInfo.getColumnInfos().get(parameterIndex - 1).getColumnType()) {
                this.ObjectToDecimal(parameterIndex, x2);
                return;
            }
            this.curRowDatas[parameterIndex - 1] = x2;
        }
    }

    private void ObjectToDecimal(int parameterIndex, Object x2) throws SQLException {
        if (x2 instanceof BigDecimal) {
            this.do_setBigDecimal(parameterIndex, (BigDecimal)x2);
        } else if (x2 instanceof Byte) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Byte)x2).byteValue()));
        } else if (x2 instanceof Short) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Short)x2).shortValue()));
        } else if (x2 instanceof Integer) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Integer)x2).intValue()));
        } else if (x2 instanceof Long) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf((Long)x2));
        } else if (x2 instanceof Double) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf((Double)x2));
        } else if (x2 instanceof Float) {
            this.do_setBigDecimal(parameterIndex, BigDecimal.valueOf(((Float)x2).floatValue()));
        } else {
            this.do_setBigDecimal(parameterIndex, x2 == null ? null : new BigDecimal(x2.toString()));
        }
    }

    @Override
    public boolean do_execute() throws SQLException {
        this.do_addBatch();
        int[] ints = this.do_executeBatch();
        return ints != null && ints.length > 0;
    }

    @Override
    public void do_addBatch() throws SQLException {
        this.multiRowDatas.add(this.curRowDatas);
        ++this.irow;
        if (this.irow > this.rows) {
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = this.curRowDatas;
            int n2 = this.curRowDatas.length;
            int n3 = 0;
            while (n3 < n2) {
                Object data = objectArray[n3];
                sb.append(data).append(";");
                ++n3;
            }
            this.shutdownExecutor();
            DBError.ECJDBC_UNBINDED_PARAMETER.throwz(String.format(EXCEED_MAX_ROWS_FORMAT, this.rows, this.irow, sb.toString()));
        }
        Object[] tmp = new Object[this.paramCount];
        System.arraycopy(this.curRowDatas, 0, tmp, 0, tmp.length);
        this.curRowDatas = tmp;
    }

    @Override
    public void do_setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void do_setRef(int parameterIndex, Ref x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_setBlob(int parameterIndex, Blob blob) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            this.curRowDatas[parameterIndex - 1] = blob;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setClob(int parameterIndex, Clob clob) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            this.curRowDatas[parameterIndex - 1] = clob;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setArray(int parameterIndex, Array x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public DmdbResultSetMetaData do_getMetaData() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void do_setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        cal.setTime(x2);
        this.setFldrDate(parameterIndex, cal.getTime());
    }

    @Override
    public void do_setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        cal.setTime(x2);
        this.setFldrDate(parameterIndex, cal.getTime());
    }

    @Override
    public void do_setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        cal.setTime(x2);
        String format = String.format("%s-%s-%s %s:%s:%s.%s", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), x2.getNanos() / 1000);
        Timestamp timestamp = Timestamp.valueOf(format);
        this.setFldrDate(parameterIndex, timestamp);
    }

    @Override
    public void do_setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.do_setNull(parameterIndex, sqlType);
    }

    @Override
    public void do_setURL(int parameterIndex, URL x2) throws SQLException {
        if (x2 == null) {
            this.do_setNull(parameterIndex, 12);
            return;
        }
        this.do_setString(parameterIndex, x2.toString());
    }

    @Override
    public DmdbParameterMetaData do_getParameterMetaData() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void do_setRowId(int parameterIndex, RowId x2) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            ColumnInfo columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1);
            if (x2 == null) {
                this.do_setNull(parameterIndex, -8);
            }
            if (8 == columnInfo.getColumnType()) {
                this.do_setLong(parameterIndex, Long.parseLong(x2.toString()));
            } else if (28 == columnInfo.getColumnType()) {
                this.curRowDatas[parameterIndex - 1] = x2;
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setNString(int parameterIndex, String value) throws SQLException {
        this.do_setString(parameterIndex, value);
    }

    @Override
    public void do_setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void do_setNClob(int parameterIndex, NClob value) throws SQLException {
        this.do_setClob(parameterIndex, value);
    }

    @Override
    public void do_setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void do_setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.do_setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void do_setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.do_setClob(parameterIndex, reader, length);
    }

    @Override
    public void do_setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (xmlObject == null) {
            this.do_setNull(parameterIndex, 2009);
        } else {
            this.do_setCharacterStream(parameterIndex, ((DmdbSQLXML)xmlObject).serializeAsCharacterStream());
        }
    }

    @Override
    public void do_setObject(int parameterIndex, Object x2, int targetSqlType, int scaleOrLength) throws SQLException {
        this.do_setObject(parameterIndex, x2, targetSqlType);
    }

    private boolean beforeStreamProcess(int parameterIndex, Object x2, boolean vaildFlag, int colType) throws SQLException {
        try {
            if (parameterIndex < 1 || parameterIndex > this.paramCount) {
                DBError.ECJDBC_INVALID_SEQUENCE.throwz(new Object[0]);
            }
            if (vaildFlag) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("Reading length could not less than 0");
            }
            if (x2 == null) {
                this.do_setNull(parameterIndex, colType);
                return false;
            }
            return true;
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
            return false;
        }
    }

    @Override
    public void do_setAsciiStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        ColumnInfo columnInfo;
        boolean notNull;
        try {
            int available = x2.available();
            if (length > (long)available) {
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("Reading length exceeds the max length");
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            this.shutdownExecutor();
        }
        if (notNull = this.beforeStreamProcess(parameterIndex, x2, length < -1L, (columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType())) {
            try {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromAsciiStream(x2, parameter, this.connection, length, parameterIndex - 1);
            }
            catch (Exception e3) {
                this.shutdownExecutor();
                DBError.ECJDBC_COMMUNITION_ERROR.throwz(e3);
            }
        }
    }

    @Override
    public void do_setBinaryStream(int parameterIndex, InputStream x2, long length) throws SQLException {
        ColumnInfo columnInfo;
        boolean notNull;
        try {
            int available = x2.available();
            if (length > (long)available) {
                this.shutdownExecutor();
                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("Reading length exceeds the max length");
            }
        }
        catch (IOException e2) {
            this.shutdownExecutor();
            e2.printStackTrace();
        }
        if (notNull = this.beforeStreamProcess(parameterIndex, x2, length < 0L, (columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1)).getColumnType())) {
            try {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromBinaryStream(x2, parameter, this.connection, length, parameterIndex - 1);
            }
            catch (Exception e3) {
                this.shutdownExecutor();
                DBError.ECJDBC_COMMUNITION_ERROR.throwz(e3);
            }
        }
    }

    @Override
    public void do_setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            ColumnInfo columnInfo = this.tableInfo.getColumnInfos().get(parameterIndex - 1);
            boolean notNull = this.beforeStreamProcess(parameterIndex, reader, length < -1L, columnInfo.getColumnType());
            if (notNull) {
                Parameter parameter = new Parameter();
                parameter.resetType(columnInfo.getColumnType());
                this.curRowDatas[parameterIndex - 1] = FldrUtil.fromReader(reader, parameter, this.connection, length, parameterIndex - 1);
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
    }

    @Override
    public void do_setAsciiStream(int parameterIndex, InputStream x2) throws SQLException {
        try {
            this.do_setAsciiStream(parameterIndex, x2, x2.available());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void do_setBinaryStream(int parameterIndex, InputStream x2) throws SQLException {
        try {
            this.do_setBinaryStream(parameterIndex, x2, x2.available());
        }
        catch (IOException e2) {
            this.shutdownExecutor();
            e2.printStackTrace();
        }
    }

    @Override
    public void do_setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader, -1L);
    }

    @Override
    public void do_setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.do_setCharacterStream(parameterIndex, value);
    }

    @Override
    public void do_setClob(int parameterIndex, Reader reader) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void do_setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.do_setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void do_setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.do_setCharacterStream(parameterIndex, reader);
    }

    @Override
    public DmdbResultSet do_executeQuery(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public int do_executeUpdate(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void do_close() throws SQLException {
        block18: {
            block15: {
                block17: {
                    block16: {
                        try {
                            try {
                                this.do_clearParameters();
                                if (this.serverParameters != null) {
                                    var4_1 = this.serverParameters;
                                    var3_2 = this.serverParameters.length;
                                    var2_3 = 0;
                                    while (var2_3 < var3_2) {
                                        param = var4_1[var2_3];
                                        MiscUtil.close(param);
                                        ++var2_3;
                                    }
                                }
                                if (this.bindParameters != null) {
                                    var4_1 = this.bindParameters;
                                    var3_2 = this.bindParameters.length;
                                    var2_3 = 0;
                                    while (var2_3 < var3_2) {
                                        param = var4_1[var2_3];
                                        MiscUtil.close(param);
                                        ++var2_3;
                                    }
                                }
                                if (!this.clusterFlag) {
                                    this.primaryFldr.clearEnvironment(1);
                                } else {
                                    for (Fldr fldr : this.usedFldr) {
                                        fldr.clearEnvironment(1);
                                    }
                                }
                                break block15;
                            }
                            catch (Exception e) {
                                DBError.ECJDBC_COMMUNITION_ERROR.throwz(new Object[]{e});
                                if (!this.clusterFlag) break block16;
                                this.clusterExecutor.shutdownNow();
                                ** for (connection : this.connections)
                            }
                        }
                        catch (Throwable var5_13) {
                            if (!this.clusterFlag) break block17;
                            this.clusterExecutor.shutdownNow();
                            ** for (connection : this.connections)
                        }
lbl-1000:
                        // 1 sources

                        {
                            connection.do_close();
                            continue;
                        }
                    }
                    super.do_close();
                    break block18;
lbl-1000:
                    // 1 sources

                    {
                        connection.do_close();
                        continue;
                    }
                }
                super.do_close();
                throw var5_13;
            }
            if (this.clusterFlag) {
                this.clusterExecutor.shutdownNow();
                for (DmdbConnection connection : this.connections) {
                    connection.do_close();
                }
            }
            super.do_close();
        }
    }

    @Override
    public int do_getMaxFieldSize() {
        return this.tableInfo.getColumnInfos().size();
    }

    @Override
    public void do_setMaxFieldSize(int max) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int do_getMaxRows() {
        return this.setEnvInfo.getBldrNumber();
    }

    @Override
    public void do_setMaxRows(int max) throws SQLException {
        if (max > 0 && max <= 10000) {
            this.setEnvInfo.setBdtaSize(max);
        }
        DBError.EC_INVALID_DB_OBJECT.throwz(new Object[0]);
    }

    @Override
    public void do_setEscapeProcessing(boolean enable) {
    }

    @Override
    public void do_setQueryTimeout(int seconds) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_cancel() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void do_setCursorName(String name) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public boolean do_execute(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public DmdbResultSet do_getResultSet() {
        return null;
    }

    @Override
    public int do_getUpdateCount() {
        return -1;
    }

    @Override
    public boolean do_getMoreResults() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public void do_setFetchDirection(int direction) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int do_getFetchDirection() {
        return 0;
    }

    @Override
    public void do_setFetchSize(int rows) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int do_getFetchSize() {
        return -1;
    }

    @Override
    public int do_getResultSetConcurrency() {
        return -1;
    }

    @Override
    public int do_getResultSetType() {
        return -1;
    }

    @Override
    public void do_addBatch(String sql) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public int[] do_executeBatch() throws SQLException {
        if (this.tableInfo.gethTableHead() == null) {
            this.tableInfo.hTableNameData.put(this.tableName, this.multiRowDatas);
        } else {
            int i2 = 0;
            while (i2 < this.multiRowDatas.size()) {
                try {
                    this.tableInfo.getHTabPartition((Object[])this.multiRowDatas.get(i2));
                }
                catch (Exception exception) {
                    this.shutdownExecutor();
                    DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format("Partition mismatched: {currentRow: %s}", i2 + 1));
                }
                ++i2;
            }
        }
        if (this.clusterFlag) {
            this.clusterProcess();
        } else {
            this.noClusterProcess();
        }
        this.tableInfo.clearData();
        this.do_clearBatch();
        return null;
    }

    private void noClusterProcess() throws SQLException {
        for (Map.Entry<String, List<Object[]>> entry : this.tableInfo.hTableNameData.entrySet()) {
            String subTableName = entry.getKey();
            List<Object[]> rowData = entry.getValue();
            if (rowData == null || rowData.size() <= 0) continue;
            this.usedFldr.add(this.primaryFldr);
            short setId = this.primaryFldr.getSetId(String.valueOf(this.schemaName) + ":" + subTableName, this.setEnvInfo.getBldrNumber());
            String containedTab = this.setIdMap.get(setId);
            if (!subTableName.equals(containedTab)) {
                this.setEnvInfo.setSetId(setId);
                this.setEnvInfo.setTableName(subTableName);
                String result = this.primaryFldr.setEnvironment(this.setEnvInfo);
                if (!result.equals("SUCCESS")) {
                    DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format("set Fldr Environment %s : %s", subTableName, result));
                }
                this.setIdMap.put(setId, subTableName);
            }
            List<ColumnData> columnData = this.getColumnDataList(rowData);
            this.primaryFldr.insert(columnData, this.tableInfo, rowData.size(), setId);
        }
    }

    private void clusterProcess() throws SQLException {
        HashMap<Integer, ArrayList<Map.Entry<String, List<Object[]>>>> map = new HashMap<Integer, ArrayList<Map.Entry<String, List<Object[]>>>>();
        try {
            for (Map.Entry<String, List<Object[]>> entry : this.tableInfo.hTableNameData.entrySet()) {
                int bpId;
                if (this.tableInfo.subTableNameIdMap != null) {
                    int tableId = this.tableInfo.subTableNameIdMap.get(entry.getKey());
                    bpId = this.clusterInfo.tabIdToBpIdMap.get(tableId);
                } else {
                    bpId = this.clusterInfo.tabIdToBpIdMap.values().iterator().next();
                }
                ArrayList<Map.Entry<String, List<Object[]>>> list = (ArrayList<Map.Entry<String, List<Object[]>>>)map.get(bpId);
                if (list == null) {
                    list = new ArrayList<Map.Entry<String, List<Object[]>>>();
                }
                list.add(entry);
                map.put(bpId, list);
                if (this.lastBpIdTabName.get(bpId) != null) continue;
                this.lastBpIdTabName.put(bpId, new HashMap());
            }
        }
        catch (Exception e2) {
            this.shutdownExecutor();
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
        }
        FldrPreparedStatement.doTaskOnEverySite(this.clusterExecutor, map.entrySet(), map.entrySet().size(), new Callback<Map.Entry<Integer, List<Map.Entry<String, List<Object[]>>>>>(){

            @Override
            void run(Map.Entry<Integer, List<Map.Entry<String, List<Object[]>>>> entry) throws SQLException {
                try {
                    Integer bpId = entry.getKey();
                    Fldr fldr = (Fldr)FldrPreparedStatement.this.fldrsMap.get(bpId);
                    Map tableMaps = (Map)FldrPreparedStatement.this.lastBpIdTabName.get(bpId);
                    List<Map.Entry<String, List<Object[]>>> entryList = entry.getValue();
                    FldrPreparedStatement.this.usedFldr.add(fldr);
                    SetEnvInfo localSetEnv = (SetEnvInfo)FldrPreparedStatement.this.setEnvInfo.clone();
                    for (Map.Entry<String, List<Object[]>> subEntry : entryList) {
                        String subTableName = subEntry.getKey();
                        List<Object[]> rowData = subEntry.getValue();
                        short setId = fldr.getSetId(bpId + ":" + FldrPreparedStatement.this.schemaName + ":" + subTableName, FldrPreparedStatement.this.setEnvInfo.getBldrNumber());
                        String containedTab = (String)tableMaps.get(setId);
                        if (!subTableName.equals(containedTab)) {
                            localSetEnv.setSetId(setId);
                            localSetEnv.setTableName(subTableName);
                            String result = fldr.setEnvironment(localSetEnv);
                            if (!result.equals("SUCCESS")) {
                                FldrPreparedStatement.this.shutdownExecutor();
                                DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format("set Fldr Environment %s : %s", subTableName, result));
                            }
                            tableMaps.put(setId, subTableName);
                            FldrPreparedStatement.this.lastBpIdTabName.put(bpId, tableMaps);
                        }
                        List columnData = FldrPreparedStatement.this.getColumnDataList(rowData);
                        fldr.insert(columnData, FldrPreparedStatement.this.tableInfo, rowData.size(), setId);
                    }
                }
                catch (Exception e2) {
                    FldrPreparedStatement.this.shutdownExecutor();
                    e2.printStackTrace();
                    DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
                }
            }
        });
    }

    private List<ColumnData> getColumnDataList(List<Object[]> rowDataList) throws SQLException {
        if (rowDataList == null || rowDataList.size() == 0) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz(new Object[0]);
        }
        List<ColumnData> columnDataList = this.createColumn(rowDataList.get(0).length, rowDataList.size());
        int i2 = 0;
        while (i2 < rowDataList.size()) {
            Object[] rowData = rowDataList.get(i2);
            int j2 = 0;
            while (j2 < rowData.length) {
                Object o2 = rowData[j2];
                ColumnData columnData = columnDataList.get(j2);
                if (j2 == this.tableInfo.autoIncrementColId) {
                    this.processAutoIncrementColumn(i2, columnData, o2);
                } else if (o2 == null) {
                    if (columnData.getSqlType() == 12 || columnData.getSqlType() == 19) {
                        columnData.getData().add(o2);
                    }
                    columnData.setIsAllNotNull(0);
                } else {
                    columnData.getData().add(o2);
                    columnData.getNullArr()[i2] = 1;
                }
                ++j2;
            }
            ++i2;
        }
        return columnDataList;
    }

    private List<ColumnData> createColumn(int length, int rows) {
        if (this.columnDataMeta == null || this.columnDataMeta.size() == 0) {
            this.columnDataMeta = new ArrayList<ColumnData>(length);
            int i2 = 0;
            while (i2 < length) {
                ColumnData columnData = new ColumnData();
                columnData.setColumnIndex(i2);
                columnData.setSqlType(this.tableInfo.getColumnInfos().get(i2).getColumnType());
                columnData.setIsAllNotNull(1);
                columnData.setNullArr(new byte[rows]);
                columnData.setData(new ArrayList<Object>(rows));
                this.columnDataMeta.add(columnData);
                ++i2;
            }
        } else {
            for (ColumnData columnData : this.columnDataMeta) {
                columnData.setIsAllNotNull(1);
                columnData.setNullArr(new byte[rows]);
                columnData.setData(new ArrayList<Object>(rows));
            }
        }
        return this.columnDataMeta;
    }

    private void processAutoIncrementColumn(int index, ColumnData columnData, Object o2) throws SQLException {
        if (this.setEnvInfo.getSetIdentity() == 0) {
            columnData.setIsAllNotNull(0);
            return;
        }
        if (o2 == null) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(String.format("The auto-increasing number mismatched: {currentRow: %s}", index));
        }
        columnData.getNullArr()[index] = 1;
        columnData.getData().add(o2);
    }

    @Override
    public DmdbConnection do_getConnection() {
        return this.connection;
    }

    @Override
    public boolean do_getMoreResults(int current) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public DmdbResultSet do_getGeneratedKeys() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public int do_executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return -1;
    }

    @Override
    public int do_executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return 0;
    }

    @Override
    public int do_executeUpdate(String sql, String[] columnNames) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return 0;
    }

    @Override
    public boolean do_execute(String sql, int autoGeneratedKeys) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public boolean do_execute(String sql, int[] columnIndexes) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public boolean do_execute(String sql, String[] columnNames) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public int do_getResultSetHoldability() {
        return -1;
    }

    @Override
    public boolean do_isPoolable() {
        return false;
    }

    @Override
    public boolean do_isCloseOnCompletion() {
        return false;
    }

    public <T> T do_unwrap(Class<T> iface) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    public boolean do_isWrapperFor(Class<?> iface) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    private void setFldrTableInfo(String schemaName, String tableName) throws SQLException {
        if (!this.firstFlag) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz("FldrPreparedStatement could not set tableInfo again");
        }
        if (schemaName == null || schemaName.length() == 0) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz("Schema name could not be empty");
        }
        if (tableName == null || tableName.length() == 0) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz("Table name could not be empty");
        }
        this.firstFlag = false;
        this.schemaName = schemaName.toUpperCase();
        this.tableName = tableName.toUpperCase();
        this.clusterFlag = false;
        this.primaryFldr = this.connection.getFldrInstance();
        this.tableInfo = this.primaryFldr.getTableInfo(this.schemaName, this.tableName, this.lockFlag);
        this.tableInfo.setConn(this.connection);
        if (this.tableInfo.containDecimal) {
            this.getDecimalPrecAndScale();
        }
        if (this.tableInfo.dpcFlag) {
            this.clusterFlag = this.tableInfo.dpcFlag;
            this.clusterInfo = this.primaryFldr.getMppInfo(this.schemaName, this.tableName);
            this.clusterExecutor = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), this.clusterInfo.ipInfoList.size()));
            this.fldrsMap = new ConcurrentHashMap();
            this.connections = new CopyOnWriteArrayList<DmdbConnection>();
            FldrPreparedStatement.doTaskOnEverySite(this.clusterExecutor, this.clusterInfo.ipInfoList, this.clusterInfo.ipInfoList.size(), new Callback<Object[]>(){

                @Override
                void run(Object[] ipInfo) throws SQLException {
                    try {
                        DmProperties props = (DmProperties)FldrPreparedStatement.this.connection.props.clone();
                        props.setProperty(Configuration.user.getName(), FldrPreparedStatement.this.connection.user);
                        props.setProperty(Configuration.password.getName(), FldrPreparedStatement.this.connection.password);
                        props.setProperty(Configuration.mppLocal.getName(), "true");
                        props.setProperty(Configuration.host.getName(), String.valueOf(ipInfo[1]));
                        props.setProperty(Configuration.port.getName(), String.valueOf(ipInfo[2]));
                        props.setProperty(Configuration.epGroup.getName(), null);
                        DmdbConnection conn = DmDriver.driver.do_connect(props);
                        FldrPreparedStatement.this.connections.add(conn);
                        FldrPreparedStatement.this.fldrsMap.put((Integer)ipInfo[0], conn.getFldrInstance());
                    }
                    catch (Exception e2) {
                        FldrPreparedStatement.this.shutdownExecutor();
                        DBError.ECJDBC_COMMUNITION_ERROR.throwz(e2);
                    }
                }
            });
        }
        this.paramCount = this.tableInfo.getNameIdMap().size();
        this.curRowDatas = new Object[this.paramCount];
    }

    private void getDecimalPrecAndScale() throws SQLException {
        List<ColumnInfo> columnInfos = this.tableInfo.getColumnInfos();
        DmdbResultSet resultSet = DriverUtil.executeQuery(this.connection, String.format(DECIMAL_PRECISION_SCALE_SQL, this.schemaName, this.tableName));
        DmdbResultSetMetaData resultSetMetaData = resultSet.do_getMetaData();
        for (ColumnInfo info : columnInfos) {
            if (9 != info.getColumnType()) continue;
            int precision = resultSetMetaData.do_getPrecision(info.getColumnId() + 1);
            int scale = resultSetMetaData.do_getScale(info.getColumnId() + 1);
            this.columnIdScale.put(Integer.valueOf(info.getColumnId()), new int[]{precision, scale});
        }
        resultSet.do_close();
    }

    private void setFldrProperties(FldrConfig config) throws SQLException {
        if (config == null) {
            DBError.ECJDBC_NOT_ALLOW_NULL.throwz("FldrConfig could not be null");
        }
        this.setEnvInfo = new SetEnvInfo();
        this.setEnvInfo.setSetIdentity(config.setIdentity ? 1 : 0);
        this.setEnvInfo.setSorted(config.sorted ? 1 : 0);
        this.setEnvInfo.setBdtaSize(config.maxRows);
        this.setEnvInfo.setIndexOption(config.indexOption);
        this.setEnvInfo.setCharset(this.connection.getServerEncoding());
        this.setEnvInfo.setIgnoreConflict(config.ignoreConflict == null ? 0 : config.ignoreConflict.value);
        this.setEnvInfo.setBldrNumber(config.bldrNum);
        this.setEnvInfo.setFlushFlag(config.flushFlag ? (byte)1 : 0);
        this.setEnvInfo.setSchemaName(this.schemaName);
        this.setEnvInfo.setTableName(this.tableName);
        this.rows = config.maxRows;
    }

    public static <T> void doTaskOnEverySite(ExecutorService executor, Collection<T> list, int siteCount, final Callback<T> callback) throws SQLException {
        if (siteCount == 0 || executor == null) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(siteCount);
        FldrTask[] tasks = new FldrTask[siteCount];
        int i2 = 0;
        for (final T siteObj : list) {
            tasks[i2] = new FldrTask(countDownLatch){

                @Override
                protected void doTask() throws SQLException {
                    callback.run(siteObj);
                }
            };
            executor.execute(tasks[i2]);
            ++i2;
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {}
        FldrTask[] fldrTaskArray = tasks;
        int n2 = tasks.length;
        int n3 = 0;
        while (n3 < n2) {
            FldrTask task = fldrTaskArray[n3];
            if (!task.isSuccess()) {
                if (task.getError() == null) break;
                throw task.getError();
            }
            ++n3;
        }
    }

    static abstract class Callback<T> {
        Callback() {
        }

        abstract void run(T var1) throws SQLException;
    }
}

