/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.reader;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.function.BiConsumer;
import shade.com.alibaba.fastjson2.JSONReader;
import shade.com.alibaba.fastjson2.reader.FieldReader;
import shade.com.alibaba.fastjson2.schema.JSONSchema;
import shade.com.alibaba.fastjson2.util.TypeUtils;

final class FieldReaderFloatFunc<T>
extends FieldReader<T> {
    final BiConsumer<T, Float> function;

    public FieldReaderFloatFunc(String fieldName, Class fieldClass, int ordinal, long features, String format, Locale locale, Float defaultValue, JSONSchema schema, Method method, BiConsumer<T, Float> function) {
        super(fieldName, fieldClass, fieldClass, ordinal, features, format, locale, defaultValue, schema, method, null);
        this.function = function;
    }

    @Override
    public void accept(T object, Object value) {
        Float floatValue = TypeUtils.toFloat(value);
        if (this.schema != null) {
            this.schema.assertValidate(floatValue);
        }
        this.function.accept(object, floatValue);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Float fieldValue;
        try {
            fieldValue = jsonReader.readFloat();
        }
        catch (Exception e) {
            if ((jsonReader.features(this.features) & JSONReader.Feature.NullOnError.mask) != 0L) {
                fieldValue = null;
            }
            throw e;
        }
        if (this.schema != null) {
            this.schema.assertValidate(fieldValue);
        }
        this.function.accept(object, fieldValue);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readFloat();
    }

    @Override
    public BiConsumer getFunction() {
        return this.function;
    }
}

