/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.reader;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import shade.com.alibaba.fastjson2.JSONException;
import shade.com.alibaba.fastjson2.JSONReader;
import shade.com.alibaba.fastjson2.reader.FieldReaderObject;
import shade.com.alibaba.fastjson2.reader.ObjectReader;
import shade.com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import shade.com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import shade.com.alibaba.fastjson2.reader.ObjectReaderImplObject;
import shade.com.alibaba.fastjson2.reader.ObjectReaderImplString;
import shade.com.alibaba.fastjson2.schema.JSONSchema;

class FieldReaderMapMethodReadOnly<T>
extends FieldReaderObject<T> {
    FieldReaderMapMethodReadOnly(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, JSONSchema schema, Method method, Field field) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, null, null, schema, method, field, null);
    }

    @Override
    public ObjectReader getItemObjectReader(JSONReader jsonReader) {
        if (this.itemReader != null) {
            return this.itemReader;
        }
        ObjectReader objectReader = this.getObjectReader(jsonReader);
        if (objectReader instanceof ObjectReaderImplMap) {
            this.itemReader = ObjectReaderImplString.INSTANCE;
            return this.itemReader;
        }
        if (objectReader instanceof ObjectReaderImplMapTyped) {
            Type valueType = ((ObjectReaderImplMapTyped)objectReader).valueType;
            this.itemReader = jsonReader.getObjectReader(valueType);
            return this.itemReader;
        }
        return ObjectReaderImplObject.INSTANCE;
    }

    @Override
    public void accept(T object, Object value) {
        Map map;
        if (value == null) {
            return;
        }
        try {
            map = (Map)this.method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
        if (map == Collections.EMPTY_MAP || map == null) {
            return;
        }
        String name = map.getClass().getName();
        if ("java.util.Collections$UnmodifiableMap".equals(name)) {
            return;
        }
        if (this.schema != null) {
            this.schema.assertValidate(value);
        }
        map.putAll((Map)value);
    }

    @Override
    public void processExtra(JSONReader jsonReader, Object object) {
        Map map;
        try {
            map = (Map)this.method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
        String name = jsonReader.getFieldName();
        ObjectReader itemObjectReader = this.getItemObjectReader(jsonReader);
        Object value = itemObjectReader.readObject(jsonReader, this.getItemType(), this.fieldName, 0L);
        map.put(name, value);
    }

    @Override
    public void acceptExtra(Object object, String name, Object value) {
        Map map;
        try {
            map = (Map)this.method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error");
        }
        map.put(name, value);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        if (this.initReader == null) {
            this.initReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        Object value = jsonReader.jsonb ? this.initReader.readJSONBObject(jsonReader, this.getItemType(), this.fieldName, this.features) : this.initReader.readObject(jsonReader, this.getItemType(), this.fieldName, this.features);
        this.accept(object, value);
    }
}

