/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alibaba.fastjson2.reader;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import shade.com.alibaba.fastjson2.JSON;
import shade.com.alibaba.fastjson2.JSONException;
import shade.com.alibaba.fastjson2.JSONFactory;
import shade.com.alibaba.fastjson2.JSONReader;
import shade.com.alibaba.fastjson2.PropertyNamingStrategy;
import shade.com.alibaba.fastjson2.codec.BeanInfo;
import shade.com.alibaba.fastjson2.codec.FieldInfo;
import shade.com.alibaba.fastjson2.function.FieldBiConsumer;
import shade.com.alibaba.fastjson2.function.FieldConsumer;
import shade.com.alibaba.fastjson2.modules.ObjectCodecProvider;
import shade.com.alibaba.fastjson2.modules.ObjectReaderAnnotationProcessor;
import shade.com.alibaba.fastjson2.modules.ObjectReaderModule;
import shade.com.alibaba.fastjson2.reader.ByteArrayValueConsumer;
import shade.com.alibaba.fastjson2.reader.CharArrayValueConsumer;
import shade.com.alibaba.fastjson2.reader.FieldReader;
import shade.com.alibaba.fastjson2.reader.ObjectArrayReader;
import shade.com.alibaba.fastjson2.reader.ObjectReader;
import shade.com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import shade.com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import shade.com.alibaba.fastjson2.reader.ObjectReaderCreator;
import shade.com.alibaba.fastjson2.reader.ObjectReaderCreatorASM;
import shade.com.alibaba.fastjson2.reader.ObjectReaderImplList;
import shade.com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import shade.com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import shade.com.alibaba.fastjson2.reader.ObjectReaderImplOptional;
import shade.com.alibaba.fastjson2.reader.ObjectReaderImplString;
import shade.com.alibaba.fastjson2.reader.ObjectReaderSeeAlso;
import shade.com.alibaba.fastjson2.support.LambdaMiscCodec;
import shade.com.alibaba.fastjson2.util.BeanUtils;
import shade.com.alibaba.fastjson2.util.Fnv;
import shade.com.alibaba.fastjson2.util.JDKUtils;
import shade.com.alibaba.fastjson2.util.TypeUtils;

public class ObjectReaderProvider
implements ObjectCodecProvider {
    static final ClassLoader FASTJSON2_CLASS_LOADER;
    public static final boolean SAFE_MODE;
    static final String[] DENYS;
    static final String[] AUTO_TYPE_ACCEPT_LIST;
    static JSONReader.AutoTypeBeforeHandler DEFAULT_AUTO_TYPE_BEFORE_HANDLER;
    static Consumer<Class> DEFAULT_AUTO_TYPE_HANDLER;
    static boolean DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR;
    static ObjectReaderCachePair readerCache;
    final ConcurrentMap<Type, ObjectReader> cache = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Type, ObjectReader> cacheFieldBased = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Integer, ConcurrentHashMap<Long, ObjectReader>> tclHashCaches = new ConcurrentHashMap<Integer, ConcurrentHashMap<Long, ObjectReader>>();
    final ConcurrentMap<Long, ObjectReader> hashCache = new ConcurrentHashMap<Long, ObjectReader>();
    final ConcurrentMap<Class, Class> mixInCache = new ConcurrentHashMap<Class, Class>();
    final LRUAutoTypeCache autoTypeList = new LRUAutoTypeCache(1024);
    private final ConcurrentMap<Type, Map<Type, Function>> typeConverts = new ConcurrentHashMap<Type, Map<Type, Function>>();
    final ObjectReaderCreator creator;
    final List<ObjectReaderModule> modules = new ArrayList<ObjectReaderModule>();
    private long[] acceptHashCodes;
    private JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler = DEFAULT_AUTO_TYPE_BEFORE_HANDLER;
    private Consumer<Class> autoTypeHandler = DEFAULT_AUTO_TYPE_HANDLER;

    public void registerIfAbsent(long hashCode, ObjectReader objectReader) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl != null && tcl != JSON.class.getClassLoader()) {
            int tclHash = System.identityHashCode(tcl);
            ConcurrentHashMap tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash);
            if (tclHashCache == null) {
                this.tclHashCaches.putIfAbsent(tclHash, new ConcurrentHashMap());
                tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash);
            }
            tclHashCache.putIfAbsent(hashCode, objectReader);
        }
        this.hashCache.putIfAbsent(hashCode, objectReader);
    }

    public void addAutoTypeAccept(String name) {
        long hash;
        if (name != null && name.length() != 0 && Arrays.binarySearch(this.acceptHashCodes, hash = Fnv.hashCode64(name)) < 0) {
            long[] hashCodes = new long[this.acceptHashCodes.length + 1];
            hashCodes[hashCodes.length - 1] = hash;
            System.arraycopy(this.acceptHashCodes, 0, hashCodes, 0, this.acceptHashCodes.length);
            Arrays.sort(hashCodes);
            this.acceptHashCodes = hashCodes;
        }
    }

    @Deprecated
    public void addAutoTypeDeny(String name) {
    }

    public Consumer<Class> getAutoTypeHandler() {
        return this.autoTypeHandler;
    }

    public void setAutoTypeHandler(Consumer<Class> autoTypeHandler) {
        this.autoTypeHandler = autoTypeHandler;
    }

    @Override
    public Class getMixIn(Class target) {
        return (Class)this.mixInCache.get(target);
    }

    public void cleanupMixIn() {
        this.mixInCache.clear();
    }

    public void mixIn(Class target, Class mixinSource) {
        if (mixinSource == null) {
            this.mixInCache.remove(target);
        } else {
            this.mixInCache.put(target, mixinSource);
        }
        this.cache.remove(target);
        this.cacheFieldBased.remove(target);
    }

    public void registerSeeAlsoSubType(Class subTypeClass) {
        this.registerSeeAlsoSubType(subTypeClass, null);
    }

    public void registerSeeAlsoSubType(Class subTypeClass, String subTypeClassName) {
        ObjectReaderSeeAlso readerSeeAlso;
        ObjectReaderSeeAlso readerSeeAlsoNew;
        Class superClass = subTypeClass.getSuperclass();
        if (superClass == null) {
            throw new JSONException("superclass is null");
        }
        ObjectReader objectReader = this.getObjectReader(superClass);
        if (objectReader instanceof ObjectReaderSeeAlso && (readerSeeAlsoNew = (readerSeeAlso = (ObjectReaderSeeAlso)objectReader).addSubType(subTypeClass, subTypeClassName)) != readerSeeAlso) {
            if (this.cache.containsKey(superClass)) {
                this.cache.put(superClass, readerSeeAlsoNew);
            } else {
                this.cacheFieldBased.put(subTypeClass, readerSeeAlsoNew);
            }
        }
    }

    public ObjectReader register(Type type, ObjectReader objectReader, boolean fieldBased) {
        ConcurrentMap<Type, ObjectReader> cache;
        ConcurrentMap<Type, ObjectReader> concurrentMap = cache = fieldBased ? this.cacheFieldBased : this.cache;
        if (objectReader == null) {
            return (ObjectReader)cache.remove(type);
        }
        return cache.put(type, objectReader);
    }

    public ObjectReader register(Type type, ObjectReader objectReader) {
        return this.register(type, objectReader, false);
    }

    public ObjectReader registerIfAbsent(Type type, ObjectReader objectReader) {
        return this.registerIfAbsent(type, objectReader, false);
    }

    public ObjectReader registerIfAbsent(Type type, ObjectReader objectReader, boolean fieldBased) {
        ConcurrentMap<Type, ObjectReader> cache = fieldBased ? this.cacheFieldBased : this.cache;
        return cache.putIfAbsent(type, objectReader);
    }

    public ObjectReader unregisterObjectReader(Type type) {
        return this.unregisterObjectReader(type, false);
    }

    public ObjectReader unregisterObjectReader(Type type, boolean fieldBased) {
        ConcurrentMap<Type, ObjectReader> cache = fieldBased ? this.cacheFieldBased : this.cache;
        return (ObjectReader)cache.remove(type);
    }

    public boolean unregisterObjectReader(Type type, ObjectReader reader) {
        return this.unregisterObjectReader(type, reader, false);
    }

    public boolean unregisterObjectReader(Type type, ObjectReader reader, boolean fieldBased) {
        ConcurrentMap<Type, ObjectReader> cache = fieldBased ? this.cacheFieldBased : this.cache;
        return cache.remove(type, reader);
    }

    public boolean register(ObjectReaderModule module) {
        for (int i = this.modules.size() - 1; i >= 0; --i) {
            if (this.modules.get(i) != module) continue;
            return false;
        }
        module.init(this);
        this.modules.add(0, module);
        return true;
    }

    public boolean unregister(ObjectReaderModule module) {
        return this.modules.remove(module);
    }

    public void cleanup(Class objectClass) {
        this.mixInCache.remove(objectClass);
        this.cache.remove(objectClass);
        this.cacheFieldBased.remove(objectClass);
        for (ConcurrentHashMap tlc : this.tclHashCaches.values()) {
            Iterator it = tlc.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ObjectReader reader = (ObjectReader)entry.getValue();
                if (reader.getObjectClass() != objectClass) continue;
                it.remove();
            }
        }
        BeanUtils.cleanupCache(objectClass);
    }

    static boolean match(Type objectType, ObjectReader objectReader, ClassLoader classLoader) {
        Class<?> objectClass = TypeUtils.getClass(objectType);
        if (objectClass != null && objectClass.getClassLoader() == classLoader) {
            return true;
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)objectType;
            Type rawType = paramType.getRawType();
            if (ObjectReaderProvider.match(rawType, objectReader, classLoader)) {
                return true;
            }
            Type[] typeArray = paramType.getActualTypeArguments();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type argType = typeArray[i];
                if (!ObjectReaderProvider.match(argType, objectReader, classLoader)) continue;
                return true;
            }
        }
        if (objectReader instanceof ObjectReaderImplMapTyped) {
            ObjectReaderImplMapTyped mapTyped = (ObjectReaderImplMapTyped)objectReader;
            Class valueClass = mapTyped.valueClass;
            if (valueClass != null && valueClass.getClassLoader() == classLoader) {
                return true;
            }
            Class<?> keyClass = TypeUtils.getClass(mapTyped.keyType);
            return keyClass != null && keyClass.getClassLoader() == classLoader;
        }
        if (objectReader instanceof ObjectReaderImplList) {
            ObjectReaderImplList list = (ObjectReaderImplList)objectReader;
            return list.itemClass != null && list.itemClass.getClassLoader() == classLoader;
        }
        if (objectReader instanceof ObjectReaderImplOptional) {
            Class itemClass = ((ObjectReaderImplOptional)objectReader).itemClass;
            return itemClass != null && itemClass.getClassLoader() == classLoader;
        }
        if (objectReader instanceof ObjectReaderAdapter) {
            FieldReader[] fieldReaders;
            for (FieldReader fieldReader : fieldReaders = ((ObjectReaderAdapter)objectReader).fieldReaders) {
                if (fieldReader.fieldClass != null && fieldReader.fieldClass.getClassLoader() == classLoader) {
                    return true;
                }
                Type fieldType = fieldReader.fieldType;
                if (!(fieldType instanceof ParameterizedType) || !ObjectReaderProvider.match(fieldType, null, classLoader)) continue;
                return true;
            }
        }
        return false;
    }

    public void cleanup(ClassLoader classLoader) {
        this.mixInCache.entrySet().removeIf(entry -> ((Class)entry.getKey()).getClassLoader() == classLoader);
        this.cache.entrySet().removeIf(entry -> ObjectReaderProvider.match((Type)entry.getKey(), (ObjectReader)entry.getValue(), classLoader));
        this.cacheFieldBased.entrySet().removeIf(entry -> ObjectReaderProvider.match((Type)entry.getKey(), (ObjectReader)entry.getValue(), classLoader));
        int tclHash = System.identityHashCode(classLoader);
        this.tclHashCaches.remove(tclHash);
        BeanUtils.cleanupCache(classLoader);
    }

    public ObjectReaderCreator getCreator() {
        ObjectReaderCreator contextCreator = JSONFactory.getContextReaderCreator();
        if (contextCreator != null) {
            return contextCreator;
        }
        return this.creator;
    }

    public ObjectReaderProvider() {
        long[] hashCodes;
        if (AUTO_TYPE_ACCEPT_LIST == null) {
            hashCodes = new long[1];
        } else {
            hashCodes = new long[AUTO_TYPE_ACCEPT_LIST.length + 1];
            for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
                hashCodes[i] = Fnv.hashCode64(AUTO_TYPE_ACCEPT_LIST[i]);
            }
        }
        hashCodes[hashCodes.length - 1] = -6293031534589903644L;
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
        this.hashCache.put(ObjectArrayReader.TYPE_HASH_CODE, ObjectArrayReader.INSTANCE);
        long STRING_CLASS_NAME_HASH = -4834614249632438472L;
        this.hashCache.put(-4834614249632438472L, ObjectReaderImplString.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(TypeUtils.getTypeName(HashMap.class)), ObjectReaderImplMap.INSTANCE);
        ObjectReaderCreator creator = null;
        switch (JSONFactory.CREATOR) {
            case "reflect": 
            case "lambda": {
                creator = ObjectReaderCreator.INSTANCE;
                break;
            }
            default: {
                try {
                    if (!JDKUtils.ANDROID && !JDKUtils.GRAAL) {
                        creator = ObjectReaderCreatorASM.INSTANCE;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (creator != null) break;
                creator = ObjectReaderCreator.INSTANCE;
            }
        }
        this.creator = creator;
        this.modules.add(new ObjectReaderBaseModule(this));
        this.init();
    }

    public ObjectReaderProvider(ObjectReaderCreator creator) {
        long[] hashCodes;
        if (AUTO_TYPE_ACCEPT_LIST == null) {
            hashCodes = new long[1];
        } else {
            hashCodes = new long[AUTO_TYPE_ACCEPT_LIST.length + 1];
            for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
                hashCodes[i] = Fnv.hashCode64(AUTO_TYPE_ACCEPT_LIST[i]);
            }
        }
        hashCodes[hashCodes.length - 1] = -6293031534589903644L;
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
        this.hashCache.put(ObjectArrayReader.TYPE_HASH_CODE, ObjectArrayReader.INSTANCE);
        long STRING_CLASS_NAME_HASH = -4834614249632438472L;
        this.hashCache.put(-4834614249632438472L, ObjectReaderImplString.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(TypeUtils.getTypeName(HashMap.class)), ObjectReaderImplMap.INSTANCE);
        this.creator = creator;
        this.modules.add(new ObjectReaderBaseModule(this));
        this.init();
    }

    void init() {
        for (ObjectReaderModule module : this.modules) {
            module.init(this);
        }
    }

    public Function getTypeConvert(Type from, Type to) {
        Map map = (Map)this.typeConverts.get(from);
        if (map == null) {
            return null;
        }
        return (Function)map.get(to);
    }

    public Function registerTypeConvert(Type from, Type to, Function typeConvert) {
        Map map = (Map)this.typeConverts.get(from);
        if (map == null) {
            this.typeConverts.putIfAbsent(from, new ConcurrentHashMap());
            map = (Map)this.typeConverts.get(from);
        }
        return map.put(to, typeConvert);
    }

    public ObjectReader getObjectReader(long hashCode) {
        int tclHash;
        ConcurrentHashMap tclHashCache;
        ObjectReaderCachePair pair = readerCache;
        if (pair != null) {
            if (pair.hashCode == hashCode) {
                return pair.reader;
            }
            if (pair.missCount++ > 16) {
                readerCache = null;
            }
        }
        Long hashCodeObj = hashCode;
        ObjectReader objectReader = null;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl != null && tcl != FASTJSON2_CLASS_LOADER && (tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash = System.identityHashCode(tcl))) != null) {
            objectReader = (ObjectReader)tclHashCache.get(hashCodeObj);
        }
        if (objectReader == null) {
            objectReader = (ObjectReader)this.hashCache.get(hashCodeObj);
        }
        if (objectReader != null && readerCache == null) {
            readerCache = new ObjectReaderCachePair(hashCode, objectReader);
        }
        return objectReader;
    }

    public ObjectReader getObjectReader(String typeName, Class<?> expectClass, long features) {
        Class<?> autoTypeClass = this.checkAutoType(typeName, expectClass, features);
        if (autoTypeClass == null) {
            return null;
        }
        boolean fieldBased = (features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.getObjectReader(autoTypeClass, fieldBased);
        if (autoTypeClass != expectClass) {
            this.registerIfAbsent(Fnv.hashCode64(typeName), objectReader);
        }
        return objectReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void afterAutoType(String typeName, Class type) {
        if (this.autoTypeHandler != null) {
            this.autoTypeHandler.accept(type);
        }
        LRUAutoTypeCache lRUAutoTypeCache = this.autoTypeList;
        synchronized (lRUAutoTypeCache) {
            this.autoTypeList.putIfAbsent(typeName, new Date());
        }
    }

    public Class<?> checkAutoType(String typeName, Class<?> expectClass, long features) {
        Class clazz;
        int ch;
        int i;
        long hash;
        boolean autoTypeSupport;
        Class<?> resolvedClass;
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        if (this.autoTypeBeforeHandler != null && (resolvedClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, features)) != null) {
            this.afterAutoType(typeName, resolvedClass);
            return resolvedClass;
        }
        if (SAFE_MODE) {
            return null;
        }
        int typeNameLength = typeName.length();
        if (typeNameLength >= 192) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        if (typeName.charAt(0) == '[') {
            String componentTypeName = typeName.substring(1);
            this.checkAutoType(componentTypeName, null, features);
        }
        if (expectClass != null && expectClass.getName().equals(typeName)) {
            this.afterAutoType(typeName, expectClass);
            return expectClass;
        }
        boolean bl = autoTypeSupport = (features & JSONReader.Feature.SupportAutoType.mask) != 0L;
        if (autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.acceptHashCodes, hash *= 1099511628211L) < 0 || (clazz = TypeUtils.loadClass(typeName)) == null) continue;
                if (expectClass != null && !expectClass.isAssignableFrom(clazz)) {
                    throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                }
                this.afterAutoType(typeName, clazz);
                return clazz;
            }
        }
        if (!autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.acceptHashCodes, hash *= 1099511628211L) < 0) continue;
                clazz = TypeUtils.loadClass(typeName);
                if (clazz != null && expectClass != null && !expectClass.isAssignableFrom(clazz)) {
                    throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                }
                this.afterAutoType(typeName, clazz);
                return clazz;
            }
        }
        if (!autoTypeSupport) {
            return null;
        }
        clazz = TypeUtils.getMapping(typeName);
        if (clazz != null) {
            if (expectClass != null && expectClass != Object.class && clazz != HashMap.class && !expectClass.isAssignableFrom(clazz)) {
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
            this.afterAutoType(typeName, clazz);
            return clazz;
        }
        clazz = TypeUtils.loadClass(typeName);
        if (clazz != null) {
            if (ClassLoader.class.isAssignableFrom(clazz) || JDKUtils.isSQLDataSourceOrRowSet(clazz)) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            if (expectClass != null) {
                if (expectClass.isAssignableFrom(clazz)) {
                    this.afterAutoType(typeName, clazz);
                    return clazz;
                }
                if ((features & JSONReader.Feature.IgnoreAutoTypeNotMatch.mask) != 0L) {
                    return expectClass;
                }
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
        }
        this.afterAutoType(typeName, clazz);
        return clazz;
    }

    public List<ObjectReaderModule> getModules() {
        return this.modules;
    }

    public void getBeanInfo(BeanInfo beanInfo, Class objectClass) {
        for (ObjectReaderModule module : this.modules) {
            module.getBeanInfo(beanInfo, objectClass);
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Field field) {
        for (ObjectReaderModule module : this.modules) {
            module.getFieldInfo(fieldInfo, objectClass, field);
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Constructor constructor, int paramIndex, Parameter parameter) {
        for (ObjectReaderModule module : this.modules) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getFieldInfo(fieldInfo, objectClass, constructor, paramIndex, parameter);
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method, int paramIndex, Parameter parameter) {
        for (ObjectReaderModule module : this.modules) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getFieldInfo(fieldInfo, objectClass, method, paramIndex, parameter);
        }
    }

    public ObjectReader getObjectReader(Type objectType) {
        return this.getObjectReader(objectType, false);
    }

    public Function<Consumer, ByteArrayValueConsumer> createValueConsumerCreator(Class objectClass, FieldReader[] fieldReaderArray) {
        return this.creator.createByteArrayValueConsumerCreator(objectClass, fieldReaderArray);
    }

    public Function<Consumer, CharArrayValueConsumer> createCharArrayValueConsumerCreator(Class objectClass, FieldReader[] fieldReaderArray) {
        return this.creator.createCharArrayValueConsumerCreator(objectClass, fieldReaderArray);
    }

    public ObjectReader getObjectReader(Type objectType, boolean fieldBased) {
        Type[] upperBounds;
        ObjectReader objectReader;
        if (objectType == null) {
            objectType = Object.class;
        }
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectType) : (ObjectReader)this.cache.get(objectType);
        if (objectReader == null && objectType instanceof WildcardType && (upperBounds = ((WildcardType)objectType).getUpperBounds()).length == 1) {
            Type upperBoundType = upperBounds[0];
            objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(upperBoundType) : (ObjectReader)this.cache.get(upperBoundType);
        }
        return objectReader != null ? objectReader : this.getObjectReaderInternal((Type)objectType, fieldBased);
    }

    private ObjectReader getObjectReaderInternal(Type objectType, boolean fieldBased) {
        ObjectReader previous;
        ObjectReader boundObjectReader;
        Type bound;
        Type[] bounds;
        ObjectReader objectReader = null;
        for (ObjectReaderModule module : this.modules) {
            ObjectReader previous2;
            objectReader = module.getObjectReader(this, objectType);
            if (objectReader == null) continue;
            ObjectReader objectReader2 = previous2 = fieldBased ? this.cacheFieldBased.putIfAbsent(objectType, objectReader) : this.cache.putIfAbsent(objectType, objectReader);
            if (previous2 != null) {
                objectReader = previous2;
            }
            return objectReader;
        }
        if (objectType instanceof TypeVariable && (bounds = ((TypeVariable)objectType).getBounds()).length > 0 && (bound = bounds[0]) instanceof Class && (boundObjectReader = this.getObjectReader(bound, fieldBased)) != null) {
            ObjectReader previous3 = this.getPreviousObjectReader(fieldBased, objectType, boundObjectReader);
            if (previous3 != null) {
                boundObjectReader = previous3;
            }
            return boundObjectReader;
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)objectType;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (rawType instanceof Class) {
                ObjectReader rawClassReader;
                Class rawClass = (Class)rawType;
                boolean generic = false;
                for (Class clazz = rawClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    if (clazz.getTypeParameters().length <= 0) continue;
                    generic = true;
                    break;
                }
                if (!(typeArguments.length != 0 && generic || (rawClassReader = this.getObjectReader(rawClass, fieldBased)) == null)) {
                    ObjectReader previous4 = this.getPreviousObjectReader(fieldBased, objectType, rawClassReader);
                    if (previous4 != null) {
                        rawClassReader = previous4;
                    }
                    return rawClassReader;
                }
                if (typeArguments.length == 1 && ArrayList.class.isAssignableFrom(rawClass)) {
                    return ObjectReaderImplList.of(objectType, rawClass, 0L);
                }
            }
        }
        Class<?> objectClass = TypeUtils.getMapping(objectType);
        String className = objectClass.getName();
        if (!fieldBased && "com.google.common.collect.ArrayListMultimap".equals(className)) {
            objectReader = ObjectReaderImplMap.of(null, objectClass, 0L);
        }
        if (objectReader == null) {
            Annotation[] annotations;
            boolean jsonCompiled = false;
            for (Annotation annotation : annotations = objectClass.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                jsonCompiled = "shade.com.alibaba.fastjson2.annotation.JSONCompiled".equals(annotationType.getName());
            }
            if (jsonCompiled) {
                String codeGenClassName = objectClass.getName() + "_FASTJOSNReader";
                ClassLoader classLoader = objectClass.getClassLoader();
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                try {
                    Class<?> loadedClass = classLoader.loadClass(codeGenClassName);
                    if (ObjectReader.class.isAssignableFrom(loadedClass)) {
                        objectReader = (ObjectReader)loadedClass.newInstance();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (objectReader == null) {
            ObjectReaderCreator creator = this.getCreator();
            objectReader = creator.createObjectReader(objectClass, objectType, fieldBased, this);
        }
        if ((previous = this.getPreviousObjectReader(fieldBased, objectType, objectReader)) != null) {
            objectReader = previous;
        }
        return objectReader;
    }

    private ObjectReader getPreviousObjectReader(boolean fieldBased, Type objectType, ObjectReader boundObjectReader) {
        return fieldBased ? this.cacheFieldBased.putIfAbsent(objectType, boundObjectReader) : this.cache.putIfAbsent(objectType, boundObjectReader);
    }

    public JSONReader.AutoTypeBeforeHandler getAutoTypeBeforeHandler() {
        return this.autoTypeBeforeHandler;
    }

    public Map<String, Date> getAutoTypeList() {
        return this.autoTypeList;
    }

    public void setAutoTypeBeforeHandler(JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler) {
        this.autoTypeBeforeHandler = autoTypeBeforeHandler;
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method) {
        String findName;
        Field field;
        String methodName;
        for (ObjectReaderModule module : this.modules) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getFieldInfo(fieldInfo, objectClass, method);
        }
        if (fieldInfo.fieldName == null && fieldInfo.alternateNames == null && (methodName = method.getName()).startsWith("set") && (field = BeanUtils.getDeclaredField(objectClass, findName = methodName.substring(3))) != null) {
            fieldInfo.alternateNames = new String[]{findName};
        }
    }

    public <T> Supplier<T> createObjectCreator(Class<T> objectClass, long readerFeatures) {
        ObjectReader objectReader;
        boolean fieldBased = (readerFeatures & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectClass) : (ObjectReader)this.cache.get(objectClass);
        if (objectReader != null) {
            return () -> objectReader.createInstance(0L);
        }
        Constructor constructor = BeanUtils.getDefaultConstructor(objectClass, false);
        if (constructor == null) {
            throw new JSONException("default constructor not found : " + objectClass.getName());
        }
        return LambdaMiscCodec.createSupplier(constructor);
    }

    public FieldReader createFieldReader(Class objectClass, String fieldName, long readerFeatures) {
        ObjectReader objectReader;
        boolean fieldBased = (readerFeatures & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectClass) : (ObjectReader)this.cache.get(objectClass);
        if (objectReader != null) {
            return objectReader.getFieldReader(fieldName);
        }
        AtomicReference fieldRef = new AtomicReference();
        long nameHashLCase = Fnv.hashCode64LCase(fieldName);
        BeanUtils.fields(objectClass, field -> {
            if (nameHashLCase == Fnv.hashCode64LCase(field.getName())) {
                fieldRef.set(field);
            }
        });
        Field field2 = (Field)fieldRef.get();
        if (field2 != null) {
            return this.creator.createFieldReader(fieldName, null, field2.getType(), field2);
        }
        AtomicReference methodRef = new AtomicReference();
        BeanUtils.setters(objectClass, method -> {
            String setterName = BeanUtils.setterName(method.getName(), PropertyNamingStrategy.CamelCase.name());
            if (nameHashLCase == Fnv.hashCode64LCase(setterName)) {
                methodRef.set(method);
            }
        });
        Method method2 = (Method)methodRef.get();
        if (method2 != null) {
            Class<?>[] params = method2.getParameterTypes();
            Class<?> fieldClass = params[0];
            return this.creator.createFieldReaderMethod(objectClass, fieldName, null, fieldClass, fieldClass, method2);
        }
        return null;
    }

    public <T> ObjectReader<T> createObjectReader(String[] names, Type[] types, Supplier<T> supplier, FieldConsumer<T> c) {
        return this.createObjectReader(names, types, null, supplier, c);
    }

    public <T> ObjectReader<T> createObjectReader(String[] names, Type[] types, long[] features, Supplier<T> supplier, FieldConsumer<T> c) {
        FieldReader[] fieldReaders = new FieldReader[names.length];
        for (int i = 0; i < names.length; ++i) {
            Type fieldType = types[i];
            Class<?> fieldClass = TypeUtils.getClass(fieldType);
            long feature = features != null && i < features.length ? features[i] : 0L;
            fieldReaders[i] = this.creator.createFieldReader(names[i], fieldType, fieldClass, feature, new FieldBiConsumer<T>(i, c));
        }
        return this.creator.createObjectReader(null, supplier, fieldReaders);
    }

    static {
        Class handlerClass;
        FASTJSON2_CLASS_LOADER = JSON.class.getClassLoader();
        String property = System.getProperty("fastjson2.parser.deny");
        if (property == null) {
            property = JSONFactory.getProperty("fastjson2.parser.deny");
        }
        DENYS = property != null && property.length() > 0 ? property.split(",") : new String[0];
        property = System.getProperty("fastjson2.autoTypeAccept");
        if (property == null) {
            property = JSONFactory.getProperty("fastjson2.autoTypeAccept");
        }
        AUTO_TYPE_ACCEPT_LIST = property != null && property.length() > 0 ? property.split(",") : new String[0];
        property = System.getProperty("fastjson2.autoTypeBeforeHandler");
        if (property == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.autoTypeBeforeHandler");
        }
        if (property != null) {
            property = property.trim();
        }
        if (property != null && !property.isEmpty() && (handlerClass = TypeUtils.loadClass(property)) != null) {
            try {
                DEFAULT_AUTO_TYPE_BEFORE_HANDLER = (JSONReader.AutoTypeBeforeHandler)handlerClass.newInstance();
            }
            catch (Exception ignored) {
                DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR = true;
            }
        }
        if ((property = System.getProperty("fastjson2.autoTypeHandler")) == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.autoTypeHandler");
        }
        if (property != null) {
            property = property.trim();
        }
        if (property != null && !property.isEmpty() && (handlerClass = TypeUtils.loadClass(property)) != null) {
            try {
                DEFAULT_AUTO_TYPE_HANDLER = (Consumer)handlerClass.newInstance();
            }
            catch (Exception ignored) {
                DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR = true;
            }
        }
        if ((property = System.getProperty("fastjson.parser.safeMode")) == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson.parser.safeMode");
        }
        if (property == null || property.isEmpty()) {
            property = System.getProperty("fastjson2.parser.safeMode");
        }
        if (property == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.parser.safeMode");
        }
        if (property != null) {
            property = property.trim();
        }
        SAFE_MODE = "true".equals(property);
    }

    static class LRUAutoTypeCache
    extends LinkedHashMap<String, Date> {
        private final int maxSize;

        public LRUAutoTypeCache(int maxSize) {
            super(16, 0.75f, false);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Date> eldest) {
            return this.size() > this.maxSize;
        }
    }

    static class ObjectReaderCachePair {
        final long hashCode;
        final ObjectReader reader;
        volatile int missCount;

        public ObjectReaderCachePair(long hashCode, ObjectReader reader) {
            this.hashCode = hashCode;
            this.reader = reader;
        }
    }
}

