/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion.msoffice;

import com.documents4j.conversion.ExternalConverterScriptResult;
import com.documents4j.throwables.FileSystemInteractionException;
import com.google.common.io.Files;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.listener.ProcessListener;

class MicrosoftOfficeTargetNameCorrector
extends ProcessListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrosoftOfficeTargetNameCorrector.class);
    protected final String fileExtension;
    private final File target;

    public MicrosoftOfficeTargetNameCorrector(File target, String fileExtension) {
        this.target = target;
        this.fileExtension = fileExtension;
    }

    public void afterStop(Process process) {
        if (this.conversionSuccessful(process) && (this.targetHasNoFileExtension() || this.targetHasWrongFileExtension())) {
            File renamedTarget = this.makeRenamedTarget();
            LOGGER.trace("Rename file {} to {}", (Object)renamedTarget, (Object)this.target);
            this.tryCleanTarget(renamedTarget);
            if (!renamedTarget.renameTo(this.target)) {
                LOGGER.error("Failed to rename {} to {}", (Object)renamedTarget, (Object)this.target);
                throw new FileSystemInteractionException(String.format("Could not write target file %s", this.target));
            }
        }
    }

    private File makeRenamedTarget() {
        return new File(this.target.getAbsolutePath().concat(this.target.getName().endsWith(".") ? "" : ".").concat(this.fileExtension));
    }

    private void tryCleanTarget(File renamedTarget) {
        if (this.target.isFile() && !this.target.delete() || this.target.isDirectory()) {
            if (renamedTarget.exists() && !renamedTarget.delete()) {
                LOGGER.warn("Could not delete target file {} after failed renaming attempt", (Object)renamedTarget);
            }
            throw new FileSystemInteractionException(String.format("Cannot write converted file to %s", this.target));
        }
    }

    protected boolean targetHasNoFileExtension() {
        return Files.getFileExtension((String)this.target.getName()).length() == 0;
    }

    protected boolean targetHasWrongFileExtension() {
        return !Files.getFileExtension((String)this.target.getName()).equals(this.fileExtension);
    }

    private boolean conversionSuccessful(Process process) {
        return ExternalConverterScriptResult.from((int)process.exitValue()) == ExternalConverterScriptResult.CONVERSION_SUCCESSFUL;
    }
}

