/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.channel.internal;

import com.gettyio.core.channel.AioChannel;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.util.ThreadPool;
import java.nio.channels.CompletionHandler;

public class ReadCompletionHandler
implements CompletionHandler<Integer, AioChannel> {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadCompletionHandler.class);
    private ThreadPool executorService;

    public ReadCompletionHandler(ThreadPool executorService) {
        this.executorService = executorService;
    }

    @Override
    public void completed(final Integer result, final AioChannel aioChannel) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                aioChannel.readFromChannel(result == -1);
            }
        });
    }

    @Override
    public void failed(Throwable exc, AioChannel aioChannel) {
        try {
            aioChannel.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
    }
}

