/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.handler.ssl;

import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.handler.ssl.SslService;
import com.gettyio.core.handler.ssl.sslfacade.IHandshakeCompletedListener;
import com.gettyio.core.handler.ssl.sslfacade.ISSLListener;
import com.gettyio.core.handler.ssl.sslfacade.ISessionClosedListener;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.pipeline.all.ChannelAllBoundHandlerAdapter;
import com.gettyio.core.util.LinkedNonReadBlockQueue;
import java.nio.ByteBuffer;

public class SslHandler
extends ChannelAllBoundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private SslService sslService;
    private SocketChannel socketChannel;
    LinkedNonReadBlockQueue<Object> out;

    public SslHandler(SocketChannel socketChannel, SslService sslService) {
        this.socketChannel = socketChannel;
        this.sslService = sslService;
        this.socketChannel.setSslHandler(this);
        sslService.createSSLFacade(new handshakeCompletedListener(), new SSLListener(), new sessionClosedListener());
    }

    public SslService getSslService() {
        return this.sslService;
    }

    @Override
    public void encode(SocketChannel socketChannel, Object obj) throws Exception {
        byte[] bytes = (byte[])obj;
        if (!this.sslService.getSsl().isHandshakeCompleted() && obj != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            try {
                this.sslService.getSsl().decrypt(byteBuffer);
                byte[] b = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes, 0, b.length);
                socketChannel.writeToChannel(b);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                this.sslService.getSsl().close();
            }
        } else if (bytes != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            this.sslService.getSsl().encrypt(byteBuffer);
        }
    }

    @Override
    public void decode(SocketChannel socketChannel, Object obj, LinkedNonReadBlockQueue<Object> out) throws Exception {
        this.out = out;
        byte[] bytes = (byte[])obj;
        if (!this.sslService.getSsl().isHandshakeCompleted() && obj != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            try {
                this.sslService.getSsl().decrypt(byteBuffer);
                byte[] b = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes, 0, b.length);
                socketChannel.writeToChannel(b);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
                this.sslService.getSsl().close();
                return;
            }
        } else if (bytes != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            this.sslService.getSsl().decrypt(byteBuffer);
        }
    }

    class SSLListener
    implements ISSLListener {
        SSLListener() {
        }

        @Override
        public void onWrappedData(ByteBuffer wrappedBytes) {
            try {
                byte[] b = new byte[wrappedBytes.remaining()];
                wrappedBytes.get(b, 0, b.length);
                SslHandler.super.encode(SslHandler.this.socketChannel, b);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }

        @Override
        public void onPlainData(ByteBuffer plainBytes) {
            byte[] b = new byte[plainBytes.remaining()];
            plainBytes.get(b, 0, b.length);
            try {
                SslHandler.super.decode(SslHandler.this.socketChannel, b, SslHandler.this.out);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    class sessionClosedListener
    implements ISessionClosedListener {
        sessionClosedListener() {
        }

        @Override
        public void onSessionClosed() {
            logger.info("Handshake failure");
            SslHandler.this.socketChannel.close();
        }
    }

    class handshakeCompletedListener
    implements IHandshakeCompletedListener {
        handshakeCompletedListener() {
        }

        @Override
        public void onComplete() {
            logger.info("Handshake Completed");
            SslHandler.this.socketChannel.setHandShak(true);
        }
    }
}

