/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.pipeline;

import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.channel.UdpChannel;
import com.gettyio.core.pipeline.ChannelHandlerAdapter;
import com.gettyio.core.pipeline.DatagramPacketHandler;
import com.gettyio.core.pipeline.all.ChannelAllBoundHandlerAdapter;
import com.gettyio.core.pipeline.in.ChannelInboundHandlerAdapter;
import com.gettyio.core.pipeline.out.ChannelOutboundHandlerAdapter;
import com.gettyio.core.util.FastCopyOnWriteArrayList;

public class DefaultChannelPipeline {
    FastCopyOnWriteArrayList<ChannelHandlerAdapter> inPipeList;
    FastCopyOnWriteArrayList<ChannelHandlerAdapter> outPipeList;
    SocketChannel socketChannel;

    public DefaultChannelPipeline(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        if (this.inPipeList == null) {
            this.inPipeList = new FastCopyOnWriteArrayList();
        }
        if (this.outPipeList == null) {
            this.outPipeList = new FastCopyOnWriteArrayList();
        }
    }

    public FastCopyOnWriteArrayList<ChannelHandlerAdapter> getInPipeList() {
        return this.inPipeList;
    }

    public FastCopyOnWriteArrayList<ChannelHandlerAdapter> getOutPipeList() {
        return this.outPipeList;
    }

    public ChannelHandlerAdapter inPipeFirst() {
        if (this.inPipeList != null && this.inPipeList.size() > 0) {
            return this.inPipeList.getFirst();
        }
        return null;
    }

    public ChannelHandlerAdapter outPipeFirst() {
        if (this.outPipeList != null && this.outPipeList.size() > 0) {
            return this.outPipeList.getLast();
        }
        return null;
    }

    public ChannelHandlerAdapter nextInPipe(ChannelHandlerAdapter channelHandlerAdapter) {
        int index = this.inPipeList.indexOf(channelHandlerAdapter);
        if (this.inPipeList.size() > ++index) {
            return this.inPipeList.get(index);
        }
        return null;
    }

    public ChannelHandlerAdapter nextOutPipe(ChannelHandlerAdapter channelHandlerAdapter) {
        int index = this.outPipeList.indexOf(channelHandlerAdapter);
        if (--index >= 0) {
            return this.outPipeList.get(index);
        }
        return null;
    }

    public void addLast(ChannelHandlerAdapter channelHandlerAdapter) {
        if (this.socketChannel instanceof UdpChannel && !(channelHandlerAdapter instanceof DatagramPacketHandler)) {
            return;
        }
        if (channelHandlerAdapter instanceof ChannelInboundHandlerAdapter) {
            this.inPipeList.addLast(channelHandlerAdapter);
        } else if (channelHandlerAdapter instanceof ChannelOutboundHandlerAdapter) {
            this.outPipeList.addLast(channelHandlerAdapter);
        } else if (channelHandlerAdapter instanceof ChannelAllBoundHandlerAdapter) {
            this.inPipeList.addLast(channelHandlerAdapter);
            this.outPipeList.addLast(channelHandlerAdapter);
        }
    }

    public void addFirst(ChannelHandlerAdapter channelHandlerAdapter) {
        if (this.socketChannel instanceof UdpChannel && !(channelHandlerAdapter instanceof DatagramPacketHandler)) {
            return;
        }
        if (channelHandlerAdapter instanceof ChannelInboundHandlerAdapter) {
            this.inPipeList.addFirst(channelHandlerAdapter);
        } else if (channelHandlerAdapter instanceof ChannelOutboundHandlerAdapter) {
            this.outPipeList.addFirst(channelHandlerAdapter);
        } else if (channelHandlerAdapter instanceof ChannelAllBoundHandlerAdapter) {
            this.inPipeList.addFirst(channelHandlerAdapter);
            this.outPipeList.addFirst(channelHandlerAdapter);
        }
    }

    public void clean() {
        this.inPipeList.clear();
        this.outPipeList.clear();
    }
}

