/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;

public class FastCopyOnWriteArrayList<T>
implements Iterable<T> {
    final transient ReentrantLock lock = new ReentrantLock();
    private Class<T> type;
    private int currentIndex = 0;
    private volatile transient T[] data;
    private static final int DEFAULT_CAPACITY = 0;

    public FastCopyOnWriteArrayList(Class<T> type) {
        this.data = (Object[])Array.newInstance(type, 0);
        this.type = type;
    }

    public FastCopyOnWriteArrayList() {
        this.data = new Object[0];
    }

    public int size() {
        return this.data.length;
    }

    public int indexOf(T o) {
        if (o == null) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                if (!o.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean add(T obj) {
        return this.add(this.size(), obj);
    }

    public boolean addFirst(T obj) {
        return this.add(0, obj);
    }

    public boolean addLast(T obj) {
        return this.add(this.size(), obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int index, T obj) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int len = this.arrays().length;
            T[] newData = Arrays.copyOf(this.data, len + 1);
            if (index == this.size()) {
                newData[len] = obj;
            } else if (this.checkIndexOut(index)) {
                System.arraycopy(this.data, 0, newData, 0, len);
                System.arraycopy(this.data, index, newData, index + 1, this.size() - index);
                newData[index] = obj;
            }
            this.setArray(newData);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean checkIndexOut(int index) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException("\u6307\u5b9a\u7684\u7d22\u5f15\u8d8a\u754c\uff0c\u96c6\u5408\u5927\u5c0f\u4e3a:" + this.size() + ",\u60a8\u6307\u5b9a\u7684\u7d22\u5f15\u5927\u5c0f\u4e3a:" + index);
        }
        return true;
    }

    public T get(int index) {
        this.checkIndexOut(index);
        return this.data[index];
    }

    public T getFirst() {
        return this.get(0);
    }

    public T getLast() {
        return this.get(this.size() - 1);
    }

    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] newElements = new Object[]{};
            this.setArray(newElements);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(int index) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            T[] elements = this.arrays();
            int len = elements.length;
            T oldValue = this.get(index);
            int numMoved = len - index - 1;
            if (numMoved == 0) {
                this.setArray(Arrays.copyOf(elements, len - 1));
            } else {
                Object[] newElements = new Object[len - 1];
                System.arraycopy(elements, 0, newElements, 0, index);
                System.arraycopy(elements, index + 1, newElements, index, numMoved);
                this.setArray(newElements);
            }
            T t = oldValue;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean remove(T obj) {
        for (int i = 0; i < this.size(); ++i) {
            if (!obj.equals(this.data[i])) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T set(int index, T obj) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.checkIndexOut(index);
            T[] elements = this.arrays();
            T oldValue = this.get(index);
            if (oldValue != obj) {
                int len = elements.length;
                T[] newElements = Arrays.copyOf(elements, len);
                newElements[index] = obj;
                this.setArray(newElements);
            } else {
                this.setArray(elements);
            }
            T t = oldValue;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean contain(T obj) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!obj.equals(this.data[i])) continue;
            return true;
        }
        return false;
    }

    public T[] arrays() {
        return this.data;
    }

    public void setArray(T[] arr) {
        this.data = arr;
    }

    public T[] toArray() {
        T[] elements = this.arrays();
        return Arrays.copyOf(elements, elements.length);
    }

    public T round() {
        this.currentIndex = (this.currentIndex + 1) % this.size();
        return this.get(this.currentIndex);
    }

    @Override
    public Iterator<T> iterator() {
        class Iter
        implements Iterator<T> {
            Iter() {
            }

            @Override
            public boolean hasNext() {
                return FastCopyOnWriteArrayList.this.currentIndex < FastCopyOnWriteArrayList.this.size();
            }

            @Override
            public T next() {
                return FastCopyOnWriteArrayList.this.data[FastCopyOnWriteArrayList.this.currentIndex++];
            }

            @Override
            public void remove() {
            }
        }
        return new Iter();
    }
}

