/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.config.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.cp.config.WxCpCorpGroupConfigStorage;

public class WxCpCorpGroupDefaultConfigImpl
implements WxCpCorpGroupConfigStorage,
Serializable {
    private static final long serialVersionUID = -8392908346536154435L;
    private final transient Map<String, Lock> corpAccessTokenLocker = new ConcurrentHashMap<String, Lock>();
    private final Map<String, String> corpAccessTokenMap = new HashMap<String, String>();
    private final Map<String, Long> corpAccessTokenExpireTimeMap = new HashMap<String, Long>();
    private volatile String httpProxyHost;
    private volatile int httpProxyPort;
    private volatile String httpProxyUsername;
    private volatile String httpProxyPassword;
    private volatile ApacheHttpClientBuilder apacheHttpClientBuilder;
    private volatile String baseApiUrl;
    private volatile String corpId;
    private volatile Integer agentId;

    @Override
    public void setBaseApiUrl(String baseUrl) {
        this.baseApiUrl = baseUrl;
    }

    @Override
    public String getApiUrl(String path) {
        if (this.baseApiUrl == null) {
            this.baseApiUrl = "https://qyapi.weixin.qq.com";
        }
        return this.baseApiUrl + path;
    }

    @Override
    public String getCorpId() {
        return this.corpId;
    }

    @Override
    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    @Override
    public Integer getAgentId() {
        return this.agentId;
    }

    @Override
    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    @Override
    public void updateCorpAccessToken(String corpId, Integer agentId, String corpAccessToken, int expiresInSeconds) {
        String key = this.generateAccessTokenKey(corpId, agentId);
        this.corpAccessTokenMap.put(key, corpAccessToken);
        this.corpAccessTokenExpireTimeMap.put(key, System.currentTimeMillis() + (long)(expiresInSeconds - 200) * 1000L);
    }

    @Override
    public String getCorpAccessToken(String corpId, Integer agentId) {
        return this.corpAccessTokenMap.get(this.generateAccessTokenKey(corpId, agentId));
    }

    @Override
    public WxAccessToken getCorpAccessTokenEntity(String corpId, Integer agentId) {
        String key = this.generateAccessTokenKey(corpId, agentId);
        String accessToken = this.corpAccessTokenMap.getOrDefault(key, "");
        Long expire = this.corpAccessTokenExpireTimeMap.getOrDefault(key, 0L);
        WxAccessToken accessTokenEntity = new WxAccessToken();
        accessTokenEntity.setAccessToken(accessToken);
        accessTokenEntity.setExpiresIn((int)((expire - System.currentTimeMillis()) / 1000L + 200L));
        return accessTokenEntity;
    }

    @Override
    public boolean isCorpAccessTokenExpired(String corpId, Integer agentId) {
        String key = this.generateAccessTokenKey(corpId, agentId);
        return this.corpAccessTokenExpireTimeMap.get(key) == null || System.currentTimeMillis() > this.corpAccessTokenExpireTimeMap.get(key);
    }

    @Override
    public void expireCorpAccessToken(String corpId, Integer agentId) {
        String key = this.generateAccessTokenKey(corpId, agentId);
        this.corpAccessTokenMap.remove(key);
        this.corpAccessTokenExpireTimeMap.remove(key);
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    @Override
    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    @Override
    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    @Override
    public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
        return this.apacheHttpClientBuilder;
    }

    public void setApacheHttpClientBuilder(ApacheHttpClientBuilder apacheHttpClientBuilder) {
        this.apacheHttpClientBuilder = apacheHttpClientBuilder;
    }

    @Override
    public boolean autoRefreshToken() {
        return true;
    }

    @Override
    public Lock getCorpAccessTokenLock(String corpId, Integer agentId) {
        return this.corpAccessTokenLocker.computeIfAbsent(this.generateAccessTokenKey(corpId, agentId), key -> new ReentrantLock());
    }

    private String generateAccessTokenKey(String corpId, Integer agentId) {
        return String.join((CharSequence)":", this.corpId, String.valueOf(this.agentId), corpId, String.valueOf(agentId));
    }
}

