/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.bean.WxCpChat;

public class WxCpChatGsonAdapter
implements JsonSerializer<WxCpChat>,
JsonDeserializer<WxCpChat> {
    public static final String FIELD_CHAT_ID = "chatid";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_OWNER = "owner";
    public static final String FIELD_USER_LIST = "userlist";

    public JsonElement serialize(WxCpChat chat, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        this.addPropertyIfNotNull(json, FIELD_CHAT_ID, chat.getId());
        this.addPropertyIfNotNull(json, FIELD_NAME, chat.getName());
        this.addPropertyIfNotNull(json, FIELD_OWNER, chat.getOwner());
        if (chat.getUsers() != null && !chat.getUsers().isEmpty()) {
            JsonArray users = new JsonArray();
            chat.getUsers().forEach(arg_0 -> ((JsonArray)users).add(arg_0));
            json.add(FIELD_USER_LIST, (JsonElement)users);
        }
        return json;
    }

    private void addPropertyIfNotNull(JsonObject json, String key, String value) {
        if (value != null) {
            json.addProperty(key, value);
        }
    }

    public WxCpChat deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject chatJson = json.getAsJsonObject();
        WxCpChat chat = new WxCpChat();
        chat.setId(GsonHelper.getAsString((JsonElement)chatJson.get(FIELD_CHAT_ID)));
        chat.setName(GsonHelper.getAsString((JsonElement)chatJson.get(FIELD_NAME)));
        chat.setOwner(GsonHelper.getAsString((JsonElement)chatJson.get(FIELD_OWNER)));
        JsonArray usersJson = chatJson.getAsJsonArray(FIELD_USER_LIST);
        if (usersJson != null && !usersJson.isEmpty()) {
            ArrayList<String> users = new ArrayList<String>(usersJson.size());
            usersJson.forEach(e -> users.add(e.getAsString()));
            chat.setUsers(users);
        }
        return chat;
    }
}

