/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaIntracityService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.intractiy.PayMode;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaAddOrderRequest;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaAddOrderResponse;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaCancelOrderResponse;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaGetPayModeResponse;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaOrder;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaPreAddOrderRequest;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaPreAddOrderResponse;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaQueryFlowRequest;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaStore;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaStoreBalance;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaStoreChargeRequest;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaStoreFlowResponse;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaStoreRefundRequest;
import cn.binarywang.wx.miniapp.bean.intractiy.WxMaTransCity;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaIntracityServiceImpl
implements WxMaIntracityService {
    private static final Logger log = LoggerFactory.getLogger(WxMaIntracityServiceImpl.class);
    private final WxMaService wxMaService;
    private static final Logger logger = LoggerFactory.getLogger(WxMaIntracityServiceImpl.class);
    private final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    private void checkStringResponse(String response) throws WxErrorException {
        JsonObject respObj = GsonParser.parse((String)response);
        if (respObj.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
    }

    @Override
    public void apply() throws WxErrorException {
        String response = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/intracity/apply", "{}");
        this.checkStringResponse(response);
    }

    @Override
    public String createStore(WxMaStore store) throws WxErrorException {
        if (store.getOutStoreId() == null) {
            throw new IllegalArgumentException("\u521b\u5efa\u95e8\u5e97\u65f6outStoreId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (store.getWxStoreId() != null) {
            throw new IllegalArgumentException("\u521b\u5efa\u95e8\u5e97\u65f6wxStoreId\u53ea\u80fd\u662fnull");
        }
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/createstore", store);
        Map map = (Map)this.gson.fromJson(response, Map.class);
        return (String)map.get("wx_store_id");
    }

    @Override
    public void updateStore(WxMaStore store) throws WxErrorException {
        if (store.getWxStoreId() == null && store.getOutStoreId() == null) {
            throw new IllegalArgumentException("\u66f4\u65b0\u95e8\u5e97\u65f6wxStoreId \u6216 outStoreId \u81f3\u5c11\u8981\u6709\u4e00\u4e2a\u4e0d\u4e3anull");
        }
        JsonObject request = new JsonObject();
        HashMap<String, String> keys = new HashMap<String, String>();
        if (store.getWxStoreId() != null) {
            keys.put("wx_store_id", store.getWxStoreId());
        } else {
            keys.put("out_store_id", store.getOutStoreId());
        }
        request.add("keys", this.gson.toJsonTree(keys));
        HashMap<String, Object> updateContent = new HashMap<String, Object>();
        if (store.getStoreName() != null) {
            updateContent.put("store_name", store.getStoreName());
        }
        if (store.getOrderPattern() == 1 || store.getOrderPattern() == 2) {
            updateContent.put("order_pattern", store.getOrderPattern());
        }
        if (store.getServiceTransPrefer() != null) {
            updateContent.put("service_trans_prefer", store.getServiceTransPrefer());
        }
        if (store.getAddressInfo() != null) {
            updateContent.put("address_info", store.getAddressInfo());
        }
        request.add("content", this.gson.toJsonTree(updateContent));
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/updatestore", request);
        this.checkStringResponse(response);
    }

    @Override
    public List<WxMaStore> listAllStores() throws WxErrorException {
        return this.queryStore(null, null);
    }

    @Override
    public WxMaStore queryStoreByWxStoreId(String wxStoreId) throws WxErrorException {
        List<WxMaStore> list = this.queryStore(wxStoreId, null);
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public List<WxMaStore> queryStoreByOutStoreId(String outStoreId) throws WxErrorException {
        return this.queryStore(null, outStoreId);
    }

    private List<WxMaStore> queryStore(String wxStoreId, String outStoreId) throws WxErrorException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (wxStoreId != null) {
            map.put("wx_store_id", wxStoreId);
        } else if (outStoreId != null) {
            map.put("out_store_id", outStoreId);
        }
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/querystore", map);
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        Type listType = new TypeToken<List<WxMaStore>>(){}.getType();
        return (List)this.gson.fromJson((JsonElement)jsonObject.getAsJsonArray("store_list"), listType);
    }

    @Override
    public String storeCharge(WxMaStoreChargeRequest request) throws WxErrorException {
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/storecharge", request);
        Map map = (Map)this.gson.fromJson(response, Map.class);
        return (String)map.get("payurl");
    }

    @Override
    public int storeRefund(WxMaStoreRefundRequest request) throws WxErrorException {
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/storerefund", request);
        Map map = (Map)this.gson.fromJson(response, Map.class);
        return ((Number)map.get("refund_amount")).intValue();
    }

    @Override
    public WxMaStoreFlowResponse<? extends WxMaStoreFlowResponse.BasicFlowRecord> queryFlow(WxMaQueryFlowRequest request) throws WxErrorException {
        if (request == null || request.getWxStoreId() == null) {
            throw new IllegalArgumentException("\u67e5\u8be2\u8bf7\u6c42 wxStoreId \u4e0d\u53ef\u4e3a\u7a7a");
        }
        WxMaStoreFlowResponse<? extends WxMaStoreFlowResponse.BasicFlowRecord> inst = this.getFlowInstanceByType(request.getFlowType());
        if (inst == null) {
            throw new IllegalArgumentException("\u67e5\u8be2\u8bf7\u6c42 flowType \u4e0d\u6b63\u786e\uff0c\u53ea\u80fd\u662f1\u30012\u30013\u4e4b\u4e00");
        }
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/queryflow", request);
        WxMaStoreFlowResponse flowResponse = (WxMaStoreFlowResponse)this.gson.fromJson(response, inst.getClass());
        logger.debug("queryFlow: {}", (Object)flowResponse);
        return flowResponse;
    }

    private WxMaStoreFlowResponse<? extends WxMaStoreFlowResponse.BasicFlowRecord> getFlowInstanceByType(int flowType) {
        WxMaStoreFlowResponse inst;
        if (flowType == 1) {
            inst = new WxMaStoreFlowResponse();
        } else if (flowType == 2) {
            inst = new WxMaStoreFlowResponse();
        } else if (flowType == 3) {
            inst = new WxMaStoreFlowResponse();
        } else {
            return null;
        }
        return inst;
    }

    @Override
    public WxMaStoreBalance balanceQuery(String wxStoreId, String serviceTransId, PayMode payMode) throws WxErrorException {
        if (wxStoreId == null && (payMode == null || payMode == PayMode.STORE)) {
            throw new IllegalArgumentException("payMode\u662fPAY_MODE_STORE\u6216null\u65f6\uff0c\u5fc5\u987b\u4f20\u9012wxStoreId");
        }
        HashMap<String, Object> request = new HashMap<String, Object>();
        if (wxStoreId != null) {
            request.put("wx_store_id", wxStoreId);
        }
        if (serviceTransId != null) {
            request.put("service_trans_id", serviceTransId);
        }
        if (payMode != null) {
            request.put("pay_mode", (Object)payMode);
        }
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/balancequery", request);
        WxMaStoreBalance balance = (WxMaStoreBalance)this.gson.fromJson(response, WxMaStoreBalance.class);
        logger.debug("balance: {}", (Object)balance);
        return balance;
    }

    @Override
    public void setPayMode(PayMode payMode) throws WxErrorException {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("pay_mode", (Object)payMode);
        request.put("appid", this.wxMaService.getWxMaConfig().getAppid());
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/setpaymode", request);
        this.checkStringResponse(response);
    }

    @Override
    public WxMaGetPayModeResponse getPayMode() throws WxErrorException {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("appid", this.wxMaService.getWxMaConfig().getAppid());
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/getpaymode", request);
        return (WxMaGetPayModeResponse)this.gson.fromJson(response, WxMaGetPayModeResponse.class);
    }

    @Override
    public WxMaPreAddOrderResponse preAddOrder(WxMaPreAddOrderRequest request) throws WxErrorException {
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/preaddorder", request);
        return (WxMaPreAddOrderResponse)this.gson.fromJson(response, WxMaPreAddOrderResponse.class);
    }

    @Override
    public WxMaAddOrderResponse addOrder(WxMaAddOrderRequest request) throws WxErrorException {
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/addorder", request);
        return (WxMaAddOrderResponse)this.gson.fromJson(response, WxMaAddOrderResponse.class);
    }

    @Override
    public WxMaOrder queryOrderByWxOrderId(String wxOrderId) throws WxErrorException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("wx_order_id", wxOrderId);
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/queryorder", map);
        return (WxMaOrder)this.gson.fromJson(response, WxMaOrder.class);
    }

    @Override
    public WxMaOrder queryOrderByStoreOrderId(String wxStoreId, String storeOrderId) throws WxErrorException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("wx_store_id", wxStoreId);
        map.put("store_order_id", storeOrderId);
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/queryorder", map);
        return (WxMaOrder)this.gson.fromJson(response, WxMaOrder.class);
    }

    @Override
    public WxMaCancelOrderResponse cancelOrderByWxOrderId(String wxOrderId, int cancelReasonId, String cancelReason) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("wx_order_id", wxOrderId);
        map.put("cancel_reason_id", cancelReasonId);
        if (cancelReason != null) {
            map.put("cancel_reason", cancelReason);
        }
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/cancelorder", map);
        return (WxMaCancelOrderResponse)this.gson.fromJson(response, WxMaCancelOrderResponse.class);
    }

    @Override
    public WxMaCancelOrderResponse cancelOrderByStoreOrderId(String wxStoreId, String storeOrderId, int cancelReasonId, String cancelReason) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("wx_store_id", wxStoreId);
        map.put("store_order_id", storeOrderId);
        map.put("cancel_reason_id", cancelReasonId);
        if (cancelReason != null) {
            map.put("cancel_reason", cancelReason);
        }
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/cancelorder", map);
        return (WxMaCancelOrderResponse)this.gson.fromJson(response, WxMaCancelOrderResponse.class);
    }

    @Override
    public List<WxMaTransCity> getCity(String serviceTransId) throws WxErrorException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (serviceTransId != null) {
            map.put("service_trans_id", serviceTransId);
        }
        String response = this.wxMaService.postWithSignature("https://api.weixin.qq.com/cgi-bin/express/intracity/getcity", map);
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(response, JsonObject.class);
        Type listType = new TypeToken<List<WxMaTransCity>>(){}.getType();
        return (List)this.gson.fromJson((JsonElement)jsonObject.getAsJsonArray("support_list"), listType);
    }

    public WxMaIntracityServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

