/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.requestexecuter.material;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.hc.Utf8ResponseHandler;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.bean.material.WxMpMaterial;
import me.chanjar.weixin.mp.bean.material.WxMpMaterialUploadResult;
import me.chanjar.weixin.mp.util.requestexecuter.material.MaterialUploadRequestExecutor;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;

public class MaterialUploadHttpComponentsRequestExecutor
extends MaterialUploadRequestExecutor<CloseableHttpClient, HttpHost> {
    public MaterialUploadHttpComponentsRequestExecutor(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        super(requestHttp);
    }

    public WxMpMaterialUploadResult execute(String uri, WxMpMaterial material, WxType wxType) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig response = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(response);
        }
        if (material == null) {
            throw new WxErrorException("\u975e\u6cd5\u8bf7\u6c42\uff0cmaterial\u53c2\u6570\u4e3a\u7a7a");
        }
        File file = material.getFile();
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addBinaryBody("media", file).setMode(HttpMultipartMode.EXTENDED);
        Map<String, String> form = material.getForm();
        if (material.getForm() != null) {
            multipartEntityBuilder.addPart("description", (ContentBody)new StringBody(WxGsonBuilder.create().toJson(form), ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8)));
        }
        httpPost.setEntity(multipartEntityBuilder.build());
        String responseContent = (String)((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((ClassicHttpRequest)httpPost, Utf8ResponseHandler.INSTANCE);
        WxError error = WxError.fromJson((String)responseContent, (WxType)WxType.MP);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return WxMpMaterialUploadResult.fromJson(responseContent);
    }
}

