/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.adaptors.jdbc;

import com.github.houbb.log.integration.adaptors.jdbc.BaseJdbcLogger;
import com.github.houbb.log.integration.adaptors.jdbc.PreparedStatementLogger;
import com.github.houbb.log.integration.adaptors.jdbc.StatementLogger;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.util.ExceptionUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public final class ConnectionLogger
extends BaseJdbcLogger
implements InvocationHandler {
    private Connection connection;

    private ConnectionLogger(Connection conn, Log statementLog, int queryStack) {
        super(statementLog, queryStack);
        this.connection = conn;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, params);
            }
            if ("prepareStatement".equals(method.getName())) {
                if (this.isDebugEnabled()) {
                    this.debug(" Preparing: " + this.removeBreakingWhitespace((String)params[0]), true);
                }
                PreparedStatement stmt = (PreparedStatement)method.invoke((Object)this.connection, params);
                stmt = PreparedStatementLogger.newInstance(stmt, this.statementLog, this.queryStack);
                return stmt;
            }
            if ("prepareCall".equals(method.getName())) {
                if (this.isDebugEnabled()) {
                    this.debug(" Preparing: " + this.removeBreakingWhitespace((String)params[0]), true);
                }
                PreparedStatement stmt = (PreparedStatement)method.invoke((Object)this.connection, params);
                stmt = PreparedStatementLogger.newInstance(stmt, this.statementLog, this.queryStack);
                return stmt;
            }
            if ("createStatement".equals(method.getName())) {
                Statement stmt = (Statement)method.invoke((Object)this.connection, params);
                stmt = StatementLogger.newInstance(stmt, this.statementLog, this.queryStack);
                return stmt;
            }
            return method.invoke((Object)this.connection, params);
        }
        catch (Throwable t) {
            throw ExceptionUtil.unwrapThrowable(t);
        }
    }

    public static Connection newInstance(Connection conn, Log statementLog, int queryStack) {
        ConnectionLogger handler = new ConnectionLogger(conn, statementLog, queryStack);
        ClassLoader cl = Connection.class.getClassLoader();
        return (Connection)Proxy.newProxyInstance(cl, new Class[]{Connection.class}, (InvocationHandler)handler);
    }

    public Connection getConnection() {
        return this.connection;
    }
}

