/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.cloud.dashboard.config;

import com.github.vanroy.cloud.dashboard.config.HttpClientProperties;
import com.github.vanroy.cloud.dashboard.repository.ApplicationRepository;
import com.github.vanroy.cloud.dashboard.repository.aws.BeanstalkRepository;
import com.github.vanroy.cloud.dashboard.repository.eureka.LocaleEurekaRepository;
import com.github.vanroy.cloud.dashboard.repository.eureka.RemoteEurekaRepository;
import com.github.vanroy.cloud.dashboard.stream.CircuitBreakerStreamServlet;
import com.netflix.discovery.EurekaClient;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import javax.servlet.Servlet;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@AutoConfigureAfter(name={"org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration"})
@ComponentScan(value={"com.github.vanroy.cloud.dashboard"})
public class CloudDashboardConfig
extends WebMvcConfigurerAdapter {
    @Autowired
    private HttpClientProperties httpClientProperties;

    @Bean(name={"applicationRepository"})
    @ConditionalOnClass(name={"com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient"})
    @ConditionalOnMissingBean(value={ApplicationRepository.class})
    public ApplicationRepository beanstalkRepository() {
        return new BeanstalkRepository();
    }

    @Bean
    @Autowired
    public ServletRegistrationBean circuitBreakerStreamServlet(ApplicationRepository repository) {
        return new ServletRegistrationBean((Servlet)new CircuitBreakerStreamServlet(this.HttpClient(), repository), new String[]{"/circuitBreaker.stream"});
    }

    @Bean
    public HttpClient HttpClient() {
        HttpClientBuilder builder = HttpClients.custom().setMaxConnTotal(this.httpClientProperties.getMaxConnection().intValue()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.httpClientProperties.getSocketTimeout().intValue()).build()).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(this.httpClientProperties.getSocketTimeout().intValue()).setConnectTimeout(this.httpClientProperties.getConnectTimeout().intValue()).setConnectionRequestTimeout(this.httpClientProperties.getRequestTimeout().intValue()).build());
        if (this.httpClientProperties.getUsername() != null && this.httpClientProperties.getPassword() != null) {
            builder.setDefaultHeaders(Collections.singletonList(CloudDashboardConfig.createBasicAuthHeader(this.httpClientProperties.getUsername(), this.httpClientProperties.getPassword())));
        }
        return builder.build();
    }

    private static Header createBasicAuthHeader(String username, String password) {
        String basicAuth = new String(Base64.getEncoder().encode((String.valueOf(username) + ":" + password).getBytes()));
        return new BasicHeader("Authorization", "Basic " + basicAuth);
    }

    @ConditionalOnClass(name={"com.netflix.eureka.registry.PeerAwareInstanceRegistry"})
    @ConditionalOnMissingBean(value={ApplicationRepository.class})
    public static class Eureka {
        @Bean(name={"applicationRepository"})
        public ApplicationRepository eurekaRepository(Optional<PeerAwareInstanceRegistry> peerAwareInstanceRegistry, Optional<EurekaClient> eurekaClient) {
            if (peerAwareInstanceRegistry.isPresent()) {
                return new LocaleEurekaRepository(peerAwareInstanceRegistry.get());
            }
            if (eurekaClient.isPresent()) {
                return new RemoteEurekaRepository(eurekaClient.get());
            }
            return null;
        }
    }
}

