/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.cloud.dashboard.controller;

import com.github.vanroy.cloud.dashboard.model.Application;
import com.github.vanroy.cloud.dashboard.model.Instance;
import com.github.vanroy.cloud.dashboard.repository.ApplicationRepository;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ApplicationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationController.class);
    @Autowired
    private ApplicationRepository repository;
    @Autowired
    private HttpClient httpClient;

    @RequestMapping(value={"/api/applications"}, method={RequestMethod.GET}, produces={"application/json"})
    public Collection<Application> applications(@RequestParam(value="name", required=false) String name) {
        LOGGER.debug("Deliver applications with name= {}", (Object)name);
        if (name == null || name.isEmpty()) {
            return this.repository.findAll();
        }
        return Lists.newArrayList((Object[])new Application[]{this.repository.findByName(name)});
    }

    @RequestMapping(value={"/api/instance/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<Instance> instance(@PathVariable String id) {
        LOGGER.debug("Deliver application with ID '{}'", (Object)id);
        Instance instance = this.repository.findInstance(id);
        if (instance != null) {
            return new ResponseEntity((Object)instance, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/api/instance/{id}/{method}"}, method={RequestMethod.GET})
    public ResponseEntity<String> proxy(@PathVariable String id, @PathVariable String method, ServletRequest request) {
        String managementUrl = this.repository.getInstanceManagementUrl(id);
        if (managementUrl == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        try {
            URIBuilder builder = new URIBuilder(String.valueOf(managementUrl) + "/" + method);
            request.getParameterMap().forEach((key, value) -> {
                URIBuilder uRIBuilder2 = builder.setParameter(key, value[0]);
            });
            HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(builder.build()));
            return ResponseEntity.status((int)response.getStatusLine().getStatusCode()).body((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (Exception e) {
            LOGGER.warn("Cannot proxy metrics to instance", (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/api/instance/{id}/{method}/{param:.*}"}, method={RequestMethod.GET})
    public ResponseEntity<String> proxy(@PathVariable String id, @PathVariable String method, @PathVariable String param, ServletRequest request) {
        String managementUrl = this.repository.getInstanceManagementUrl(id);
        if (managementUrl == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        try {
            URIBuilder builder = new URIBuilder(String.valueOf(managementUrl) + "/" + method + "/" + param);
            request.getParameterMap().forEach((key, value) -> {
                URIBuilder uRIBuilder2 = builder.setParameter(key, value[0]);
            });
            HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(builder.build()));
            return ResponseEntity.status((int)response.getStatusLine().getStatusCode()).body((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (Exception e) {
            LOGGER.warn("Cannot proxy metrics to instance", (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/api/instance/{id}/{method}"}, method={RequestMethod.POST})
    public ResponseEntity<String> proxyPost(@PathVariable String id, @PathVariable String method, @RequestBody(required=false) String body, HttpServletRequest request) {
        String managementUrl = this.repository.getInstanceManagementUrl(id);
        if (managementUrl == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        try {
            URIBuilder builder = new URIBuilder(String.valueOf(managementUrl) + "/" + method);
            request.getParameterMap().forEach((key, value) -> {
                URIBuilder uRIBuilder2 = builder.setParameter(key, value[0]);
            });
            HttpPost post = new HttpPost(builder.build());
            if (body != null) {
                post.setEntity((HttpEntity)new StringEntity(body));
            }
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            return ResponseEntity.status((int)response.getStatusLine().getStatusCode()).body((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (Exception e) {
            LOGGER.warn("Cannot proxy metrics to instance", (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/api/instance/{id}/{method}/{param:.*}"}, method={RequestMethod.POST})
    public ResponseEntity<String> proxyPost(@PathVariable String id, @PathVariable String method, @RequestBody(required=false) String body, @PathVariable String param, ServletRequest request) {
        String managementUrl = this.repository.getInstanceManagementUrl(id);
        if (managementUrl == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        try {
            URIBuilder builder = new URIBuilder(String.valueOf(managementUrl) + "/" + method + "/" + param);
            request.getParameterMap().forEach((key, value) -> {
                URIBuilder uRIBuilder2 = builder.setParameter(key, value[0]);
            });
            HttpPost post = new HttpPost(builder.build());
            if (body != null) {
                post.setEntity((HttpEntity)new StringEntity(body));
            }
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            return ResponseEntity.status((int)response.getStatusLine().getStatusCode()).body((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (Exception e) {
            LOGGER.warn("Cannot proxy metrics to instance", (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

