/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.cloud.dashboard.repository.eureka;

import com.github.vanroy.cloud.dashboard.model.Instance;
import com.github.vanroy.cloud.dashboard.repository.ApplicationRepository;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;

public abstract class EurekaRepository
implements ApplicationRepository {
    @Value(value="${spring.cloud.dashboard.turbine.url:http://localhost:${server.port}/turbine.stream}")
    private String turbineUrl;
    protected Function<Application, com.github.vanroy.cloud.dashboard.model.Application> TO_APPLICATION = new Function<Application, com.github.vanroy.cloud.dashboard.model.Application>(){

        @Override
        public com.github.vanroy.cloud.dashboard.model.Application apply(Application app) {
            if (app == null) {
                return null;
            }
            return new com.github.vanroy.cloud.dashboard.model.Application(app.getName(), app.getInstances().stream().map(EurekaRepository.this.TO_INSTANCE).sorted((o1, o2) -> o1.getName().compareTo(o2.getName())).collect(Collectors.toList()));
        }
    };
    protected Function<InstanceInfo, Instance> TO_INSTANCE = instance -> {
        if (instance == null) {
            return null;
        }
        return new Instance(instance.getHomePageUrl(), instance.getId(), String.valueOf(instance.getAppName()) + "_" + instance.getId().replaceAll("\\.", "_"), instance.getStatus().toString());
    };

    @Override
    public abstract com.github.vanroy.cloud.dashboard.model.Application findByName(String var1);

    @Override
    public String getApplicationCircuitBreakerStreamUrl(String name) {
        if (this.findByName(name) == null) {
            return null;
        }
        return String.valueOf(this.turbineUrl) + "?cluster=" + name;
    }

    @Override
    public String getInstanceCircuitBreakerStreamUrl(String instanceId) {
        String url = this.getInstanceManagementUrl(instanceId);
        if (url == null) {
            return null;
        }
        return String.valueOf(url) + "/hystrix.stream";
    }

    @Override
    public Instance findInstance(String id) {
        return this.TO_INSTANCE.apply(this.findInstanceInfo(id));
    }

    @Override
    public String getInstanceManagementUrl(String id) {
        InstanceInfo info = this.findInstanceInfo(id);
        if (info == null) {
            return null;
        }
        String url = info.getHomePageUrl();
        if (info.getMetadata().containsKey("managementPath")) {
            url = String.valueOf(url) + (String)info.getMetadata().get("managementPath");
        }
        return url;
    }

    protected abstract InstanceInfo findInstanceInfo(String var1);
}

