/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.cloud.dashboard.repository.eureka;

import com.github.vanroy.cloud.dashboard.model.Application;
import com.github.vanroy.cloud.dashboard.repository.eureka.EurekaRepository;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import java.util.Collection;
import java.util.stream.Collectors;

public class RemoteEurekaRepository
extends EurekaRepository {
    private final EurekaClient eurekaClient;

    public RemoteEurekaRepository(EurekaClient eurekaClient) {
        this.eurekaClient = eurekaClient;
    }

    @Override
    public Collection<Application> findAll() {
        return this.eurekaClient.getApplications().getRegisteredApplications().stream().map(this.TO_APPLICATION).collect(Collectors.toList());
    }

    @Override
    public Application findByName(String name) {
        return (Application)this.TO_APPLICATION.apply(this.eurekaClient.getApplications().getRegisteredApplications(name));
    }

    @Override
    protected InstanceInfo findInstanceInfo(String id) {
        String[] instanceIds = id.split("_", 2);
        return this.eurekaClient.getApplication(instanceIds[0]).getByInstanceId(instanceIds[1].replaceAll("_", "."));
    }
}

