/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.cloud.dashboard.stream;

import com.github.vanroy.cloud.dashboard.repository.ApplicationRepository;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreakerStreamServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerStreamServlet.class);
    private final HttpClient httpClient;
    private final ApplicationRepository repository;

    public CircuitBreakerStreamServlet(HttpClient httpClient, ApplicationRepository repository) {
        this.httpClient = httpClient;
        this.repository = repository;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block34: {
            InputStream is;
            Object httpRequest;
            block33: {
                String proxyUrl;
                String appName = request.getParameter("appName");
                String instanceId = request.getParameter("instanceId");
                if (appName == null && instanceId == null) {
                    response.setStatus(500);
                    response.getWriter().println("Please use appName or instanceId to select data to stream");
                    return;
                }
                if (appName != null) {
                    proxyUrl = this.repository.getApplicationCircuitBreakerStreamUrl(appName);
                    if (proxyUrl == null) {
                        response.setStatus(500);
                        response.getWriter().println("Application cluster circuit breaker not found");
                        return;
                    }
                } else {
                    proxyUrl = this.repository.getInstanceCircuitBreakerStreamUrl(instanceId);
                    if (proxyUrl == null) {
                        response.setStatus(500);
                        response.getWriter().println("Instance circuit breaker not found");
                        return;
                    }
                }
                httpRequest = null;
                is = null;
                logger.info("\n\nProxy opening connection to: " + proxyUrl + "\n\n");
                try {
                    try {
                        httpRequest = "HEAD".equalsIgnoreCase(request.getMethod()) ? new HttpHead(proxyUrl) : new HttpGet(proxyUrl);
                        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
                        int statusCode = httpResponse.getStatusLine().getStatusCode();
                        if (statusCode == 200) {
                            int b;
                            if (httpResponse.getEntity() == null) break block33;
                            is = httpResponse.getEntity().getContent();
                            Header[] headerArray = httpResponse.getAllHeaders();
                            int n = headerArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Header header = headerArray[n2];
                                response.addHeader(header.getName(), header.getValue());
                                ++n2;
                            }
                            ServletOutputStream os = response.getOutputStream();
                            while ((b = is.read()) != -1) {
                                try {
                                    os.write(b);
                                    if (b != 10) continue;
                                    os.flush();
                                }
                                catch (Exception e) {
                                    if (e.getClass().getSimpleName().equalsIgnoreCase("ClientAbortException")) {
                                        logger.debug("Connection closed by client. Will stop proxying ...");
                                        break block33;
                                    }
                                    throw new RuntimeException(e);
                                }
                            }
                            break block33;
                        }
                        response.setStatus(statusCode);
                    }
                    catch (Exception e) {
                        logger.error("Error proxying request: " + proxyUrl, (Throwable)e);
                        response.setStatus(500);
                        if (httpRequest != null) {
                            try {
                                httpRequest.abort();
                            }
                            catch (Exception e2) {
                                logger.error("failed aborting proxy connection.", (Throwable)e2);
                            }
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    if (httpRequest != null) {
                        try {
                            httpRequest.abort();
                        }
                        catch (Exception e) {
                            logger.error("failed aborting proxy connection.", (Throwable)e);
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
            }
            if (httpRequest != null) {
                try {
                    httpRequest.abort();
                }
                catch (Exception e) {
                    logger.error("failed aborting proxy connection.", (Throwable)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

