/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.marketingbankpackages;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.PrivacyEncryptor;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.FileRequestBody;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.core.util.ShaUtil;
import com.wechat.pay.java.service.marketingbankpackages.MarketingBankPackagesService;
import com.wechat.pay.java.service.marketingbankpackages.model.FileMeta;
import com.wechat.pay.java.service.marketingbankpackages.model.ListTaskRequest;
import com.wechat.pay.java.service.marketingbankpackages.model.ListTaskResponse;
import com.wechat.pay.java.service.marketingbankpackages.model.Task;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

public class MarketingBankPackagesServiceExtension {
    private final MarketingBankPackagesService packagesService;
    private final HttpClient httpClient;
    private final PrivacyEncryptor encryptor;

    private MarketingBankPackagesServiceExtension(HttpClient httpClient, HostName hostName, PrivacyEncryptor encryptor) {
        MarketingBankPackagesService.Builder builder = new MarketingBankPackagesService.Builder();
        builder.httpClient(httpClient);
        if (hostName != null) {
            builder.hostName(hostName);
        }
        this.encryptor = Objects.requireNonNull(encryptor);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.packagesService = builder.build();
    }

    public ListTaskResponse listTask(ListTaskRequest request) {
        return this.packagesService.listTask(request);
    }

    public Task uploadPackageByFile(String packageId, String bankType, String filePath) throws IllegalArgumentException {
        File file = new File(filePath);
        ArrayList<String> fileContentList = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                fileContentList.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Upload file, failed to open filePath:" + filePath);
        }
        return this.uploadPackage(packageId, bankType, file.getName(), fileContentList);
    }

    public Task uploadPackage(String packageId, String bankType, String fileName, ArrayList<String> fileContentList) {
        if (fileContentList.size() > 5500) {
            throw new IllegalArgumentException("Number of lines should not bigger than 5500. fileContentList.size: " + String.valueOf(fileContentList.size()));
        }
        String uploadPath = "https://api.mch.weixin.qq.com/v3/marketing/bank/packages/" + UrlEncoder.urlEncode((String)packageId) + "/tasks";
        StringBuilder sb = new StringBuilder();
        for (String each : fileContentList) {
            sb.append(this.encryptor.encrypt(each)).append("\n");
        }
        String encryptedFileContent = sb.toString();
        byte[] fileBytes = encryptedFileContent.getBytes();
        String fileSha256 = ShaUtil.getSha256HexString((byte[])fileBytes);
        FileMeta fileMeta = new FileMeta();
        fileMeta.setFilename(fileName);
        fileMeta.setSha256(fileSha256);
        fileMeta.setBankType(bankType);
        return this.uploadFile(uploadPath, GsonUtil.toJson((Object)fileMeta), fileName, fileBytes);
    }

    private Task uploadFile(String uploadPath, String meta, String fileName, byte[] fileBytes) {
        HttpRequest request = new HttpRequest.Builder().addHeader("Accept", " */*").addHeader("Wechatpay-Serial", this.encryptor.getWechatpaySerial()).addHeader("Content-Type", MediaType.MULTIPART_FORM_DATA.getValue()).httpMethod(HttpMethod.POST).url(uploadPath).body((RequestBody)new FileRequestBody.Builder().meta(meta).fileName(fileName).file(fileBytes).build()).build();
        return (Task)this.httpClient.execute(request, Task.class).getServiceResponse();
    }

    public static class Builder {
        private HostName hostName;
        private HttpClient httpClient;
        private PrivacyEncryptor encryptor;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().credential(Objects.requireNonNull(config.createCredential())).validator(Objects.requireNonNull(config.createValidator())).build();
            this.encryptor = config.createEncryptor();
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder encryptor(PrivacyEncryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public MarketingBankPackagesServiceExtension build() {
            return new MarketingBankPackagesServiceExtension(this.httpClient, this.hostName, this.encryptor);
        }
    }
}

