/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.engine;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.beetl.core.AntlrProgramBuilder;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.TemplateEngine;
import org.beetl.core.parser.BeetlAntlrErrorStrategy;
import org.beetl.core.parser.BeetlLexer;
import org.beetl.core.parser.BeetlParser;
import org.beetl.core.parser.SyntaxErrorListener;
import org.beetl.core.statement.Program;
import org.beetl.core.statement.ProgramMetaData;

public class DefaultTemplateEngine
implements TemplateEngine {
    BeetlAntlrErrorStrategy antlrErrorStrategy = new BeetlAntlrErrorStrategy();
    SyntaxErrorListener syntaxError = new SyntaxErrorListener();

    @Override
    public Program createProgram(Resource resource, Reader reader, Map<Integer, String> textMap, String cr, GroupTemplate gt) {
        ANTLRInputStream input;
        try {
            input = new ANTLRInputStream(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BeetlLexer lexer = new BeetlLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)this.syntaxError);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        BeetlParser parser = new BeetlParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)this.antlrErrorStrategy);
        BeetlParser.ProgContext tree = parser.prog();
        AntlrProgramBuilder pb = this.getAntlrBuilder(gt);
        ProgramMetaData data = pb.build((ParseTree)tree);
        Program program = new Program();
        program.metaData = data;
        program.res = resource;
        program.rs = resource;
        program.gt = gt;
        program.metaData.staticTextArray = new Object[textMap.size()];
        program.metaData.lineSeparator = cr;
        int i = 0;
        Configuration conf = gt.getConf();
        String charset = conf.getCharset();
        boolean byteOut = conf.isDirectByteOutput();
        for (Map.Entry<Integer, String> entry : textMap.entrySet()) {
            if (byteOut) {
                try {
                    program.metaData.staticTextArray[i++] = entry.getValue().getBytes(charset);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            program.metaData.staticTextArray[i++] = entry.getValue().toCharArray();
        }
        return program;
    }

    protected AntlrProgramBuilder getAntlrBuilder(GroupTemplate gt) {
        AntlrProgramBuilder pb = new AntlrProgramBuilder(gt);
        return pb;
    }
}

