/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;

class DownloadInputStream
extends InputStream {
    private InputStream in;
    private int length;
    private int sumRead;
    private double percent;
    private double previousPercent;
    Logger logger;

    public DownloadInputStream(InputStream inputStream, int length, Logger logger) throws IOException {
        this.in = inputStream;
        this.sumRead = 0;
        this.previousPercent = -10.0;
        this.length = length;
        this.logger = logger;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int readCount = this.in.read(b);
        this.evaluatePercent(readCount);
        return readCount;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readCount = this.in.read(b, off, len);
        this.evaluatePercent(readCount);
        return readCount;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = this.in.skip(n);
        this.evaluatePercent(skip);
        return skip;
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        if (read != -1) {
            this.evaluatePercent(1L);
        }
        return read;
    }

    private void evaluatePercent(long readCount) {
        if (readCount != -1L) {
            this.sumRead = (int)((long)this.sumRead + readCount);
            this.percent = (double)this.sumRead * 0.01 / (double)this.length;
            if (this.percent > this.previousPercent + 10.0) {
                this.previousPercent = this.percent;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Downloading.. " + (int)this.percent + "%");
                } else {
                    System.out.println("Downloading.. " + (int)this.percent + "%");
                }
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Download finished");
        } else {
            System.out.println("Download finished");
        }
    }
}

