/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.annotation.TextAnnotation;
import com.ironsoftware.ironpdf.internal.proto.AddTextAnnotationRequest;
import com.ironsoftware.ironpdf.internal.proto.EmptyResult;
import com.ironsoftware.ironpdf.internal.proto.GetAnnotationCountRequest;
import com.ironsoftware.ironpdf.internal.proto.IntResult;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Annotation_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;

public final class Annotation_Api {
    public static void addTextAnnotation(InternalPdfDocument internalPdfDocument, TextAnnotation textAnnotation, int pageIndex, int x, int y, int width) {
        Annotation_Api.addTextAnnotation(internalPdfDocument, textAnnotation, pageIndex, x, y, width, 30);
    }

    public static void addTextAnnotation(InternalPdfDocument internalPdfDocument, TextAnnotation textAnnotation, int pageIndex, int x, int y, int width, int height) {
        RpcClient client = Access.ensureConnection();
        AddTextAnnotationRequest.Builder req = AddTextAnnotationRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setHeight(height);
        req.setPageIndex(pageIndex);
        req.setTextAnnotation(Annotation_Converter.toProto(textAnnotation));
        req.setWidth(width);
        req.setX(x);
        req.setY(y);
        EmptyResult res = client.blockingStub.pdfDocumentAnnotationAddTextAnnotation(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void addTextAnnotation(InternalPdfDocument internalPdfDocument, TextAnnotation textAnnotation, int pageIndex, int x, int y) {
        Annotation_Api.addTextAnnotation(internalPdfDocument, textAnnotation, pageIndex, x, y, 30, 30);
    }

    public static int getAnnotationCount(InternalPdfDocument internalPdfDocument, int pageIndex) {
        RpcClient client = Access.ensureConnection();
        GetAnnotationCountRequest.Builder req = GetAnnotationCountRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setPageIndex(pageIndex);
        IntResult res = client.blockingStub.pdfDocumentAnnotationGetAnnotationCountRequest(req.build());
        if (res.getResultOrExceptionCase() == IntResult.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        return res.getResult();
    }
}

