/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.internal.proto.EmptyResult;
import com.ironsoftware.ironpdf.internal.proto.ExtractAllTextRequest;
import com.ironsoftware.ironpdf.internal.proto.ReplaceTextRequest;
import com.ironsoftware.ironpdf.internal.proto.StringResult;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;

public final class Text_Api {
    public static String extractAllText(InternalPdfDocument internalPdfDocument) {
        return Text_Api.extractAllText(internalPdfDocument, null);
    }

    public static String extractAllText(InternalPdfDocument internalPdfDocument, Iterable<Integer> pageIndexes) {
        StringResult res;
        RpcClient client = Access.ensureConnection();
        ExtractAllTextRequest.Builder req = ExtractAllTextRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        if (pageIndexes != null) {
            req.addAllPageIndexes(pageIndexes);
        }
        if ((res = client.blockingStub.pdfDocumentTextExtractAllText(req.build())).getResultOrExceptionCase() == StringResult.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        return res.getResult();
    }

    public static void replaceTextOnPage(InternalPdfDocument internalPdfDocument, int pageIndex, String oldText, String newText) {
        RpcClient client = Access.ensureConnection();
        ReplaceTextRequest.Builder req = ReplaceTextRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setPageIndex(pageIndex);
        req.setCurrentText(oldText);
        req.setNewText(newText);
        EmptyResult res = client.blockingStub.pdfDocumentTextReplaceText(req.build());
        Utils_Util.handleEmptyResult(res);
    }
}

