/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.mac;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;

class MacPdfObject
extends PdfObjectWrapper<PdfDictionary> {
    MacPdfObject(int macContainerSize) {
        super(new PdfDictionary());
        PdfLiteral macPlaceholder = new PdfLiteral(macContainerSize);
        PdfLiteral byteRangePlaceholder = new PdfLiteral(80);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.MACLocation, PdfName.Standalone);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.MAC, macPlaceholder);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.ByteRange, byteRangePlaceholder);
    }

    long[] computeByteRange(long totalLength) {
        PdfLiteral macPlaceholder = this.getMacPlaceholder();
        long macStart = macPlaceholder.getPosition();
        long macLength = macPlaceholder.getBytesCount();
        long macEnd = macStart + macLength;
        return new long[]{0L, macStart, macEnd, totalLength - macEnd};
    }

    long getByteRangePosition() {
        return this.getByteRangePlaceholder().getPosition();
    }

    private PdfLiteral getMacPlaceholder() {
        PdfObject mac = ((PdfDictionary)this.getPdfObject()).get(PdfName.MAC);
        return (PdfLiteral)mac;
    }

    private PdfLiteral getByteRangePlaceholder() {
        PdfObject br = ((PdfDictionary)this.getPdfObject()).get(PdfName.ByteRange);
        return (PdfLiteral)br;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

