/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PdfNumTree {
    private static final int NODE_SIZE = 40;
    private PdfCatalog catalog;
    private Map<Integer, PdfObject> items = new HashMap<Integer, PdfObject>();
    private PdfName treeType;

    public PdfNumTree(PdfCatalog catalog, PdfName treeType) {
        this.treeType = treeType;
        this.catalog = catalog;
    }

    public Map<Integer, PdfObject> getNumbers() {
        PdfDictionary structTreeRoot;
        if (this.items.size() > 0) {
            return this.items;
        }
        PdfDictionary numbers = null;
        if (this.treeType.equals(PdfName.PageLabels)) {
            numbers = ((PdfDictionary)this.catalog.getPdfObject()).getAsDictionary(PdfName.PageLabels);
        } else if (this.treeType.equals(PdfName.ParentTree) && (structTreeRoot = ((PdfDictionary)this.catalog.getPdfObject()).getAsDictionary(PdfName.StructTreeRoot)) != null) {
            numbers = structTreeRoot.getAsDictionary(PdfName.ParentTree);
        }
        if (numbers != null) {
            this.readTree(numbers);
        }
        return this.items;
    }

    public void addEntry(int key, PdfObject value) {
        this.items.put(new Integer(key), value);
    }

    public PdfDictionary buildTree() {
        Object[] numbers = new Integer[this.items.size()];
        numbers = this.items.keySet().toArray(numbers);
        Arrays.sort(numbers);
        if (numbers.length <= 40) {
            PdfDictionary dic = new PdfDictionary();
            PdfArray ar = new PdfArray();
            for (Object number : numbers) {
                ar.add(new PdfNumber((Integer)number));
                ar.add(this.items.get(number));
            }
            dic.put(PdfName.Nums, ar);
            return dic;
        }
        int skip = 40;
        PdfDictionary[] kids = new PdfDictionary[(numbers.length + 40 - 1) / 40];
        for (int i = 0; i < kids.length; ++i) {
            int offset;
            int end = Math.min(offset + 40, numbers.length);
            PdfDictionary dic = new PdfDictionary();
            PdfArray arr = new PdfArray();
            arr.add(new PdfNumber((Integer)numbers[offset]));
            arr.add(new PdfNumber((Integer)numbers[end - 1]));
            dic.put(PdfName.Limits, arr);
            arr = new PdfArray();
            for (offset = i * 40; offset < end; ++offset) {
                arr.add(new PdfNumber((Integer)numbers[offset]));
                arr.add(this.items.get(numbers[offset]));
            }
            dic.put(PdfName.Nums, arr);
            dic.makeIndirect(this.catalog.getDocument());
            kids[i] = dic;
        }
        int top = kids.length;
        while (true) {
            int k;
            if (top <= 40) {
                PdfArray arr = new PdfArray();
                for (k = 0; k < top; ++k) {
                    arr.add(kids[k]);
                }
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.Kids, arr);
                return dic;
            }
            int tt = (numbers.length + (skip *= 40) - 1) / skip;
            for (k = 0; k < tt; ++k) {
                int offset;
                int end = Math.min(offset + 40, top);
                PdfDictionary dic = (PdfDictionary)new PdfDictionary().makeIndirect(this.catalog.getDocument());
                PdfArray arr = new PdfArray();
                arr.add(new PdfNumber((Integer)numbers[k * skip]));
                arr.add(new PdfNumber((Integer)numbers[Math.min((k + 1) * skip, numbers.length) - 1]));
                dic.put(PdfName.Limits, arr);
                arr = new PdfArray();
                for (offset = k * 40; offset < end; ++offset) {
                    arr.add(kids[offset]);
                }
                dic.put(PdfName.Kids, arr);
                kids[k] = dic;
            }
            top = tt;
        }
    }

    private void readTree(PdfDictionary dictionary) {
        if (dictionary != null) {
            this.iterateItems(dictionary, null);
        }
    }

    private PdfNumber iterateItems(PdfDictionary dictionary, PdfNumber leftOver) {
        block6: {
            PdfArray nums;
            block5: {
                nums = dictionary.getAsArray(PdfName.Nums);
                if (nums == null) break block5;
                for (int k = 0; k < nums.size(); ++k) {
                    PdfNumber number;
                    if (leftOver == null) {
                        number = nums.getAsNumber(k++);
                    } else {
                        number = leftOver;
                        leftOver = null;
                    }
                    if (k >= nums.size()) {
                        return number;
                    }
                    this.items.put(number.intValue(), nums.get(k));
                }
                break block6;
            }
            nums = dictionary.getAsArray(PdfName.Kids);
            if (nums == null) break block6;
            for (int k = 0; k < nums.size(); ++k) {
                PdfDictionary kid = nums.getAsDictionary(k);
                leftOver = this.iterateItems(kid, leftOver);
            }
        }
        return null;
    }
}

