/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.clipper;

import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Subpath;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.ClipperOffset;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.IClipper;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.LongRect;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Path;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Point;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.PolyNode;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.PolyTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class ClipperBridge {
    private static final long MAX_ALLOWED_VALUE = 0x3FFFFFFFFFFFFFL;
    public static Double floatMultiplier;
    private double approximatedFloatMultiplier = Math.pow(10.0, 14.0);

    public ClipperBridge() {
    }

    public ClipperBridge(com.itextpdf.kernel.geom.Path ... paths) {
        if (floatMultiplier == null) {
            ArrayList<Point> pointsList = new ArrayList<Point>();
            for (com.itextpdf.kernel.geom.Path path : paths) {
                for (Subpath subpath : path.getSubpaths()) {
                    if (subpath.isSinglePointClosed() || subpath.isSinglePointOpen()) continue;
                    pointsList.addAll(subpath.getPiecewiseLinearApproximation());
                }
            }
            this.calculateFloatMultiplier(new Point[][]{pointsList.toArray(new Point[0])});
        }
    }

    public ClipperBridge(Point[] ... points) {
        if (floatMultiplier == null) {
            this.calculateFloatMultiplier(points);
        }
    }

    public com.itextpdf.kernel.geom.Path convertToPath(PolyTree result) {
        com.itextpdf.kernel.geom.Path path = new com.itextpdf.kernel.geom.Path();
        for (PolyNode node = result.getFirst(); node != null; node = node.getNext()) {
            this.addContour(path, node.getContour(), !node.isOpen());
        }
        return path;
    }

    public void addPath(IClipper clipper, com.itextpdf.kernel.geom.Path path, IClipper.PolyType polyType) {
        for (Subpath subpath : path.getSubpaths()) {
            if (subpath.isSinglePointClosed() || subpath.isSinglePointOpen()) continue;
            List<Point> linearApproxPoints = subpath.getPiecewiseLinearApproximation();
            clipper.addPath(new Path((Collection<? extends Point.LongPoint>)this.convertToLongPoints(linearApproxPoints)), polyType, subpath.isClosed());
        }
    }

    public List<Subpath> addPath(ClipperOffset offset, com.itextpdf.kernel.geom.Path path, IClipper.JoinType joinType, IClipper.EndType endType) {
        ArrayList<Subpath> degenerateSubpaths = new ArrayList<Subpath>();
        for (Subpath subpath : path.getSubpaths()) {
            if (subpath.isDegenerate()) {
                degenerateSubpaths.add(subpath);
                continue;
            }
            if (subpath.isSinglePointClosed() || subpath.isSinglePointOpen()) continue;
            IClipper.EndType et = subpath.isClosed() ? IClipper.EndType.CLOSED_LINE : endType;
            List<Point> linearApproxPoints = subpath.getPiecewiseLinearApproximation();
            offset.addPath(new Path((Collection<? extends Point.LongPoint>)this.convertToLongPoints(linearApproxPoints)), joinType, et);
        }
        return degenerateSubpaths;
    }

    public List<Point> convertToFloatPoints(List<Point.LongPoint> points) {
        ArrayList<Point> convertedPoints = new ArrayList<Point>(points.size());
        for (Point.LongPoint point : points) {
            convertedPoints.add(new Point((double)point.getX() / this.getFloatMultiplier(), (double)point.getY() / this.getFloatMultiplier()));
        }
        return convertedPoints;
    }

    public List<Point.LongPoint> convertToLongPoints(List<Point> points) {
        ArrayList<Point.LongPoint> convertedPoints = new ArrayList<Point.LongPoint>(points.size());
        for (Point point : points) {
            convertedPoints.add(new Point.LongPoint(this.getFloatMultiplier() * point.getX(), this.getFloatMultiplier() * point.getY()));
        }
        return convertedPoints;
    }

    public static IClipper.JoinType getJoinType(int lineJoinStyle) {
        switch (lineJoinStyle) {
            case 2: {
                return IClipper.JoinType.BEVEL;
            }
            case 0: {
                return IClipper.JoinType.MITER;
            }
        }
        return IClipper.JoinType.ROUND;
    }

    public static IClipper.EndType getEndType(int lineCapStyle) {
        switch (lineCapStyle) {
            case 0: {
                return IClipper.EndType.OPEN_BUTT;
            }
            case 2: {
                return IClipper.EndType.OPEN_SQUARE;
            }
        }
        return IClipper.EndType.OPEN_ROUND;
    }

    public static IClipper.PolyFillType getFillType(int fillingRule) {
        IClipper.PolyFillType fillType = IClipper.PolyFillType.NON_ZERO;
        if (fillingRule == 2) {
            fillType = IClipper.PolyFillType.EVEN_ODD;
        }
        return fillType;
    }

    public boolean addPolygonToClipper(IClipper clipper, Point[] polyVertices, IClipper.PolyType polyType) {
        return clipper.addPath(new Path((Collection<? extends Point.LongPoint>)this.convertToLongPoints(new ArrayList<Point>(Arrays.asList(polyVertices)))), polyType, true);
    }

    public boolean addPolylineSubjectToClipper(IClipper clipper, Point[] lineVertices) {
        return clipper.addPath(new Path((Collection<? extends Point.LongPoint>)this.convertToLongPoints(new ArrayList<Point>(Arrays.asList(lineVertices)))), IClipper.PolyType.SUBJECT, false);
    }

    public float longRectCalculateWidth(LongRect rect) {
        return (float)((double)Math.abs(rect.left - rect.right) / this.getFloatMultiplier());
    }

    public float longRectCalculateHeight(LongRect rect) {
        return (float)((double)Math.abs(rect.top - rect.bottom) / this.getFloatMultiplier());
    }

    public double getFloatMultiplier() {
        if (floatMultiplier == null) {
            return this.approximatedFloatMultiplier;
        }
        return floatMultiplier;
    }

    void addContour(com.itextpdf.kernel.geom.Path path, List<Point.LongPoint> contour, boolean close) {
        List<Point> floatContour = this.convertToFloatPoints(contour);
        Point point = floatContour.get(0);
        path.moveTo((float)point.getX(), (float)point.getY());
        for (int i = 1; i < floatContour.size(); ++i) {
            point = floatContour.get(i);
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        if (close) {
            path.closeSubpath();
        }
    }

    private void calculateFloatMultiplier(Point[] ... points) {
        double maxPoint = 0.0;
        Point[][] pointArray = points;
        int n = pointArray.length;
        for (int i = 0; i < n; ++i) {
            Point[] pointsArray;
            for (Point point : pointsArray = pointArray[i]) {
                maxPoint = Math.max(maxPoint, Math.abs(point.getX()));
                maxPoint = Math.max(maxPoint, Math.abs(point.getY()));
            }
        }
        double epsilon = 1.0E-16;
        if (maxPoint > epsilon) {
            this.approximatedFloatMultiplier = Math.floor(1.8014398509481984E16 / maxPoint);
        }
    }
}

