/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.layer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.layer.IPdfOCG;
import com.itextpdf.kernel.pdf.layer.PdfOCProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PdfLayer
extends PdfObjectWrapper<PdfDictionary>
implements IPdfOCG {
    protected String title;
    protected boolean on = true;
    protected boolean onPanel = true;
    protected boolean locked = false;
    protected PdfLayer parent;
    protected List<PdfLayer> children;

    public PdfLayer(PdfDictionary layerDictionary) {
        super(layerDictionary);
        this.setForbidRelease();
        PdfLayer.ensureObjectIsAddedToDocument(layerDictionary);
    }

    public PdfLayer(String name, PdfDocument document) {
        this(document);
        this.setName(name);
        document.getCatalog().getOCProperties(true).registerLayer(this);
    }

    private PdfLayer(PdfDocument document) {
        super(new PdfDictionary());
        this.makeIndirect(document);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.OCG);
    }

    public static PdfLayer createTitle(String title, PdfDocument document) {
        PdfLayer layer = PdfLayer.createTitleSilent(title, document);
        document.getCatalog().getOCProperties(true).registerLayer(layer);
        return layer;
    }

    public static void addOCGRadioGroup(PdfDocument document, List<PdfLayer> group) {
        document.getCatalog().getOCProperties(true).addOCGRadioGroup(group);
    }

    public void addChild(PdfLayer childLayer) {
        if (childLayer.parent != null) {
            PdfIndirectReference ref = childLayer.getIndirectReference();
            throw new PdfException(MessageFormatUtil.format((String)"Unable to add second parent layer to {0} ocg layer", (Object[])new Object[]{ref.toString()}));
        }
        childLayer.parent = this;
        if (this.children == null) {
            this.children = new ArrayList<PdfLayer>();
        }
        this.children.add(childLayer);
    }

    public PdfLayer getParent() {
        return this.parent;
    }

    public void setName(String name) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Name, new PdfString(name, "UnicodeBig"));
        ((PdfDictionary)this.getPdfObject()).setModified();
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        if (this.on != on) {
            this.fetchOCProperties().setModified();
        }
        this.on = on;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        if (this.isLocked() != locked) {
            this.fetchOCProperties().setModified();
        }
        this.locked = locked;
    }

    public boolean isOnPanel() {
        return this.onPanel;
    }

    public void setOnPanel(boolean onPanel) {
        if (this.on != onPanel) {
            this.fetchOCProperties().setModified();
        }
        this.onPanel = onPanel;
    }

    public Collection<PdfName> getIntents() {
        PdfObject intent = ((PdfDictionary)this.getPdfObject()).get(PdfName.Intent);
        if (intent instanceof PdfName) {
            return Collections.singletonList((PdfName)intent);
        }
        if (intent instanceof PdfArray) {
            PdfArray intentArr = (PdfArray)intent;
            ArrayList<PdfName> intentsCollection = new ArrayList<PdfName>(intentArr.size());
            for (PdfObject i : intentArr) {
                if (!(i instanceof PdfName)) continue;
                intentsCollection.add((PdfName)i);
            }
            return intentsCollection;
        }
        return Collections.singletonList(PdfName.View);
    }

    public void setIntents(List<PdfName> intents) {
        if (intents == null || intents.size() == 0) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.Intent);
        } else if (intents.size() == 1) {
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Intent, intents.get(0));
        } else {
            PdfArray array = new PdfArray();
            for (PdfName intent : intents) {
                array.add(intent);
            }
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Intent, array);
        }
        ((PdfDictionary)this.getPdfObject()).setModified();
    }

    public void setCreatorInfo(String creator, String subtype) {
        PdfDictionary usage = this.getUsage();
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.Creator, new PdfString(creator, "UnicodeBig"));
        dic.put(PdfName.Subtype, new PdfName(subtype));
        usage.put(PdfName.CreatorInfo, dic);
        usage.setModified();
    }

    public void setLanguage(String lang, boolean preferred) {
        PdfDictionary usage = this.getUsage();
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.Lang, new PdfString(lang, "UnicodeBig"));
        if (preferred) {
            dic.put(PdfName.Preferred, PdfName.ON);
        }
        usage.put(PdfName.Language, dic);
        usage.setModified();
    }

    public void setExport(boolean export) {
        PdfDictionary usage = this.getUsage();
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.ExportState, export ? PdfName.ON : PdfName.OFF);
        usage.put(PdfName.Export, dic);
        usage.setModified();
    }

    public void setZoom(float min, float max) {
        if (min <= 0.0f && max < 0.0f) {
            return;
        }
        PdfDictionary usage = this.getUsage();
        PdfDictionary dic = new PdfDictionary();
        if (min > 0.0f) {
            dic.put(PdfName.min, new PdfNumber(min));
        }
        if (max >= 0.0f) {
            dic.put(PdfName.max, new PdfNumber(max));
        }
        usage.put(PdfName.Zoom, dic);
        usage.setModified();
    }

    public void setPrint(String subtype, boolean printState) {
        PdfDictionary usage = this.getUsage();
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.Subtype, new PdfName(subtype));
        dic.put(PdfName.PrintState, printState ? PdfName.ON : PdfName.OFF);
        usage.put(PdfName.Print, dic);
        usage.setModified();
    }

    public void setView(boolean view) {
        PdfDictionary usage = this.getUsage();
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.ViewState, view ? PdfName.ON : PdfName.OFF);
        usage.put(PdfName.View, dic);
        usage.setModified();
    }

    public void setUser(String type, String ... names) {
        if (type == null || !"Ind".equals(type) && !"Ttl".equals(type) && !"Org".equals(type)) {
            throw new IllegalArgumentException("Illegal type argument");
        }
        if (names == null || names.length == 0) {
            throw new IllegalArgumentException("Illegal names argument");
        }
        PdfDictionary usage = this.getUsage();
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.Type, new PdfName(type));
        if (names.length == 1) {
            dic.put(PdfName.Name, new PdfString(names[0], "UnicodeBig"));
        } else {
            PdfArray namesArray = new PdfArray();
            for (String name : names) {
                namesArray.add(new PdfString(name, "UnicodeBig"));
            }
            dic.put(PdfName.Name, namesArray);
        }
        usage.put(PdfName.User, dic);
        usage.setModified();
    }

    public void setPageElement(String pe) {
        PdfDictionary usage = this.getUsage();
        PdfDictionary dic = new PdfDictionary();
        dic.put(PdfName.Subtype, new PdfName(pe));
        usage.put(PdfName.PageElement, dic);
        usage.setModified();
    }

    @Override
    public PdfIndirectReference getIndirectReference() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference();
    }

    public String getTitle() {
        return this.title;
    }

    public List<PdfLayer> getChildren() {
        return this.children == null ? null : new ArrayList<PdfLayer>(this.children);
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected PdfDocument getDocument() {
        return ((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument();
    }

    protected static PdfLayer createTitleSilent(String title, PdfDocument document) {
        if (title == null) {
            throw new IllegalArgumentException("Invalid title argument");
        }
        PdfLayer layer = new PdfLayer(document);
        layer.title = title;
        return layer;
    }

    protected PdfDictionary getUsage() {
        PdfDictionary usage = ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Usage);
        if (usage == null) {
            usage = new PdfDictionary();
            ((PdfDictionary)this.getPdfObject()).put(PdfName.Usage, usage);
        }
        return usage;
    }

    private PdfOCProperties fetchOCProperties() {
        return this.getDocument().getCatalog().getOCProperties(true);
    }
}

